/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.notification;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.model.IGs2Credential;
import io.gs2.notification.control.CreateNotificationRequest;
import io.gs2.notification.control.CreateNotificationResult;
import io.gs2.notification.control.CreateSubscribeRequest;
import io.gs2.notification.control.CreateSubscribeResult;
import io.gs2.notification.control.DeleteNotificationRequest;
import io.gs2.notification.control.DeleteSubscribeRequest;
import io.gs2.notification.control.DescribeNotificationRequest;
import io.gs2.notification.control.DescribeNotificationResult;
import io.gs2.notification.control.DescribeSubscribeRequest;
import io.gs2.notification.control.DescribeSubscribeResult;
import io.gs2.notification.control.GetNotificationRequest;
import io.gs2.notification.control.GetNotificationResult;
import io.gs2.notification.control.GetSubscribeRequest;
import io.gs2.notification.control.GetSubscribeResult;
import io.gs2.notification.control.UpdateNotificationRequest;
import io.gs2.notification.control.UpdateNotificationResult;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2NotificationClient
extends AbstractGs2Client<Gs2NotificationClient> {
    public static String ENDPOINT = "notification";

    public Gs2NotificationClient(IGs2Credential credential) {
        super(credential);
    }

    public CreateNotificationResult createNotification(CreateNotificationRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName()).put("description", request.getDescription());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/notification", this.credential, ENDPOINT, "Gs2Notification", "CreateNotification", body.toString());
        return (CreateNotificationResult)this.doRequest((HttpUriRequest)post, CreateNotificationResult.class);
    }

    public DescribeNotificationResult describeNotification(DescribeNotificationRequest request) {
        String url = "https://{service}.{region}.gs2.io/notification";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", request.getPageToken()));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Notification", "DescribeNotification");
        return (DescribeNotificationResult)this.doRequest((HttpUriRequest)get, DescribeNotificationResult.class);
    }

    public GetNotificationResult getNotification(GetNotificationRequest request) {
        HttpGet get = this.createHttpGet("https://{service}.{region}.gs2.io/notification/" + request.getNotificationName(), this.credential, ENDPOINT, "Gs2Notification", "GetNotification");
        return (GetNotificationResult)this.doRequest((HttpUriRequest)get, GetNotificationResult.class);
    }

    public UpdateNotificationResult updateNotification(UpdateNotificationRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("description", request.getDescription());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/notification/" + request.getNotificationName(), this.credential, ENDPOINT, "Gs2Notification", "UpdateNotification", body.toString());
        return (UpdateNotificationResult)this.doRequest((HttpUriRequest)put, UpdateNotificationResult.class);
    }

    public void deleteNotification(DeleteNotificationRequest request) {
        HttpDelete delete = this.createHttpDelete("https://{service}.{region}.gs2.io/notification/" + request.getNotificationName(), this.credential, ENDPOINT, "Gs2Notification", "DeleteNotification");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public CreateSubscribeResult createSubscribe(CreateSubscribeRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getNotificationName()).put("type", request.getType()).put("endpoint", request.getEndpoint());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/notification/" + request.getNotificationName() + "/subscribe", this.credential, ENDPOINT, "Gs2Notification", "CreateSubscribe", body.toString());
        return (CreateSubscribeResult)this.doRequest((HttpUriRequest)post, CreateSubscribeResult.class);
    }

    public DescribeSubscribeResult describeSubscribe(DescribeSubscribeRequest request) {
        String url = "https://{service}.{region}.gs2.io/notification/" + request.getNotificationName() + "/subscribe";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", request.getPageToken()));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Notification", "DescribeSubscribe");
        return (DescribeSubscribeResult)this.doRequest((HttpUriRequest)get, DescribeSubscribeResult.class);
    }

    public GetSubscribeResult getSubscribe(GetSubscribeRequest request) {
        HttpGet get = this.createHttpGet("https://{service}.{region}.gs2.io/notification/" + request.getNotificationName() + "/subscribe/" + request.getSubscribeId(), this.credential, ENDPOINT, "Gs2Notification", "GetSubscribe");
        return (GetSubscribeResult)this.doRequest((HttpUriRequest)get, GetSubscribeResult.class);
    }

    public void deleteSubscribe(DeleteSubscribeRequest request) {
        HttpDelete delete = this.createHttpDelete("https://{service}.{region}.gs2.io/notification/" + request.getNotificationName() + "/subscribe/" + request.getSubscribeId(), this.credential, ENDPOINT, "Gs2Notification", "DeleteSubscribe");
        this.doRequest((HttpUriRequest)delete, null);
    }
}

