/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.AbstractGs2Client;
import io.gs2.model.AsyncAction;
import io.gs2.model.AsyncResult;
import io.gs2.net.Gs2RestSession;
import io.gs2.net.Gs2RestSessionTask;
import io.gs2.net.Gs2Session;
import io.gs2.net.Gs2SessionTask;
import io.gs2.net.HttpTask;
import io.gs2.net.IResponseHandler;
import io.gs2.schedule.request.CreateEventMasterRequest;
import io.gs2.schedule.request.CreateNamespaceRequest;
import io.gs2.schedule.request.DeleteEventMasterRequest;
import io.gs2.schedule.request.DeleteNamespaceRequest;
import io.gs2.schedule.request.DeleteTriggerByUserIdRequest;
import io.gs2.schedule.request.DeleteTriggerRequest;
import io.gs2.schedule.request.DescribeEventMastersRequest;
import io.gs2.schedule.request.DescribeEventsByUserIdRequest;
import io.gs2.schedule.request.DescribeEventsRequest;
import io.gs2.schedule.request.DescribeNamespacesRequest;
import io.gs2.schedule.request.DescribeRawEventsRequest;
import io.gs2.schedule.request.DescribeTriggersByUserIdRequest;
import io.gs2.schedule.request.DescribeTriggersRequest;
import io.gs2.schedule.request.ExportMasterRequest;
import io.gs2.schedule.request.GetCurrentEventMasterRequest;
import io.gs2.schedule.request.GetEventByUserIdRequest;
import io.gs2.schedule.request.GetEventMasterRequest;
import io.gs2.schedule.request.GetEventRequest;
import io.gs2.schedule.request.GetNamespaceRequest;
import io.gs2.schedule.request.GetNamespaceStatusRequest;
import io.gs2.schedule.request.GetRawEventRequest;
import io.gs2.schedule.request.GetTriggerByUserIdRequest;
import io.gs2.schedule.request.GetTriggerRequest;
import io.gs2.schedule.request.TriggerByUserIdRequest;
import io.gs2.schedule.request.UpdateCurrentEventMasterRequest;
import io.gs2.schedule.request.UpdateEventMasterRequest;
import io.gs2.schedule.request.UpdateNamespaceRequest;
import io.gs2.schedule.result.CreateEventMasterResult;
import io.gs2.schedule.result.CreateNamespaceResult;
import io.gs2.schedule.result.DeleteEventMasterResult;
import io.gs2.schedule.result.DeleteNamespaceResult;
import io.gs2.schedule.result.DeleteTriggerByUserIdResult;
import io.gs2.schedule.result.DeleteTriggerResult;
import io.gs2.schedule.result.DescribeEventMastersResult;
import io.gs2.schedule.result.DescribeEventsByUserIdResult;
import io.gs2.schedule.result.DescribeEventsResult;
import io.gs2.schedule.result.DescribeNamespacesResult;
import io.gs2.schedule.result.DescribeRawEventsResult;
import io.gs2.schedule.result.DescribeTriggersByUserIdResult;
import io.gs2.schedule.result.DescribeTriggersResult;
import io.gs2.schedule.result.ExportMasterResult;
import io.gs2.schedule.result.GetCurrentEventMasterResult;
import io.gs2.schedule.result.GetEventByUserIdResult;
import io.gs2.schedule.result.GetEventMasterResult;
import io.gs2.schedule.result.GetEventResult;
import io.gs2.schedule.result.GetNamespaceResult;
import io.gs2.schedule.result.GetNamespaceStatusResult;
import io.gs2.schedule.result.GetRawEventResult;
import io.gs2.schedule.result.GetTriggerByUserIdResult;
import io.gs2.schedule.result.GetTriggerResult;
import io.gs2.schedule.result.TriggerByUserIdResult;
import io.gs2.schedule.result.UpdateCurrentEventMasterResult;
import io.gs2.schedule.result.UpdateEventMasterResult;
import io.gs2.schedule.result.UpdateNamespaceResult;
import io.gs2.util.EncodingUtil;
import java.util.ArrayList;
import org.json.JSONObject;

public class Gs2ScheduleRestClient
extends AbstractGs2Client<Gs2ScheduleRestClient> {
    public Gs2ScheduleRestClient(Gs2RestSession gs2RestSession) {
        super((Gs2Session)gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback, DescribeNamespacesResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, (AsyncAction<AsyncResult<DescribeNamespacesResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback, CreateNamespaceResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, (AsyncAction<AsyncResult<CreateNamespaceResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback, GetNamespaceStatusResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, (AsyncAction<AsyncResult<GetNamespaceStatusResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback, GetNamespaceResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, (AsyncAction<AsyncResult<GetNamespaceResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback, UpdateNamespaceResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, (AsyncAction<AsyncResult<UpdateNamespaceResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback, DeleteNamespaceResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, (AsyncAction<AsyncResult<DeleteNamespaceResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeEventMastersAsync(DescribeEventMastersRequest request, AsyncAction<AsyncResult<DescribeEventMastersResult>> callback) {
        DescribeEventMastersTask task = new DescribeEventMastersTask(request, callback, DescribeEventMastersResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeEventMastersResult describeEventMasters(DescribeEventMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEventMastersAsync(request, (AsyncAction<AsyncResult<DescribeEventMastersResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEventMastersResult)resultAsyncResult[0].getResult();
    }

    public void createEventMasterAsync(CreateEventMasterRequest request, AsyncAction<AsyncResult<CreateEventMasterResult>> callback) {
        CreateEventMasterTask task = new CreateEventMasterTask(request, callback, CreateEventMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public CreateEventMasterResult createEventMaster(CreateEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createEventMasterAsync(request, (AsyncAction<AsyncResult<CreateEventMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void getEventMasterAsync(GetEventMasterRequest request, AsyncAction<AsyncResult<GetEventMasterResult>> callback) {
        GetEventMasterTask task = new GetEventMasterTask(request, callback, GetEventMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetEventMasterResult getEventMaster(GetEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEventMasterAsync(request, (AsyncAction<AsyncResult<GetEventMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateEventMasterAsync(UpdateEventMasterRequest request, AsyncAction<AsyncResult<UpdateEventMasterResult>> callback) {
        UpdateEventMasterTask task = new UpdateEventMasterTask(request, callback, UpdateEventMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public UpdateEventMasterResult updateEventMaster(UpdateEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateEventMasterAsync(request, (AsyncAction<AsyncResult<UpdateEventMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteEventMasterAsync(DeleteEventMasterRequest request, AsyncAction<AsyncResult<DeleteEventMasterResult>> callback) {
        DeleteEventMasterTask task = new DeleteEventMasterTask(request, callback, DeleteEventMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DeleteEventMasterResult deleteEventMaster(DeleteEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteEventMasterAsync(request, (AsyncAction<AsyncResult<DeleteEventMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeTriggersAsync(DescribeTriggersRequest request, AsyncAction<AsyncResult<DescribeTriggersResult>> callback) {
        DescribeTriggersTask task = new DescribeTriggersTask(request, callback, DescribeTriggersResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeTriggersResult describeTriggers(DescribeTriggersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeTriggersAsync(request, (AsyncAction<AsyncResult<DescribeTriggersResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeTriggersResult)resultAsyncResult[0].getResult();
    }

    public void describeTriggersByUserIdAsync(DescribeTriggersByUserIdRequest request, AsyncAction<AsyncResult<DescribeTriggersByUserIdResult>> callback) {
        DescribeTriggersByUserIdTask task = new DescribeTriggersByUserIdTask(request, callback, DescribeTriggersByUserIdResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeTriggersByUserIdResult describeTriggersByUserId(DescribeTriggersByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeTriggersByUserIdAsync(request, (AsyncAction<AsyncResult<DescribeTriggersByUserIdResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeTriggersByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getTriggerAsync(GetTriggerRequest request, AsyncAction<AsyncResult<GetTriggerResult>> callback) {
        GetTriggerTask task = new GetTriggerTask(request, callback, GetTriggerResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetTriggerResult getTrigger(GetTriggerRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getTriggerAsync(request, (AsyncAction<AsyncResult<GetTriggerResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetTriggerResult)resultAsyncResult[0].getResult();
    }

    public void getTriggerByUserIdAsync(GetTriggerByUserIdRequest request, AsyncAction<AsyncResult<GetTriggerByUserIdResult>> callback) {
        GetTriggerByUserIdTask task = new GetTriggerByUserIdTask(request, callback, GetTriggerByUserIdResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetTriggerByUserIdResult getTriggerByUserId(GetTriggerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getTriggerByUserIdAsync(request, (AsyncAction<AsyncResult<GetTriggerByUserIdResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetTriggerByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void triggerByUserIdAsync(TriggerByUserIdRequest request, AsyncAction<AsyncResult<TriggerByUserIdResult>> callback) {
        TriggerByUserIdTask task = new TriggerByUserIdTask(request, callback, TriggerByUserIdResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public TriggerByUserIdResult triggerByUserId(TriggerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.triggerByUserIdAsync(request, (AsyncAction<AsyncResult<TriggerByUserIdResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (TriggerByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteTriggerAsync(DeleteTriggerRequest request, AsyncAction<AsyncResult<DeleteTriggerResult>> callback) {
        DeleteTriggerTask task = new DeleteTriggerTask(request, callback, DeleteTriggerResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DeleteTriggerResult deleteTrigger(DeleteTriggerRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteTriggerAsync(request, (AsyncAction<AsyncResult<DeleteTriggerResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteTriggerResult)resultAsyncResult[0].getResult();
    }

    public void deleteTriggerByUserIdAsync(DeleteTriggerByUserIdRequest request, AsyncAction<AsyncResult<DeleteTriggerByUserIdResult>> callback) {
        DeleteTriggerByUserIdTask task = new DeleteTriggerByUserIdTask(request, callback, DeleteTriggerByUserIdResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DeleteTriggerByUserIdResult deleteTriggerByUserId(DeleteTriggerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteTriggerByUserIdAsync(request, (AsyncAction<AsyncResult<DeleteTriggerByUserIdResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteTriggerByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeEventsAsync(DescribeEventsRequest request, AsyncAction<AsyncResult<DescribeEventsResult>> callback) {
        DescribeEventsTask task = new DescribeEventsTask(request, callback, DescribeEventsResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeEventsResult describeEvents(DescribeEventsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEventsAsync(request, (AsyncAction<AsyncResult<DescribeEventsResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEventsResult)resultAsyncResult[0].getResult();
    }

    public void describeEventsByUserIdAsync(DescribeEventsByUserIdRequest request, AsyncAction<AsyncResult<DescribeEventsByUserIdResult>> callback) {
        DescribeEventsByUserIdTask task = new DescribeEventsByUserIdTask(request, callback, DescribeEventsByUserIdResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeEventsByUserIdResult describeEventsByUserId(DescribeEventsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEventsByUserIdAsync(request, (AsyncAction<AsyncResult<DescribeEventsByUserIdResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEventsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeRawEventsAsync(DescribeRawEventsRequest request, AsyncAction<AsyncResult<DescribeRawEventsResult>> callback) {
        DescribeRawEventsTask task = new DescribeRawEventsTask(request, callback, DescribeRawEventsResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeRawEventsResult describeRawEvents(DescribeRawEventsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRawEventsAsync(request, (AsyncAction<AsyncResult<DescribeRawEventsResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRawEventsResult)resultAsyncResult[0].getResult();
    }

    public void getEventAsync(GetEventRequest request, AsyncAction<AsyncResult<GetEventResult>> callback) {
        GetEventTask task = new GetEventTask(request, callback, GetEventResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetEventResult getEvent(GetEventRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEventAsync(request, (AsyncAction<AsyncResult<GetEventResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEventResult)resultAsyncResult[0].getResult();
    }

    public void getEventByUserIdAsync(GetEventByUserIdRequest request, AsyncAction<AsyncResult<GetEventByUserIdResult>> callback) {
        GetEventByUserIdTask task = new GetEventByUserIdTask(request, callback, GetEventByUserIdResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetEventByUserIdResult getEventByUserId(GetEventByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEventByUserIdAsync(request, (AsyncAction<AsyncResult<GetEventByUserIdResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEventByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getRawEventAsync(GetRawEventRequest request, AsyncAction<AsyncResult<GetRawEventResult>> callback) {
        GetRawEventTask task = new GetRawEventTask(request, callback, GetRawEventResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetRawEventResult getRawEvent(GetRawEventRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRawEventAsync(request, (AsyncAction<AsyncResult<GetRawEventResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRawEventResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback, ExportMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, (AsyncAction<AsyncResult<ExportMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentEventMasterAsync(GetCurrentEventMasterRequest request, AsyncAction<AsyncResult<GetCurrentEventMasterResult>> callback) {
        GetCurrentEventMasterTask task = new GetCurrentEventMasterTask(request, callback, GetCurrentEventMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetCurrentEventMasterResult getCurrentEventMaster(GetCurrentEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentEventMasterAsync(request, (AsyncAction<AsyncResult<GetCurrentEventMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentEventMasterAsync(UpdateCurrentEventMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentEventMasterResult>> callback) {
        UpdateCurrentEventMasterTask task = new UpdateCurrentEventMasterTask(request, callback, UpdateCurrentEventMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public UpdateCurrentEventMasterResult updateCurrentEventMaster(UpdateCurrentEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentEventMasterAsync(request, (AsyncAction<AsyncResult<UpdateCurrentEventMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentEventMasterResult)resultAsyncResult[0].getResult();
    }

    class UpdateCurrentEventMasterTask
    extends Gs2RestSessionTask<UpdateCurrentEventMasterResult> {
        private UpdateCurrentEventMasterRequest request;

        public UpdateCurrentEventMasterTask(UpdateCurrentEventMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentEventMasterResult>> userCallback, Class<UpdateCurrentEventMasterResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getSettings() != null) {
                json.put("settings", (Object)this.request.getSettings());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentEventMasterTask
    extends Gs2RestSessionTask<GetCurrentEventMasterResult> {
        private GetCurrentEventMasterRequest request;

        public GetCurrentEventMasterTask(GetCurrentEventMasterRequest request, AsyncAction<AsyncResult<GetCurrentEventMasterResult>> userCallback, Class<GetCurrentEventMasterResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback, Class<ExportMasterResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRawEventTask
    extends Gs2RestSessionTask<GetRawEventResult> {
        private GetRawEventRequest request;

        public GetRawEventTask(GetRawEventRequest request, AsyncAction<AsyncResult<GetRawEventResult>> userCallback, Class<GetRawEventResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEventByUserIdTask
    extends Gs2RestSessionTask<GetEventByUserIdResult> {
        private GetEventByUserIdRequest request;

        public GetEventByUserIdTask(GetEventByUserIdRequest request, AsyncAction<AsyncResult<GetEventByUserIdResult>> userCallback, Class<GetEventByUserIdResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetEventTask
    extends Gs2RestSessionTask<GetEventResult> {
        private GetEventRequest request;

        public GetEventTask(GetEventRequest request, AsyncAction<AsyncResult<GetEventResult>> userCallback, Class<GetEventResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeRawEventsTask
    extends Gs2RestSessionTask<DescribeRawEventsResult> {
        private DescribeRawEventsRequest request;

        public DescribeRawEventsTask(DescribeRawEventsRequest request, AsyncAction<AsyncResult<DescribeRawEventsResult>> userCallback, Class<DescribeRawEventsResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeEventsByUserIdTask
    extends Gs2RestSessionTask<DescribeEventsByUserIdResult> {
        private DescribeEventsByUserIdRequest request;

        public DescribeEventsByUserIdTask(DescribeEventsByUserIdRequest request, AsyncAction<AsyncResult<DescribeEventsByUserIdResult>> userCallback, Class<DescribeEventsByUserIdResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeEventsTask
    extends Gs2RestSessionTask<DescribeEventsResult> {
        private DescribeEventsRequest request;

        public DescribeEventsTask(DescribeEventsRequest request, AsyncAction<AsyncResult<DescribeEventsResult>> userCallback, Class<DescribeEventsResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteTriggerByUserIdTask
    extends Gs2RestSessionTask<DeleteTriggerByUserIdResult> {
        private DeleteTriggerByUserIdRequest request;

        public DeleteTriggerByUserIdTask(DeleteTriggerByUserIdRequest request, AsyncAction<AsyncResult<DeleteTriggerByUserIdResult>> userCallback, Class<DeleteTriggerByUserIdResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteTriggerTask
    extends Gs2RestSessionTask<DeleteTriggerResult> {
        private DeleteTriggerRequest request;

        public DeleteTriggerTask(DeleteTriggerRequest request, AsyncAction<AsyncResult<DeleteTriggerResult>> userCallback, Class<DeleteTriggerResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class TriggerByUserIdTask
    extends Gs2RestSessionTask<TriggerByUserIdResult> {
        private TriggerByUserIdRequest request;

        public TriggerByUserIdTask(TriggerByUserIdRequest request, AsyncAction<AsyncResult<TriggerByUserIdResult>> userCallback, Class<TriggerByUserIdResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getTriggerStrategy() != null) {
                json.put("triggerStrategy", (Object)this.request.getTriggerStrategy());
            }
            if (this.request.getTtl() != null) {
                json.put("ttl", (Object)this.request.getTtl());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetTriggerByUserIdTask
    extends Gs2RestSessionTask<GetTriggerByUserIdResult> {
        private GetTriggerByUserIdRequest request;

        public GetTriggerByUserIdTask(GetTriggerByUserIdRequest request, AsyncAction<AsyncResult<GetTriggerByUserIdResult>> userCallback, Class<GetTriggerByUserIdResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetTriggerTask
    extends Gs2RestSessionTask<GetTriggerResult> {
        private GetTriggerRequest request;

        public GetTriggerTask(GetTriggerRequest request, AsyncAction<AsyncResult<GetTriggerResult>> userCallback, Class<GetTriggerResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeTriggersByUserIdTask
    extends Gs2RestSessionTask<DescribeTriggersByUserIdResult> {
        private DescribeTriggersByUserIdRequest request;

        public DescribeTriggersByUserIdTask(DescribeTriggersByUserIdRequest request, AsyncAction<AsyncResult<DescribeTriggersByUserIdResult>> userCallback, Class<DescribeTriggersByUserIdResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode((String)String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeTriggersTask
    extends Gs2RestSessionTask<DescribeTriggersResult> {
        private DescribeTriggersRequest request;

        public DescribeTriggersTask(DescribeTriggersRequest request, AsyncAction<AsyncResult<DescribeTriggersResult>> userCallback, Class<DescribeTriggersResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/trigger";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode((String)String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteEventMasterTask
    extends Gs2RestSessionTask<DeleteEventMasterResult> {
        private DeleteEventMasterRequest request;

        public DeleteEventMasterTask(DeleteEventMasterRequest request, AsyncAction<AsyncResult<DeleteEventMasterResult>> userCallback, Class<DeleteEventMasterResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateEventMasterTask
    extends Gs2RestSessionTask<UpdateEventMasterResult> {
        private UpdateEventMasterRequest request;

        public UpdateEventMasterTask(UpdateEventMasterRequest request, AsyncAction<AsyncResult<UpdateEventMasterResult>> userCallback, Class<UpdateEventMasterResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getMetadata() != null) {
                json.put("metadata", (Object)this.request.getMetadata());
            }
            if (this.request.getScheduleType() != null) {
                json.put("scheduleType", (Object)this.request.getScheduleType());
            }
            if (this.request.getAbsoluteBegin() != null) {
                json.put("absoluteBegin", (Object)this.request.getAbsoluteBegin());
            }
            if (this.request.getAbsoluteEnd() != null) {
                json.put("absoluteEnd", (Object)this.request.getAbsoluteEnd());
            }
            if (this.request.getRelativeTriggerName() != null) {
                json.put("relativeTriggerName", (Object)this.request.getRelativeTriggerName());
            }
            if (this.request.getRelativeDuration() != null) {
                json.put("relativeDuration", (Object)this.request.getRelativeDuration());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEventMasterTask
    extends Gs2RestSessionTask<GetEventMasterResult> {
        private GetEventMasterRequest request;

        public GetEventMasterTask(GetEventMasterRequest request, AsyncAction<AsyncResult<GetEventMasterResult>> userCallback, Class<GetEventMasterResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateEventMasterTask
    extends Gs2RestSessionTask<CreateEventMasterResult> {
        private CreateEventMasterRequest request;

        public CreateEventMasterTask(CreateEventMasterRequest request, AsyncAction<AsyncResult<CreateEventMasterResult>> userCallback, Class<CreateEventMasterResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getName() != null) {
                json.put("name", (Object)this.request.getName());
            }
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getMetadata() != null) {
                json.put("metadata", (Object)this.request.getMetadata());
            }
            if (this.request.getScheduleType() != null) {
                json.put("scheduleType", (Object)this.request.getScheduleType());
            }
            if (this.request.getAbsoluteBegin() != null) {
                json.put("absoluteBegin", (Object)this.request.getAbsoluteBegin());
            }
            if (this.request.getAbsoluteEnd() != null) {
                json.put("absoluteEnd", (Object)this.request.getAbsoluteEnd());
            }
            if (this.request.getRelativeTriggerName() != null) {
                json.put("relativeTriggerName", (Object)this.request.getRelativeTriggerName());
            }
            if (this.request.getRelativeDuration() != null) {
                json.put("relativeDuration", (Object)this.request.getRelativeDuration());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeEventMastersTask
    extends Gs2RestSessionTask<DescribeEventMastersResult> {
        private DescribeEventMastersRequest request;

        public DescribeEventMastersTask(DescribeEventMastersRequest request, AsyncAction<AsyncResult<DescribeEventMastersResult>> userCallback, Class<DescribeEventMastersResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode((String)String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback, Class<DeleteNamespaceResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback, Class<UpdateNamespaceResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback, Class<GetNamespaceResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback, Class<GetNamespaceStatusResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback, Class<CreateNamespaceResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/";
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getName() != null) {
                json.put("name", (Object)this.request.getName());
            }
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback, Class<DescribeNamespacesResult> clazz) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode((String)String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

