/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.gsonfire.ClassConfig;
import io.gsonfire.DateSerializationPolicy;
import io.gsonfire.PostProcessor;
import io.gsonfire.PreProcessor;
import io.gsonfire.TypeSelector;
import io.gsonfire.gson.FireExclusionStrategy;
import io.gsonfire.gson.FireExclusionStrategyComposite;
import io.gsonfire.gson.FireTypeAdapterFactory;
import io.gsonfire.postprocessors.MergeMapPostProcessor;
import io.gsonfire.postprocessors.MethodInvokerPostProcessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class GsonFireBuilder {
    private final Map<Class, ClassConfig> classConfigMap = new HashMap<Class, ClassConfig>();
    private final List<Class> orderedClasses = new ArrayList<Class>();
    private final List<FireExclusionStrategy> serializationExclusions = new ArrayList<FireExclusionStrategy>();
    private DateSerializationPolicy dateSerializationPolicy;
    private TimeZone serializeTimeZone = TimeZone.getDefault();
    private boolean enableExposeMethodResults = false;

    private ClassConfig getClassConfig(Class clazz) {
        ClassConfig result = this.classConfigMap.get(clazz);
        if (result == null) {
            result = new ClassConfig(clazz);
            this.classConfigMap.put(clazz, result);
            GsonFireBuilder.insertOrdered(this.orderedClasses, clazz);
        }
        return result;
    }

    private static void insertOrdered(List<Class> classes, Class clazz) {
        for (int i = classes.size() - 1; i >= 0; --i) {
            Class current = classes.get(i);
            if (!current.isAssignableFrom(clazz)) continue;
            classes.add(i + 1, clazz);
            return;
        }
        classes.add(0, clazz);
    }

    public <T> GsonFireBuilder registerTypeSelector(Class<T> clazz, TypeSelector<T> factory) {
        ClassConfig config = this.getClassConfig(clazz);
        config.setTypeSelector(factory);
        return this;
    }

    public <T> GsonFireBuilder registerPostProcessor(Class<T> clazz, PostProcessor<? super T> postProcessor) {
        ClassConfig config = this.getClassConfig(clazz);
        config.getPostProcessors().add(postProcessor);
        return this;
    }

    public <T> GsonFireBuilder registerPreProcessor(Class<T> clazz, PreProcessor<? super T> preProcessor) {
        ClassConfig config = this.getClassConfig(clazz);
        config.getPreProcessors().add(preProcessor);
        return this;
    }

    public GsonFireBuilder dateSerializationPolicy(DateSerializationPolicy policy) {
        this.dateSerializationPolicy = policy;
        return this;
    }

    public GsonFireBuilder enableExposeMethodResult() {
        this.enableExposeMethodResults = true;
        return this;
    }

    public GsonFireBuilder enableHooks(Class clazz) {
        ClassConfig config = this.getClassConfig(clazz);
        config.setHooksEnabled(true);
        return this;
    }

    @Deprecated
    public GsonFireBuilder enableMergeMaps(Class clazz) {
        this.registerPostProcessor(clazz, new MergeMapPostProcessor());
        return this;
    }

    public GsonFireBuilder serializeTimeZone(TimeZone timeZone) {
        this.serializeTimeZone = timeZone;
        return this;
    }

    public GsonFireBuilder addSerializationExclusionStrategy(FireExclusionStrategy exclusionStrategy) {
        this.serializationExclusions.add(exclusionStrategy);
        return this;
    }

    public GsonBuilder createGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        if (this.enableExposeMethodResults) {
            FireExclusionStrategyComposite compositeExclusionStrategy = new FireExclusionStrategyComposite(this.serializationExclusions);
            this.registerPostProcessor(Object.class, new MethodInvokerPostProcessor(compositeExclusionStrategy));
        }
        for (Class clazz : this.orderedClasses) {
            ClassConfig config = this.classConfigMap.get(clazz);
            builder.registerTypeAdapterFactory(new FireTypeAdapterFactory(config));
        }
        if (this.dateSerializationPolicy != null) {
            builder.registerTypeAdapter(Date.class, this.dateSerializationPolicy.createTypeAdapter(this.serializeTimeZone));
        }
        return builder;
    }

    public Gson createGson() {
        return this.createGsonBuilder().create();
    }
}

