/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodInspector {
    private static final Map<Class, Map<Class<? extends Annotation>, Method[]>> cache = new ConcurrentHashMap<Class, Map<Class<? extends Annotation>, Method[]>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method[] getAnnotatedMethods(Class clazz, Class<? extends Annotation> annotation) {
        Method[] methods = this.getFromCache(clazz, annotation);
        if (methods != null) {
            return methods;
        }
        Map<Class, Map<Class<? extends Annotation>, Method[]>> map = cache;
        synchronized (map) {
            methods = this.getFromCache(clazz, annotation);
            if (methods == null) {
                HashSet<Method> methodList = new HashSet<Method>();
                for (Method m : clazz.getMethods()) {
                    if (!m.isAnnotationPresent(annotation)) continue;
                    methodList.add(m);
                }
                for (Method m : clazz.getDeclaredMethods()) {
                    if (!m.isAnnotationPresent(annotation)) continue;
                    m.setAccessible(true);
                    methodList.add(m);
                }
                if (!cache.containsKey(clazz)) {
                    cache.put(clazz, new ConcurrentHashMap());
                }
                methods = new Method[methodList.size()];
                cache.get(clazz).put(annotation, methodList.toArray(methods));
            }
        }
        return methods;
    }

    private Method[] getFromCache(Class clazz, Class<? extends Annotation> annotation) {
        Method[] methods;
        Map<Class<? extends Annotation>, Method[]> annotationMap = cache.get(clazz);
        if (annotationMap != null && (methods = annotationMap.get(annotation)) != null) {
            return methods;
        }
        return null;
    }
}

