/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class FieldInspector {
    private static final Map<Class, Map<Class<? extends Annotation>, Field[]>> cache = new ConcurrentHashMap<Class, Map<Class<? extends Annotation>, Field[]>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field[] getAnnotatedFields(Class clazz, Class<? extends Annotation> annotation) {
        Field[] fields = this.getFromCache(clazz, annotation);
        if (fields != null) {
            return fields;
        }
        Map<Class, Map<Class<? extends Annotation>, Field[]>> map = cache;
        synchronized (map) {
            fields = this.getFromCache(clazz, annotation);
            if (fields == null) {
                HashSet<Field> fieldList = new HashSet<Field>();
                for (Field m : clazz.getFields()) {
                    if (!m.isAnnotationPresent(annotation)) continue;
                    m.setAccessible(true);
                    fieldList.add(m);
                }
                for (Field m : clazz.getDeclaredFields()) {
                    if (!m.isAnnotationPresent(annotation)) continue;
                    m.setAccessible(true);
                    fieldList.add(m);
                }
                if (!cache.containsKey(clazz)) {
                    cache.put(clazz, new ConcurrentHashMap());
                }
                fields = new Field[fieldList.size()];
                cache.get(clazz).put(annotation, fieldList.toArray(fields));
            }
        }
        return fields;
    }

    private Field[] getFromCache(Class clazz, Class<? extends Annotation> annotation) {
        Field[] fields;
        Map<Class<? extends Annotation>, Field[]> annotationMap = cache.get(clazz);
        if (annotationMap != null && (fields = annotationMap.get(annotation)) != null) {
            return fields;
        }
        return null;
    }
}

