/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.util;

import io.gsonfire.util.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class IterableMapper<F, T>
implements Iterable<T> {
    private final Iterable<F> source;
    private final Collection<T> cache = new ArrayList<T>();
    private final Mapper<F, T> mapper;

    private IterableMapper(Iterable<F> source, Mapper<F, T> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> cacheIterator = new ArrayList<T>(this.cache).iterator();
        final Iterator<F> sourceIterator = this.source.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return cacheIterator.hasNext() || sourceIterator.hasNext();
            }

            @Override
            public T next() {
                if (cacheIterator.hasNext()) {
                    return cacheIterator.next();
                }
                Object mapped = IterableMapper.this.mapper.map(sourceIterator.next());
                IterableMapper.this.cache.add(mapped);
                return mapped;
            }

            @Override
            public void remove() {
            }
        };
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Iterable) {
            Iterator otherIterator = ((Iterable)o).iterator();
            Iterator<T> thisIterator = this.iterator();
            while (thisIterator.hasNext()) {
                if (otherIterator.hasNext()) {
                    Object otherNext;
                    T thisNext = thisIterator.next();
                    if (IterableMapper.areObjectEquals(thisNext, otherNext = otherIterator.next())) continue;
                    return false;
                }
                return false;
            }
            return !otherIterator.hasNext();
        }
        return false;
    }

    private static boolean areObjectEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <F, T> Iterable<T> create(Iterable<F> source, Mapper<F, T> mapper) {
        return new IterableMapper<F, T>(source, mapper);
    }
}

