/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Date;

public class DateUnixtimeMillisTypeAdapter
extends TypeAdapter<Date> {
    private final boolean allowNegativeTimestamp;

    public DateUnixtimeMillisTypeAdapter(boolean allowNegativeTimestamp) {
        this.allowNegativeTimestamp = allowNegativeTimestamp;
    }

    public final void write(JsonWriter out, Date value) throws IOException {
        long time = value.getTime();
        if (time >= 0L || this.allowNegativeTimestamp) {
            out.value(this.toTimestamp(value));
        } else {
            out.nullValue();
        }
    }

    public final Date read(JsonReader in) throws IOException {
        long time = in.nextLong();
        if (time >= 0L || this.allowNegativeTimestamp) {
            return this.fromTimestamp(time);
        }
        return null;
    }

    protected long toTimestamp(Date date) {
        return date.getTime();
    }

    protected Date fromTimestamp(long timestamp) {
        return new Date(timestamp);
    }
}

