/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.util.RFC3339DateFormat;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;

public final class DateRFC3339TypeAdapter
extends TypeAdapter<Date> {
    private final RFC3339DateFormat dateFormat;

    public DateRFC3339TypeAdapter(boolean serializeTime) {
        this.dateFormat = new RFC3339DateFormat(serializeTime);
    }

    public DateRFC3339TypeAdapter(TimeZone serializationTimezone, boolean serializeTime) {
        this.dateFormat = new RFC3339DateFormat(serializationTimezone, serializeTime);
    }

    public void write(JsonWriter out, Date value) throws IOException {
        out.value(this.dateFormat.format(value));
    }

    public Date read(JsonReader in) throws IOException {
        String dateStr = in.nextString();
        try {
            return this.dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            throw new IOException("Could not parse date " + dateStr, e);
        }
    }
}

