/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.ClassConfig;
import io.gsonfire.TypeSelector;
import io.gsonfire.gson.NullableTypeAdapter;
import java.io.IOException;

public class TypeSelectorTypeAdapterFactory<T>
implements TypeAdapterFactory {
    private final ClassConfig<T> classConfig;

    public TypeSelectorTypeAdapterFactory(ClassConfig<T> classConfig) {
        this.classConfig = classConfig;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (this.classConfig.getConfiguredClass().isAssignableFrom(type.getRawType())) {
            NullableTypeAdapter fireTypeAdapter = new NullableTypeAdapter(new TypeSelectorTypeAdapter(type.getRawType(), this.classConfig.getTypeSelector(), gson));
            return fireTypeAdapter;
        }
        return null;
    }

    private class TypeSelectorTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Class superClass;
        private final TypeSelector typeSelector;
        private final Gson gson;

        private TypeSelectorTypeAdapter(Class superClass, TypeSelector typeSelector, Gson gson) {
            this.superClass = superClass;
            this.typeSelector = typeSelector;
            this.gson = gson;
        }

        public void write(JsonWriter out, T value) throws IOException {
            TypeAdapter otherTypeAdapter = this.gson.getDelegateAdapter((TypeAdapterFactory)TypeSelectorTypeAdapterFactory.this, TypeToken.get(value.getClass()));
            this.gson.toJson(otherTypeAdapter.toJsonTree(value), out);
        }

        public T read(JsonReader in) throws IOException {
            JsonElement json = new JsonParser().parse(in);
            Class deserialize = this.typeSelector.getClassForElement(json);
            if (deserialize == null) {
                deserialize = this.superClass;
            }
            TypeAdapter otherTypeAdapter = this.gson.getDelegateAdapter((TypeAdapterFactory)TypeSelectorTypeAdapterFactory.this, TypeToken.get((Class)deserialize));
            return (T)otherTypeAdapter.fromJsonTree(json);
        }
    }
}

