/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android;

import android.content.Context;
import android.os.Build;
import io.hackle.android.HackleApp;
import io.hackle.android.HackleConfig;
import io.hackle.android.internal.database.DatabaseHelper;
import io.hackle.android.internal.database.repository.AndroidKeyValueRepository;
import io.hackle.android.internal.database.repository.EventRepository;
import io.hackle.android.internal.database.repository.KeyValueRepository;
import io.hackle.android.internal.database.repository.NotificationHistoryRepositoryImpl;
import io.hackle.android.internal.database.workspace.WorkspaceDatabase;
import io.hackle.android.internal.event.DefaultEventProcessor;
import io.hackle.android.internal.event.EventDispatcher;
import io.hackle.android.internal.event.ExposureEventDeduplicationDeterminer;
import io.hackle.android.internal.event.UserEventPublisher;
import io.hackle.android.internal.http.SdkHeaderInterceptor;
import io.hackle.android.internal.http.Tls;
import io.hackle.android.internal.inappmessage.storage.AndroidInAppMessageHiddenStorage;
import io.hackle.android.internal.inappmessage.storage.InAppMessageImpressionStorage;
import io.hackle.android.internal.inappmessage.trigger.InAppMessageDeterminer;
import io.hackle.android.internal.inappmessage.trigger.InAppMessageEventMatcher;
import io.hackle.android.internal.inappmessage.trigger.InAppMessageEventTriggerFrequencyCapDeterminer;
import io.hackle.android.internal.inappmessage.trigger.InAppMessageEventTriggerRuleDeterminer;
import io.hackle.android.internal.inappmessage.trigger.InAppMessageManager;
import io.hackle.android.internal.lifecycle.AppStateManager;
import io.hackle.android.internal.lifecycle.HackleActivityLifecycleCallbacks;
import io.hackle.android.internal.lifecycle.LifecycleManager;
import io.hackle.android.internal.log.AndroidLogger;
import io.hackle.android.internal.model.Device;
import io.hackle.android.internal.model.Sdk;
import io.hackle.android.internal.monitoring.metric.MonitoringMetricRegistry;
import io.hackle.android.internal.notification.NotificationManager;
import io.hackle.android.internal.session.SessionEventTracker;
import io.hackle.android.internal.session.SessionManager;
import io.hackle.android.internal.sync.CompositeSynchronizer;
import io.hackle.android.internal.sync.PollingSynchronizer;
import io.hackle.android.internal.sync.SynchronizerType;
import io.hackle.android.internal.task.TaskExecutors;
import io.hackle.android.internal.user.UserCohortFetcher;
import io.hackle.android.internal.user.UserManager;
import io.hackle.android.internal.workspace.HttpWorkspaceFetcher;
import io.hackle.android.internal.workspace.WorkspaceManager;
import io.hackle.android.ui.explorer.HackleUserExplorer;
import io.hackle.android.ui.explorer.base.HackleUserExplorerService;
import io.hackle.android.ui.explorer.storage.HackleUserManualOverrideStorage;
import io.hackle.android.ui.inappmessage.InAppMessageUi;
import io.hackle.android.ui.inappmessage.event.InAppMessageActionEventProcessor;
import io.hackle.android.ui.inappmessage.event.InAppMessageActionHandler;
import io.hackle.android.ui.inappmessage.event.InAppMessageActionHandlerFactory;
import io.hackle.android.ui.inappmessage.event.InAppMessageCloseActionHandler;
import io.hackle.android.ui.inappmessage.event.InAppMessageCloseEventProcessor;
import io.hackle.android.ui.inappmessage.event.InAppMessageEventHandler;
import io.hackle.android.ui.inappmessage.event.InAppMessageEventProcessor;
import io.hackle.android.ui.inappmessage.event.InAppMessageEventProcessorFactory;
import io.hackle.android.ui.inappmessage.event.InAppMessageEventTracker;
import io.hackle.android.ui.inappmessage.event.InAppMessageHideActionHandler;
import io.hackle.android.ui.inappmessage.event.InAppMessageImpressionEventProcessor;
import io.hackle.android.ui.inappmessage.event.InAppMessageLinkActionHandler;
import io.hackle.android.ui.inappmessage.event.InAppMessageLinkAndCloseActionHandler;
import io.hackle.android.ui.inappmessage.event.UriHandler;
import io.hackle.android.ui.inappmessage.view.InAppMessageViewFactory;
import io.hackle.android.ui.notification.NotificationHandler;
import io.hackle.sdk.core.HackleCore;
import io.hackle.sdk.core.evaluation.EvaluationContext;
import io.hackle.sdk.core.evaluation.match.TargetMatcher;
import io.hackle.sdk.core.evaluation.target.ManualOverrideStorage;
import io.hackle.sdk.core.event.EventProcessor;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import io.hackle.sdk.core.internal.log.metrics.MetricLoggerFactory;
import io.hackle.sdk.core.internal.metrics.MetricRegistry;
import io.hackle.sdk.core.internal.metrics.Metrics;
import io.hackle.sdk.core.internal.scheduler.Schedulers;
import io.hackle.sdk.core.internal.time.Clock;
import io.hackle.sdk.core.workspace.WorkspaceFetcher;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/hackle/android/HackleApps;", "", "()V", "PREFERENCES_NAME", "", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "create", "Lio/hackle/android/HackleApp;", "context", "Landroid/content/Context;", "sdkKey", "config", "Lio/hackle/android/HackleConfig;", "createHttpClient", "Lokhttp3/OkHttpClient;", "sdk", "Lio/hackle/android/internal/model/Sdk;", "loggerConfiguration", "", "metricConfiguration", "callbacks", "Lio/hackle/android/internal/lifecycle/HackleActivityLifecycleCallbacks;", "eventExecutor", "Ljava/util/concurrent/Executor;", "httpExecutor", "httpClient", "hackle-android-sdk_release"})
public final class HackleApps {
    private static final Logger log;
    private static final String PREFERENCES_NAME = "io.hackle.android";
    public static final HackleApps INSTANCE;

    @NotNull
    public final HackleApp create(@NotNull Context context, @NotNull String sdkKey, @NotNull HackleConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Sdk sdk = Sdk.Companion.of(sdkKey, config);
        this.loggerConfiguration(config);
        AndroidKeyValueRepository globalKeyValueRepository = AndroidKeyValueRepository.Companion.create$default(AndroidKeyValueRepository.Companion, context, PREFERENCES_NAME, 0, 4, null);
        AndroidKeyValueRepository keyValueRepositoryBySdkKey = AndroidKeyValueRepository.Companion.create$default(AndroidKeyValueRepository.Companion, context, "io.hackle.android_" + sdkKey, 0, 4, null);
        Device device = Device.Companion.create(context, globalKeyValueRepository);
        OkHttpClient httpClient = this.createHttpClient(context, sdk);
        CompositeSynchronizer compositeSynchronizer = new CompositeSynchronizer(TaskExecutors.INSTANCE.default());
        PollingSynchronizer pollingSynchronizer = new PollingSynchronizer(compositeSynchronizer, Schedulers.executor$default((Schedulers)Schedulers.INSTANCE, (String)"HacklePollingSynchronizer-", (int)0, (boolean)false, (int)6, null), config.getPollingIntervalMillis());
        HttpWorkspaceFetcher httpWorkspaceFetcher = new HttpWorkspaceFetcher(sdk, config.getSdkUri(), httpClient);
        WorkspaceManager workspaceManager = new WorkspaceManager(httpWorkspaceFetcher);
        compositeSynchronizer.add(SynchronizerType.WORKSPACE, workspaceManager);
        UserCohortFetcher cohortFetcher = new UserCohortFetcher(config.getSdkUri(), httpClient);
        UserManager userManager = new UserManager(device, keyValueRepositoryBySdkKey, cohortFetcher);
        compositeSynchronizer.add(SynchronizerType.COHORT, userManager);
        KeyValueRepository keyValueRepository = globalKeyValueRepository;
        long l = config.getSessionTimeoutMillis();
        SessionManager sessionManager = new SessionManager(userManager, keyValueRepository, l);
        userManager.addListener(sessionManager);
        WorkspaceDatabase workspaceDatabase = DatabaseHelper.INSTANCE.getWorkspaceDatabase(context, sdkKey);
        EventRepository eventRepository = new EventRepository(workspaceDatabase);
        Executor eventExecutor = TaskExecutors.handler$default(TaskExecutors.INSTANCE, "io.hackle.EventExecutor", 0, 2, null);
        Executor httpExecutor = TaskExecutors.handler$default(TaskExecutors.INSTANCE, "io.hackle.HttpExecutor", 0, 2, null);
        EventDispatcher eventDispatcher = new EventDispatcher(config.getEventUri(), eventExecutor, eventRepository, httpExecutor, httpClient);
        UserEventPublisher eventPublisher = new UserEventPublisher();
        ExposureEventDeduplicationDeterminer dedupDeterminer = new ExposureEventDeduplicationDeterminer(config.getExposureEventDedupIntervalMillis());
        AppStateManager appStateManager = new AppStateManager();
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"Executors.newSingleThreadScheduledExecutor()");
        DefaultEventProcessor eventProcessor = new DefaultEventProcessor(dedupDeterminer, eventPublisher, eventExecutor, eventRepository, 1000, Schedulers.INSTANCE.executor(scheduledExecutorService), config.getEventFlushIntervalMillis(), config.getEventFlushThreshold(), config.getEventFlushThreshold() * 2 + 1, eventDispatcher, sessionManager, userManager, appStateManager, LifecycleManager.Companion.getInstance());
        HackleUserManualOverrideStorage abOverrideStorage = HackleUserManualOverrideStorage.Companion.create(context, "io.hackle.android_ab_override_" + sdkKey);
        HackleUserManualOverrideStorage ffOverrideStorage = HackleUserManualOverrideStorage.Companion.create(context, "io.hackle.android_ff_override_" + sdkKey);
        AndroidInAppMessageHiddenStorage inAppMessageHiddenStorage = AndroidInAppMessageHiddenStorage.Companion.create(context, "io.hackle.android_in_app_message_" + sdkKey);
        InAppMessageImpressionStorage inAppMessageImpressionStorage = InAppMessageImpressionStorage.Companion.create(context, "io.hackle.android_iam_impression_" + sdkKey);
        EvaluationContext.Companion.getGLOBAL().register((Object)inAppMessageHiddenStorage);
        HackleCore core = HackleCore.Companion.create(EvaluationContext.Companion.getGLOBAL(), (WorkspaceFetcher)workspaceManager, (EventProcessor)eventProcessor, (ManualOverrideStorage[])new HackleUserManualOverrideStorage[]{abOverrideStorage, ffOverrideStorage});
        HackleActivityLifecycleCallbacks lifecycleCallbacks = new HackleActivityLifecycleCallbacks(eventExecutor, appStateManager);
        lifecycleCallbacks.addListener(pollingSynchronizer);
        lifecycleCallbacks.addListener(sessionManager);
        lifecycleCallbacks.addListener(userManager);
        lifecycleCallbacks.addListener(eventProcessor);
        SessionEventTracker sessionEventTracker = new SessionEventTracker(userManager, core);
        sessionManager.addListener(sessionEventTracker);
        InAppMessageEventTracker inAppMessageEventTracker = new InAppMessageEventTracker(core);
        UriHandler uriHandler = new UriHandler();
        InAppMessageActionHandlerFactory inAppMessageActionHandlerFactory = new InAppMessageActionHandlerFactory(CollectionsKt.listOf((Object[])new InAppMessageActionHandler[]{new InAppMessageCloseActionHandler(), new InAppMessageLinkActionHandler(uriHandler), new InAppMessageLinkAndCloseActionHandler(uriHandler), new InAppMessageHideActionHandler(inAppMessageHiddenStorage, Clock.Companion.getSYSTEM())}));
        InAppMessageEventProcessorFactory inAppMessageEventProcessorFactory = new InAppMessageEventProcessorFactory(CollectionsKt.listOf((Object[])new InAppMessageEventProcessor[]{new InAppMessageImpressionEventProcessor(inAppMessageImpressionStorage), new InAppMessageActionEventProcessor(inAppMessageActionHandlerFactory), new InAppMessageCloseEventProcessor()}));
        InAppMessageEventHandler inAppMessageEventHandler = new InAppMessageEventHandler(Clock.Companion.getSYSTEM(), inAppMessageEventTracker, inAppMessageEventProcessorFactory);
        InAppMessageUi inAppMessageUi = InAppMessageUi.Companion.create(LifecycleManager.Companion.getInstance(), new InAppMessageViewFactory(), inAppMessageEventHandler);
        EvaluationContext $this$get$iv = EvaluationContext.Companion.getGLOBAL();
        boolean $i$f$get = false;
        InAppMessageEventMatcher inAppMessageEventMatcher = new InAppMessageEventMatcher(new InAppMessageEventTriggerRuleDeterminer((TargetMatcher)$this$get$iv.get(TargetMatcher.class)), new InAppMessageEventTriggerFrequencyCapDeterminer(inAppMessageImpressionStorage));
        InAppMessageDeterminer inAppMessageDeterminer = new InAppMessageDeterminer(workspaceManager, inAppMessageEventMatcher, core);
        InAppMessageManager inAppMessageManager = new InAppMessageManager(inAppMessageDeterminer, inAppMessageUi, appStateManager);
        eventPublisher.add(inAppMessageManager);
        NotificationManager notificationManager = new NotificationManager(core, eventExecutor, workspaceManager, userManager, keyValueRepositoryBySdkKey, new NotificationHistoryRepositoryImpl(DatabaseHelper.INSTANCE.getSharedDatabase(context)));
        NotificationHandler.Companion.getInstance(context).setNotificationDataReceiver(notificationManager);
        userManager.addListener(notificationManager);
        HackleUserExplorer userExplorer = new HackleUserExplorer(new HackleUserExplorerService(core, userManager, abOverrideStorage, ffOverrideStorage, notificationManager), LifecycleManager.Companion.getInstance());
        this.metricConfiguration(config, lifecycleCallbacks, eventExecutor, httpExecutor, httpClient);
        LifecycleManager.Companion.getInstance().addStateListener(lifecycleCallbacks);
        LifecycleManager.Companion.getInstance().addStateListener(userExplorer);
        LifecycleManager.Companion.getInstance().registerActivityLifecycleCallbacks(context);
        return new HackleApp(Clock.Companion.getSYSTEM(), core, eventExecutor, TaskExecutors.INSTANCE.default(), pollingSynchronizer, userManager, sessionManager, eventProcessor, notificationManager, device, userExplorer, sdk);
    }

    private final void loggerConfiguration(HackleConfig config) {
        Logger.Companion.add((Logger.Factory)AndroidLogger.Factory.INSTANCE.logLevel(config.getLogLevel()));
        Logger.Companion.add((Logger.Factory)new MetricLoggerFactory((MetricRegistry)Metrics.INSTANCE.getGlobalRegistry()));
    }

    private final void metricConfiguration(HackleConfig config, HackleActivityLifecycleCallbacks callbacks, Executor eventExecutor, Executor httpExecutor, OkHttpClient httpClient) {
        MonitoringMetricRegistry monitoringMetricRegistry = new MonitoringMetricRegistry(config.getMonitoringUri(), eventExecutor, httpExecutor, httpClient, null, 16, null);
        callbacks.addListener(monitoringMetricRegistry);
        Metrics.INSTANCE.addRegistry((MetricRegistry)monitoringMetricRegistry);
    }

    private final OkHttpClient createHttpClient(Context context, Sdk sdk) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).addInterceptor((Interceptor)new SdkHeaderInterceptor(sdk.getKey(), sdk.getName(), sdk.getVersion()));
        if (Build.VERSION.SDK_INT < 22) {
            try {
                Tls.INSTANCE.update(context);
                builder.sslSocketFactory(Tls.INSTANCE.tls12SocketFactory(), Tls.INSTANCE.defaultTrustManager());
            }
            catch (Exception e) {
                log.error((Function0)new Function0<String>(e){
                    final /* synthetic */ Exception $e;

                    @NotNull
                    public final String invoke() {
                        return "TLS is not available: " + this.$e;
                    }
                    {
                        this.$e = exception;
                        super(0);
                    }
                });
            }
        }
        OkHttpClient okHttpClient = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"builder.build()");
        return okHttpClient;
    }

    private HackleApps() {
    }

    static {
        HackleApps hackleApps;
        INSTANCE = hackleApps = new HackleApps();
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = HackleApps.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }
}

