/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.database.repository;

import android.content.Context;
import android.content.SharedPreferences;
import io.hackle.android.internal.database.repository.KeyValueRepository;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/hackle/android/internal/database/repository/AndroidKeyValueRepository;", "Lio/hackle/android/internal/database/repository/KeyValueRepository;", "preferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "clear", "", "getAll", "", "", "", "getLong", "", "key", "defaultValue", "getString", "putLong", "value", "putString", "remove", "Companion", "hackle-android-sdk_release"})
public final class AndroidKeyValueRepository
implements KeyValueRepository {
    private final SharedPreferences preferences;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Map<String, Object> getAll() {
        Map map = this.preferences.getAll();
        if (map == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        }
        return map;
    }

    @Override
    @Nullable
    public String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.getString(key, null);
    }

    @Override
    public void putString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.preferences.edit().putString(key, value).apply();
    }

    @Override
    public long getLong(@NotNull String key, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.getLong(key, defaultValue);
    }

    @Override
    public void putLong(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.preferences.edit().putLong(key, value).apply();
    }

    @Override
    public void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.preferences.edit().remove(key).apply();
    }

    @Override
    public void clear() {
        this.preferences.edit().clear().apply();
    }

    public AndroidKeyValueRepository(@NotNull SharedPreferences preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        this.preferences = preferences;
    }

    @Override
    @NotNull
    public String getString(@NotNull String key, @NotNull Function1<? super String, String> mapping) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        return KeyValueRepository.DefaultImpls.getString(this, key, mapping);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lio/hackle/android/internal/database/repository/AndroidKeyValueRepository$Companion;", "", "()V", "create", "Lio/hackle/android/internal/database/repository/AndroidKeyValueRepository;", "context", "Landroid/content/Context;", "name", "", "mode", "", "hackle-android-sdk_release"})
    public static final class Companion {
        @NotNull
        public final AndroidKeyValueRepository create(@NotNull Context context, @NotNull String name, int mode) {
            SharedPreferences preferences;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            SharedPreferences sharedPreferences = preferences = context.getSharedPreferences(name, mode);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"preferences");
            return new AndroidKeyValueRepository(sharedPreferences);
        }

        public static /* synthetic */ AndroidKeyValueRepository create$default(Companion companion, Context context, String string2, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.create(context, string2, n);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

