/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.database.repository;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import io.hackle.android.internal.database.Database;
import io.hackle.android.internal.database.repository.EventRepository;
import io.hackle.android.internal.database.workspace.EventEntity;
import io.hackle.android.internal.database.workspace.EventEntityKt;
import io.hackle.android.internal.database.workspace.WorkspaceDatabase;
import io.hackle.sdk.core.event.UserEvent;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0011H\u0002J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\nJ/\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0017\u001a\u00020\u0011J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cJ&\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u001d\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/hackle/android/internal/database/repository/EventRepository;", "", "database", "Lio/hackle/android/internal/database/workspace/WorkspaceDatabase;", "(Lio/hackle/android/internal/database/workspace/WorkspaceDatabase;)V", "count", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "status", "Lio/hackle/android/internal/database/workspace/EventEntity$Status;", "delete", "", "events", "", "Lio/hackle/android/internal/database/workspace/EventEntity;", "deleteOldEvents", "", "eventEntity", "cursor", "Landroid/database/Cursor;", "findAllBy", "getEvents", "limit", "(Landroid/database/sqlite/SQLiteDatabase;Lio/hackle/android/internal/database/workspace/EventEntity$Status;Ljava/lang/Integer;)Ljava/util/List;", "getEventsToFlush", "save", "userEvent", "Lio/hackle/sdk/core/event/UserEvent;", "update", "Companion", "hackle-android-sdk_release"})
public final class EventRepository {
    private final WorkspaceDatabase database;
    private static final Logger log;
    public static final Companion Companion;

    public final long count(@Nullable EventEntity.Status status) {
        long l;
        try {
            l = ((Number)Database.execute$default(this.database, true, false, (Function1)new Function1<SQLiteDatabase, Long>(this, status){
                final /* synthetic */ EventRepository this$0;
                final /* synthetic */ EventEntity.Status $status;

                public final long invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return EventRepository.access$count(this.this$0, db, this.$status);
                }
                {
                    this.this$0 = eventRepository;
                    this.$status = status;
                    super(1);
                }
            }, 2, null)).longValue();
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to count events: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            l = 0L;
        }
        return l;
    }

    public static /* synthetic */ long count$default(EventRepository eventRepository, EventEntity.Status status, int n, Object object) {
        if ((n & 1) != 0) {
            status = null;
        }
        return eventRepository.count(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long count(SQLiteDatabase db, EventEntity.Status status) {
        long l;
        String query = status != null ? "SELECT COUNT(*) FROM events WHERE status = " + status.getCode() : "SELECT COUNT(*) FROM events";
        Closeable closeable = (Closeable)db.compileStatement(query);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            SQLiteStatement statement = (SQLiteStatement)closeable;
            boolean bl3 = false;
            l = statement.simpleQueryForLong();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return l;
    }

    static /* synthetic */ long count$default(EventRepository eventRepository, SQLiteDatabase sQLiteDatabase, EventEntity.Status status, int n, Object object) {
        if ((n & 2) != 0) {
            status = null;
        }
        return eventRepository.count(sQLiteDatabase, status);
    }

    public final void save(@NotNull UserEvent userEvent) {
        Intrinsics.checkNotNullParameter((Object)userEvent, (String)"userEvent");
        try {
            Database.execute$default(this.database, false, false, (Function1)new Function1<SQLiteDatabase, Unit>(this, userEvent){
                final /* synthetic */ EventRepository this$0;
                final /* synthetic */ UserEvent $userEvent;

                public final void invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    EventRepository.access$save(this.this$0, db, this.$userEvent);
                }
                {
                    this.this$0 = eventRepository;
                    this.$userEvent = userEvent;
                    super(1);
                }
            }, 3, null);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to save event: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    private final void save(SQLiteDatabase db, UserEvent userEvent) {
        ContentValues values = new ContentValues();
        values.put("type", Integer.valueOf(EventEntityKt.getType(userEvent).getCode()));
        values.put("status", Integer.valueOf(EventEntity.Status.PENDING.getCode()));
        values.put("body", EventEntityKt.toBody(userEvent));
        db.insert("events", null, values);
    }

    @NotNull
    public final List<EventEntity> getEventsToFlush(int limit) {
        List list;
        try {
            list = (List)Database.execute$default(this.database, false, true, (Function1)new Function1<SQLiteDatabase, List<? extends EventEntity>>(this, limit){
                final /* synthetic */ EventRepository this$0;
                final /* synthetic */ int $limit;

                @NotNull
                public final List<EventEntity> invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return EventRepository.access$getEventsToFlush(this.this$0, db, this.$limit);
                }
                {
                    this.this$0 = eventRepository;
                    this.$limit = n;
                    super(1);
                }
            }, 1, null);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to get events: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<EventEntity> getEventsToFlush(SQLiteDatabase db, int limit) {
        List<EventEntity> list = this.getEvents(db, EventEntity.Status.PENDING, limit);
        boolean bl = false;
        boolean bl2 = false;
        List<EventEntity> it = list;
        boolean bl3 = false;
        this.update(db, it, EventEntity.Status.FLUSHING);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<EventEntity> getEvents(SQLiteDatabase db, EventEntity.Status status, Integer limit) {
        List list;
        String query = limit != null ? "SELECT * FROM events WHERE status = " + status.getCode() + " ORDER BY id ASC LIMIT " + limit : "SELECT * FROM events WHERE status = " + status.getCode();
        Closeable closeable = (Closeable)db.rawQuery(query, null);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)closeable;
            boolean bl3 = false;
            boolean bl4 = false;
            List events = new ArrayList();
            while (cursor.moveToNext()) {
                Cursor cursor2 = cursor;
                Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"cursor");
                EventEntity event = this.eventEntity(cursor2);
                events.add(event);
            }
            list = events;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    static /* synthetic */ List getEvents$default(EventRepository eventRepository, SQLiteDatabase sQLiteDatabase, EventEntity.Status status, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return eventRepository.getEvents(sQLiteDatabase, status, n);
    }

    private final EventEntity eventEntity(Cursor cursor) {
        long l = cursor.getLong(0);
        EventEntity.Status status = EventEntity.Status.Companion.from(cursor.getInt(1));
        EventEntity.Type type = EventEntity.Type.Companion.from(cursor.getInt(2));
        String string2 = cursor.getString(3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cursor.getString(3)");
        return new EventEntity(l, status, type, string2);
    }

    @NotNull
    public final List<EventEntity> findAllBy(@NotNull EventEntity.Status status) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        try {
            list = (List)Database.execute$default(this.database, true, false, (Function1)new Function1<SQLiteDatabase, List<? extends EventEntity>>(this, status){
                final /* synthetic */ EventRepository this$0;
                final /* synthetic */ EventEntity.Status $status;

                @NotNull
                public final List<EventEntity> invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return EventRepository.getEvents$default(this.this$0, db, this.$status, null, 4, null);
                }
                {
                    this.this$0 = eventRepository;
                    this.$status = status;
                    super(1);
                }
            }, 2, null);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to get events: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void update(@NotNull List<EventEntity> events, @NotNull EventEntity.Status status) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        try {
            Database.execute$default(this.database, false, true, (Function1)new Function1<SQLiteDatabase, Unit>(this, events, status){
                final /* synthetic */ EventRepository this$0;
                final /* synthetic */ List $events;
                final /* synthetic */ EventEntity.Status $status;

                public final void invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    EventRepository.access$update(this.this$0, db, this.$events, this.$status);
                }
                {
                    this.this$0 = eventRepository;
                    this.$events = list;
                    this.$status = status;
                    super(1);
                }
            }, 1, null);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to update events: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update(SQLiteDatabase db, List<EventEntity> events, EventEntity.Status status) {
        for (EventEntity event : events) {
            String query = "UPDATE events SET status = " + status.getCode() + " WHERE id = " + event.getId();
            Closeable closeable = (Closeable)db.compileStatement(query);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                SQLiteStatement statement = (SQLiteStatement)closeable;
                boolean bl3 = false;
                int n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public final void delete(@NotNull List<EventEntity> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        String ids2 = CollectionsKt.joinToString$default((Iterable)events, (CharSequence)",", null, null, (int)0, null, (Function1)delete.ids.1.INSTANCE, (int)30, null);
        String whereClause = "id IN (" + ids2 + ')';
        try {
            Database.execute$default(this.database, false, false, (Function1)new Function1<SQLiteDatabase, Integer>(whereClause){
                final /* synthetic */ String $whereClause;

                public final int invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return db.delete("events", this.$whereClause, null);
                }
                {
                    this.$whereClause = string2;
                    super(1);
                }
            }, 3, null);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to delete events: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    public final void deleteOldEvents(int count2) {
        try {
            Unit unit = (Unit)Database.execute$default(this.database, false, true, (Function1)new Function1<SQLiteDatabase, Unit>(this, count2){
                final /* synthetic */ EventRepository this$0;
                final /* synthetic */ int $count;

                public final void invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    EventRepository.access$deleteOldEvents(this.this$0, db, this.$count);
                }
                {
                    this.this$0 = eventRepository;
                    this.$count = n;
                    super(1);
                }
            }, 1, null);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to delete events: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteOldEvents(SQLiteDatabase db, int count2) {
        long l;
        String query = "SELECT id FROM events LIMIT 1 OFFSET " + (count2 - 1);
        Closeable closeable = (Closeable)db.compileStatement(query);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            SQLiteStatement statement = (SQLiteStatement)closeable;
            boolean bl3 = false;
            l = statement.simpleQueryForLong();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        long id2 = l;
        db.delete("events", "id <= " + id2, null);
    }

    public EventRepository(@NotNull WorkspaceDatabase database) {
        Intrinsics.checkNotNullParameter((Object)((Object)database), (String)"database");
        this.database = database;
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = EventRepository.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    public static final /* synthetic */ long access$count(EventRepository $this, SQLiteDatabase db, EventEntity.Status status) {
        return $this.count(db, status);
    }

    public static final /* synthetic */ void access$save(EventRepository $this, SQLiteDatabase db, UserEvent userEvent) {
        $this.save(db, userEvent);
    }

    public static final /* synthetic */ List access$getEventsToFlush(EventRepository $this, SQLiteDatabase db, int limit) {
        return $this.getEventsToFlush(db, limit);
    }

    public static final /* synthetic */ void access$update(EventRepository $this, SQLiteDatabase db, List events, EventEntity.Status status) {
        $this.update(db, events, status);
    }

    public static final /* synthetic */ void access$deleteOldEvents(EventRepository $this, SQLiteDatabase db, int count2) {
        $this.deleteOldEvents(db, count2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/hackle/android/internal/database/repository/EventRepository$Companion;", "", "()V", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

