/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.database.repository;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import io.hackle.android.internal.database.Database;
import io.hackle.android.internal.database.repository.NotificationHistoryRepository;
import io.hackle.android.internal.database.shared.NotificationHistoryEntity;
import io.hackle.android.internal.database.shared.SharedDatabase;
import io.hackle.android.ui.notification.NotificationData;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0018\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J7\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0014J-\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/hackle/android/internal/database/repository/NotificationHistoryRepositoryImpl;", "Lio/hackle/android/internal/database/repository/NotificationHistoryRepository;", "database", "Lio/hackle/android/internal/database/shared/SharedDatabase;", "(Lio/hackle/android/internal/database/shared/SharedDatabase;)V", "count", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "workspaceId", "environmentId", "", "delete", "", "notificationIds", "", "entities", "Lio/hackle/android/internal/database/shared/NotificationHistoryEntity;", "getEntities", "limit", "(Landroid/database/sqlite/SQLiteDatabase;JJLjava/lang/Integer;)Ljava/util/List;", "(JJLjava/lang/Integer;)Ljava/util/List;", "save", "data", "Lio/hackle/android/ui/notification/NotificationData;", "timestamp", "Companion", "hackle-android-sdk_release"})
public final class NotificationHistoryRepositoryImpl
implements NotificationHistoryRepository {
    private final SharedDatabase database;
    private static final Logger log;
    public static final Companion Companion;

    @Override
    public int count(long workspaceId, long environmentId) {
        int n;
        try {
            n = ((Number)Database.execute$default(this.database, true, false, (Function1)new Function1<SQLiteDatabase, Integer>(this, workspaceId, environmentId){
                final /* synthetic */ NotificationHistoryRepositoryImpl this$0;
                final /* synthetic */ long $workspaceId;
                final /* synthetic */ long $environmentId;

                public final int invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return (int)NotificationHistoryRepositoryImpl.access$count(this.this$0, db, this.$workspaceId, this.$environmentId);
                }
                {
                    this.this$0 = notificationHistoryRepositoryImpl;
                    this.$workspaceId = l;
                    this.$environmentId = l2;
                    super(1);
                }
            }, 2, null)).intValue();
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to count notifications: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            n = 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long count(SQLiteDatabase db, long workspaceId, long environmentId) {
        long l;
        String query = "SELECT COUNT(*) FROM notification_histories " + "WHERE workspace_id = " + workspaceId + " AND " + "environment_id = " + environmentId;
        Closeable closeable = (Closeable)db.compileStatement(query);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            SQLiteStatement statement = (SQLiteStatement)closeable;
            boolean bl3 = false;
            l = statement.simpleQueryForLong();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return l;
    }

    @Override
    public void save(@NotNull NotificationData data, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Database.execute$default(this.database, false, true, (Function1)new Function1<SQLiteDatabase, Unit>(this, data, timestamp){
                final /* synthetic */ NotificationHistoryRepositoryImpl this$0;
                final /* synthetic */ NotificationData $data;
                final /* synthetic */ long $timestamp;

                public final void invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    NotificationHistoryRepositoryImpl.access$save(this.this$0, db, this.$data, this.$timestamp);
                }
                {
                    this.this$0 = notificationHistoryRepositoryImpl;
                    this.$data = notificationData;
                    this.$timestamp = l;
                    super(1);
                }
            }, 1, null);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to save notification: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    private final void save(SQLiteDatabase db, NotificationData data, long timestamp) {
        ContentValues values = new ContentValues();
        values.put("workspace_id", Long.valueOf(data.getWorkspaceId()));
        values.put("environment_id", Long.valueOf(data.getEnvironmentId()));
        values.put("push_message_id", data.getPushMessageId());
        values.put("push_message_key", data.getPushMessageKey());
        values.put("push_message_execution_id", data.getPushMessageExecutionId());
        values.put("push_message_delivery_id", data.getPushMessageDeliveryId());
        values.put("timestamp", Long.valueOf(timestamp));
        values.put("debug", Boolean.valueOf(data.getDebug()));
        db.insert("notification_histories", null, values);
    }

    @Override
    @NotNull
    public List<NotificationHistoryEntity> getEntities(long workspaceId, long environmentId, @Nullable Integer limit) {
        List list;
        try {
            list = (List)Database.execute$default(this.database, true, false, (Function1)new Function1<SQLiteDatabase, List<? extends NotificationHistoryEntity>>(this, workspaceId, environmentId, limit){
                final /* synthetic */ NotificationHistoryRepositoryImpl this$0;
                final /* synthetic */ long $workspaceId;
                final /* synthetic */ long $environmentId;
                final /* synthetic */ Integer $limit;

                @NotNull
                public final List<NotificationHistoryEntity> invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return NotificationHistoryRepositoryImpl.access$getEntities(this.this$0, db, this.$workspaceId, this.$environmentId, this.$limit);
                }
                {
                    this.this$0 = notificationHistoryRepositoryImpl;
                    this.$workspaceId = l;
                    this.$environmentId = l2;
                    this.$limit = n;
                    super(1);
                }
            }, 2, null);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to get notifications: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<NotificationHistoryEntity> getEntities(SQLiteDatabase db, long workspaceId, long environmentId, Integer limit) {
        List list;
        String query = "SELECT * FROM notification_histories " + "WHERE workspace_id = " + workspaceId + " AND " + "environment_id = " + environmentId;
        if (limit != null) {
            query = query + " ORDER BY timestamp ASC LIMIT " + limit;
        }
        Closeable closeable = (Closeable)db.rawQuery(query, null);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)closeable;
            boolean bl3 = false;
            boolean bl4 = false;
            List toReturn = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    Cursor cursor2 = cursor;
                    Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"cursor");
                    NotificationHistoryEntity notification = NotificationHistoryEntity.Companion.from(cursor2);
                    toReturn.add(notification);
                } while (cursor.moveToNext());
            }
            cursor.close();
            list = toReturn;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    static /* synthetic */ List getEntities$default(NotificationHistoryRepositoryImpl notificationHistoryRepositoryImpl, SQLiteDatabase sQLiteDatabase, long l, long l2, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return notificationHistoryRepositoryImpl.getEntities(sQLiteDatabase, l, l2, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void delete(@NotNull List<NotificationHistoryEntity> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = entities;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NotificationHistoryEntity notificationHistoryEntity = (NotificationHistoryEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Long l = it.getHistoryId();
                collection.add(l);
            }
            List notificationIds = (List)destination$iv$iv;
            Database.execute$default(this.database, false, true, (Function1)new Function1<SQLiteDatabase, Unit>(this, notificationIds){
                final /* synthetic */ NotificationHistoryRepositoryImpl this$0;
                final /* synthetic */ List $notificationIds;

                public final void invoke(@NotNull SQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    NotificationHistoryRepositoryImpl.access$delete(this.this$0, db, this.$notificationIds);
                }
                {
                    this.this$0 = notificationHistoryRepositoryImpl;
                    this.$notificationIds = list;
                    super(1);
                }
            }, 1, null);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to delete notification: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void delete(SQLiteDatabase db, List<Long> notificationIds) {
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = notificationIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = String.valueOf((long)it);
            collection.add(string2);
        }
        List arguments = (List)destination$iv$iv;
        String $i$f$map22 = StringsKt.repeat((CharSequence)"?", (int)arguments.size());
        boolean $this$mapTo$iv$iv2 = false;
        String string3 = $i$f$map22;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string3.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        String format = ArraysKt.joinToString$default((char[])cArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        String whereClause = "history_id IN (" + format + ')';
        Collection $this$toTypedArray$iv = arguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        db.delete("notification_histories", whereClause, stringArray);
    }

    public NotificationHistoryRepositoryImpl(@NotNull SharedDatabase database) {
        Intrinsics.checkNotNullParameter((Object)((Object)database), (String)"database");
        this.database = database;
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = NotificationHistoryRepository.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    public static final /* synthetic */ long access$count(NotificationHistoryRepositoryImpl $this, SQLiteDatabase db, long workspaceId, long environmentId) {
        return $this.count(db, workspaceId, environmentId);
    }

    public static final /* synthetic */ void access$save(NotificationHistoryRepositoryImpl $this, SQLiteDatabase db, NotificationData data, long timestamp) {
        $this.save(db, data, timestamp);
    }

    public static final /* synthetic */ List access$getEntities(NotificationHistoryRepositoryImpl $this, SQLiteDatabase db, long workspaceId, long environmentId, Integer limit) {
        return $this.getEntities(db, workspaceId, environmentId, limit);
    }

    public static final /* synthetic */ void access$delete(NotificationHistoryRepositoryImpl $this, SQLiteDatabase db, List notificationIds) {
        $this.delete(db, notificationIds);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/hackle/android/internal/database/repository/NotificationHistoryRepositoryImpl$Companion;", "", "()V", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

