/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.event;

import android.app.Activity;
import io.hackle.android.internal.database.repository.EventRepository;
import io.hackle.android.internal.database.workspace.EventEntity;
import io.hackle.android.internal.event.DefaultEventProcessor;
import io.hackle.android.internal.event.DefaultEventProcessor$WhenMappings;
import io.hackle.android.internal.event.EventDispatcher;
import io.hackle.android.internal.event.ExposureEventDeduplicationDeterminer;
import io.hackle.android.internal.event.UserEventPublisher;
import io.hackle.android.internal.lifecycle.ActivityProvider;
import io.hackle.android.internal.lifecycle.AppState;
import io.hackle.android.internal.lifecycle.AppStateChangeListener;
import io.hackle.android.internal.lifecycle.AppStateManager;
import io.hackle.android.internal.session.Session;
import io.hackle.android.internal.session.SessionEventTracker;
import io.hackle.android.internal.session.SessionManager;
import io.hackle.android.internal.user.UserManager;
import io.hackle.sdk.core.event.EventProcessor;
import io.hackle.sdk.core.event.UserEvent;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import io.hackle.sdk.core.internal.scheduler.ScheduledJob;
import io.hackle.sdk.core.internal.scheduler.Scheduler;
import io.hackle.sdk.core.internal.utils.AnyKt;
import io.hackle.sdk.core.user.HackleUser;
import io.hackle.sdk.core.user.IdentifierType;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u0003:\u0003123Bu\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\r\u0012\u0006\u0010\u0013\u001a\u00020\r\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002J\u000e\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\rJ\b\u0010(\u001a\u00020\"H\u0002J\u0006\u0010)\u001a\u00020\"J\u0018\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0011H\u0016J\u0010\u0010.\u001a\u00020\"2\u0006\u0010%\u001a\u00020$H\u0016J\u0006\u0010/\u001a\u00020\"J\u0006\u00100\u001a\u00020\"R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lio/hackle/android/internal/event/DefaultEventProcessor;", "Lio/hackle/sdk/core/event/EventProcessor;", "Lio/hackle/android/internal/lifecycle/AppStateChangeListener;", "Ljava/io/Closeable;", "deduplicationDeterminer", "Lio/hackle/android/internal/event/ExposureEventDeduplicationDeterminer;", "eventPublisher", "Lio/hackle/android/internal/event/UserEventPublisher;", "eventExecutor", "Ljava/util/concurrent/Executor;", "eventRepository", "Lio/hackle/android/internal/database/repository/EventRepository;", "eventRepositoryMaxSize", "", "eventFlushScheduler", "Lio/hackle/sdk/core/internal/scheduler/Scheduler;", "eventFlushIntervalMillis", "", "eventFlushThreshold", "eventFlushMaxBatchSize", "eventDispatcher", "Lio/hackle/android/internal/event/EventDispatcher;", "sessionManager", "Lio/hackle/android/internal/session/SessionManager;", "userManager", "Lio/hackle/android/internal/user/UserManager;", "appStateManager", "Lio/hackle/android/internal/lifecycle/AppStateManager;", "activityProvider", "Lio/hackle/android/internal/lifecycle/ActivityProvider;", "(Lio/hackle/android/internal/event/ExposureEventDeduplicationDeterminer;Lio/hackle/android/internal/event/UserEventPublisher;Ljava/util/concurrent/Executor;Lio/hackle/android/internal/database/repository/EventRepository;ILio/hackle/sdk/core/internal/scheduler/Scheduler;JIILio/hackle/android/internal/event/EventDispatcher;Lio/hackle/android/internal/session/SessionManager;Lio/hackle/android/internal/user/UserManager;Lio/hackle/android/internal/lifecycle/AppStateManager;Lio/hackle/android/internal/lifecycle/ActivityProvider;)V", "flushingJob", "Lio/hackle/sdk/core/internal/scheduler/ScheduledJob;", "close", "", "decorateScreenName", "Lio/hackle/sdk/core/event/UserEvent;", "event", "dispatch", "limit", "flush", "initialize", "onChanged", "state", "Lio/hackle/android/internal/lifecycle/AppState;", "timestamp", "process", "start", "stop", "AddEventTask", "Companion", "FlushTask", "hackle-android-sdk_release"})
public final class DefaultEventProcessor
implements EventProcessor,
AppStateChangeListener,
Closeable {
    private ScheduledJob flushingJob;
    private final ExposureEventDeduplicationDeterminer deduplicationDeterminer;
    private final UserEventPublisher eventPublisher;
    private final Executor eventExecutor;
    private final EventRepository eventRepository;
    private final int eventRepositoryMaxSize;
    private final Scheduler eventFlushScheduler;
    private final long eventFlushIntervalMillis;
    private final int eventFlushThreshold;
    private final int eventFlushMaxBatchSize;
    private final EventDispatcher eventDispatcher;
    private final SessionManager sessionManager;
    private final UserManager userManager;
    private final AppStateManager appStateManager;
    private final ActivityProvider activityProvider;
    private static final Logger log;
    private static final Object LOCK;
    public static final Companion Companion;

    public void process(@NotNull UserEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            UserEvent newEvent = this.decorateScreenName(event);
            this.eventExecutor.execute(new AddEventTask(newEvent));
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to process event: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    private final void flush() {
        try {
            this.eventExecutor.execute(new FlushTask());
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to submit FlushTask: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    public final void initialize() {
        try {
            this.start();
            List<EventEntity> events = this.eventRepository.findAllBy(EventEntity.Status.FLUSHING);
            Collection collection = events;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.eventRepository.update(events, EventEntity.Status.PENDING);
            }
            log.debug((Function0)initialize.1.INSTANCE);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Fail to initialize: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.flushingJob != null) {
                return;
            }
            this.flushingJob = this.eventFlushScheduler.schedulePeriodically(this.eventFlushIntervalMillis, this.eventFlushIntervalMillis, TimeUnit.MILLISECONDS, (Function0)new Function0<Unit>(this){
                final /* synthetic */ DefaultEventProcessor this$0;
                {
                    this.this$0 = defaultEventProcessor;
                    super(0);
                }

                public final void invoke() {
                    DefaultEventProcessor.access$flush(this.this$0);
                }
            });
            log.info((Function0)new Function0<String>(this){
                final /* synthetic */ DefaultEventProcessor this$0;
                {
                    this.this$0 = defaultEventProcessor;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "DefaultEventProcessor started. Flush events every " + DefaultEventProcessor.access$getEventFlushIntervalMillis$p(this.this$0) + " ms";
                }
            });
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            ScheduledJob scheduledJob = this.flushingJob;
            if (scheduledJob != null) {
                scheduledJob.cancel();
            }
            this.flushingJob = null;
            this.flush();
            log.info((Function0)stop.1.1.INSTANCE);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void dispatch(int limit) {
        if (limit <= 0) {
            return;
        }
        List<EventEntity> events = this.eventRepository.getEventsToFlush(limit);
        if (events.isEmpty()) {
            return;
        }
        this.eventDispatcher.dispatch(events);
    }

    @Override
    public void onChanged(@NotNull AppState state, long timestamp) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        switch (DefaultEventProcessor$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                this.start();
                unit = Unit.INSTANCE;
                break;
            }
            case 2: {
                this.stop();
                unit = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AnyKt.getSafe((Object)unit);
    }

    @Override
    public void close() {
        AnyKt.tryClose((Object)this.eventFlushScheduler);
        this.stop();
    }

    private final UserEvent decorateScreenName(UserEvent event) {
        Activity activity = this.activityProvider.getCurrentActivity();
        if (activity == null) {
            return event;
        }
        Activity currentActivity = activity;
        HackleUser.Builder builder = event.getUser().toBuilder();
        String string2 = currentActivity.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentActivity.javaClass.simpleName");
        HackleUser newUser = builder.hackleProperty("screenClass", (Object)string2).build();
        return event.with(newUser);
    }

    public DefaultEventProcessor(@NotNull ExposureEventDeduplicationDeterminer deduplicationDeterminer, @NotNull UserEventPublisher eventPublisher, @NotNull Executor eventExecutor, @NotNull EventRepository eventRepository, int eventRepositoryMaxSize, @NotNull Scheduler eventFlushScheduler, long eventFlushIntervalMillis, int eventFlushThreshold, int eventFlushMaxBatchSize, @NotNull EventDispatcher eventDispatcher, @NotNull SessionManager sessionManager, @NotNull UserManager userManager, @NotNull AppStateManager appStateManager, @NotNull ActivityProvider activityProvider) {
        Intrinsics.checkNotNullParameter((Object)deduplicationDeterminer, (String)"deduplicationDeterminer");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)eventExecutor, (String)"eventExecutor");
        Intrinsics.checkNotNullParameter((Object)eventRepository, (String)"eventRepository");
        Intrinsics.checkNotNullParameter((Object)eventFlushScheduler, (String)"eventFlushScheduler");
        Intrinsics.checkNotNullParameter((Object)eventDispatcher, (String)"eventDispatcher");
        Intrinsics.checkNotNullParameter((Object)sessionManager, (String)"sessionManager");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)appStateManager, (String)"appStateManager");
        Intrinsics.checkNotNullParameter((Object)activityProvider, (String)"activityProvider");
        this.deduplicationDeterminer = deduplicationDeterminer;
        this.eventPublisher = eventPublisher;
        this.eventExecutor = eventExecutor;
        this.eventRepository = eventRepository;
        this.eventRepositoryMaxSize = eventRepositoryMaxSize;
        this.eventFlushScheduler = eventFlushScheduler;
        this.eventFlushIntervalMillis = eventFlushIntervalMillis;
        this.eventFlushThreshold = eventFlushThreshold;
        this.eventFlushMaxBatchSize = eventFlushMaxBatchSize;
        this.eventDispatcher = eventDispatcher;
        this.sessionManager = sessionManager;
        this.userManager = userManager;
        this.appStateManager = appStateManager;
        this.activityProvider = activityProvider;
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = DefaultEventProcessor.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
        LOCK = new Object();
    }

    public static final /* synthetic */ void access$flush(DefaultEventProcessor $this) {
        $this.flush();
    }

    public static final /* synthetic */ long access$getEventFlushIntervalMillis$p(DefaultEventProcessor $this) {
        return $this.eventFlushIntervalMillis;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/hackle/android/internal/event/DefaultEventProcessor$AddEventTask;", "Ljava/lang/Runnable;", "event", "Lio/hackle/sdk/core/event/UserEvent;", "(Lio/hackle/android/internal/event/DefaultEventProcessor;Lio/hackle/sdk/core/event/UserEvent;)V", "decorateSession", "run", "", "save", "update", "hackle-android-sdk_release"})
    public final class AddEventTask
    implements Runnable {
        private final UserEvent event;

        @Override
        public void run() {
            try {
                this.update(this.event);
                if (DefaultEventProcessor.this.deduplicationDeterminer.isDeduplicationTarget(this.event)) {
                    return;
                }
                UserEvent newEvent = this.decorateSession(this.event);
                this.save(newEvent);
                DefaultEventProcessor.this.eventPublisher.publish(newEvent);
            }
            catch (Exception e) {
                log.error((Function0)new Function0<String>(e){
                    final /* synthetic */ Exception $e;

                    @NotNull
                    public final String invoke() {
                        return "Failed to add event: " + this.$e;
                    }
                    {
                        this.$e = exception;
                        super(0);
                    }
                });
            }
        }

        private final void update(UserEvent event) {
            if (SessionEventTracker.Companion.isSessionEvent(event)) {
                return;
            }
            if (DefaultEventProcessor.this.appStateManager.getCurrentState() == AppState.FOREGROUND) {
                DefaultEventProcessor.this.sessionManager.updateLastEventTime(event.getTimestamp());
            } else {
                DefaultEventProcessor.this.sessionManager.startNewSessionIfNeeded(DefaultEventProcessor.this.userManager.getCurrentUser(), event.getTimestamp());
            }
        }

        private final UserEvent decorateSession(UserEvent event) {
            if (event.getUser().getSessionId() != null) {
                return event;
            }
            Session session = DefaultEventProcessor.this.sessionManager.getCurrentSession();
            if (session == null) {
                return event;
            }
            Session session2 = session;
            HackleUser newUser = event.getUser().toBuilder().identifier(IdentifierType.SESSION, session2.getId(), false).build();
            return event.with(newUser);
        }

        private final void save(UserEvent event) {
            long pendingCount;
            DefaultEventProcessor.this.eventRepository.save(event);
            long totalCount = EventRepository.count$default(DefaultEventProcessor.this.eventRepository, null, 1, null);
            if (totalCount > (long)DefaultEventProcessor.this.eventRepositoryMaxSize) {
                DefaultEventProcessor.this.eventRepository.deleteOldEvents(DefaultEventProcessor.this.eventFlushMaxBatchSize);
            }
            if ((pendingCount = DefaultEventProcessor.this.eventRepository.count(EventEntity.Status.PENDING)) >= (long)DefaultEventProcessor.this.eventFlushThreshold && pendingCount % (long)DefaultEventProcessor.this.eventFlushThreshold == 0L) {
                DefaultEventProcessor.this.dispatch(DefaultEventProcessor.this.eventFlushMaxBatchSize);
            }
        }

        public AddEventTask(UserEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.event = event;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/hackle/android/internal/event/DefaultEventProcessor$FlushTask;", "Ljava/lang/Runnable;", "(Lio/hackle/android/internal/event/DefaultEventProcessor;)V", "run", "", "hackle-android-sdk_release"})
    public final class FlushTask
    implements Runnable {
        @Override
        public void run() {
            try {
                DefaultEventProcessor.this.dispatch(DefaultEventProcessor.this.eventFlushMaxBatchSize);
            }
            catch (Exception e) {
                log.error((Function0)new Function0<String>(e){
                    final /* synthetic */ Exception $e;

                    @NotNull
                    public final String invoke() {
                        return "Failed to flush events: " + this.$e;
                    }
                    {
                        this.$e = exception;
                        super(0);
                    }
                });
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/hackle/android/internal/event/DefaultEventProcessor$Companion;", "", "()V", "LOCK", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

