/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.event;

import io.hackle.android.internal.database.repository.EventRepository;
import io.hackle.android.internal.database.workspace.EventEntity;
import io.hackle.android.internal.event.DtoKt;
import io.hackle.android.internal.monitoring.metric.ApiCallMetrics;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import io.hackle.sdk.core.internal.metrics.Timer;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0014\u0010\u0014\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0016\u0010\u0015\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/hackle/android/internal/event/EventDispatcher;", "", "baseEventUri", "", "eventExecutor", "Ljava/util/concurrent/Executor;", "eventRepository", "Lio/hackle/android/internal/database/repository/EventRepository;", "httpExecutor", "httpClient", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Ljava/util/concurrent/Executor;Lio/hackle/android/internal/database/repository/EventRepository;Ljava/util/concurrent/Executor;Lokhttp3/OkHttpClient;)V", "dispatchEndpoint", "Lokhttp3/HttpUrl;", "kotlin.jvm.PlatformType", "delete", "", "events", "", "Lio/hackle/android/internal/database/workspace/EventEntity;", "dispatch", "updateEventStatusToPending", "Companion", "DeleteEventTask", "EventDispatchTask", "UpdateEventToPendingTask", "hackle-android-sdk_release"})
public final class EventDispatcher {
    private final HttpUrl dispatchEndpoint;
    private final Executor eventExecutor;
    private final EventRepository eventRepository;
    private final Executor httpExecutor;
    private final OkHttpClient httpClient;
    private static final Logger log;
    private static final MediaType CONTENT_TYPE;
    private static final String EVENT_DISPATCH_PATH = "/api/v2/events";
    public static final Companion Companion;

    public final void dispatch(@NotNull List<EventEntity> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        try {
            this.httpExecutor.execute(new EventDispatchTask(events));
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to submit EventDispatchTask: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            this.updateEventStatusToPending(events);
        }
    }

    private final void delete(List<EventEntity> events) {
        try {
            this.eventExecutor.execute(new DeleteEventTask(events));
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to submit DeleteEventTask: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    private final void updateEventStatusToPending(List<EventEntity> events) {
        try {
            this.eventExecutor.execute(new UpdateEventToPendingTask(events));
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to submit UpdateEventTask: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    public EventDispatcher(@NotNull String baseEventUri, @NotNull Executor eventExecutor, @NotNull EventRepository eventRepository, @NotNull Executor httpExecutor, @NotNull OkHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)baseEventUri, (String)"baseEventUri");
        Intrinsics.checkNotNullParameter((Object)eventExecutor, (String)"eventExecutor");
        Intrinsics.checkNotNullParameter((Object)eventRepository, (String)"eventRepository");
        Intrinsics.checkNotNullParameter((Object)httpExecutor, (String)"httpExecutor");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.eventExecutor = eventExecutor;
        this.eventRepository = eventRepository;
        this.httpExecutor = httpExecutor;
        this.httpClient = httpClient;
        this.dispatchEndpoint = HttpUrl.get((String)(baseEventUri + EVENT_DISPATCH_PATH));
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = EventDispatcher.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
        CONTENT_TYPE = MediaType.get((String)"application/json; charset=utf-8");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/hackle/android/internal/event/EventDispatcher$EventDispatchTask;", "Ljava/lang/Runnable;", "events", "", "Lio/hackle/android/internal/database/workspace/EventEntity;", "(Lio/hackle/android/internal/event/EventDispatcher;Ljava/util/List;)V", "dispatch", "", "handleResponse", "response", "Lokhttp3/Response;", "run", "hackle-android-sdk_release"})
    public final class EventDispatchTask
    implements Runnable {
        private final List<EventEntity> events;

        @Override
        public void run() {
            try {
                this.dispatch();
            }
            catch (Exception e) {
                log.error((Function0)new Function0<String>(e){
                    final /* synthetic */ Exception $e;

                    @NotNull
                    public final String invoke() {
                        return "Failed to dispatch events: " + this.$e;
                    }
                    {
                        this.$e = exception;
                        super(0);
                    }
                });
                EventDispatcher.this.updateEventStatusToPending(this.events);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void dispatch() {
            Response response;
            RequestBody requestBody = RequestBody.create((MediaType)CONTENT_TYPE, (String)DtoKt.toBody(this.events));
            Request request = new Request.Builder().url(EventDispatcher.this.dispatchEndpoint).post(requestBody).build();
            Object object = ApiCallMetrics.INSTANCE;
            String operation$iv = "post.events";
            boolean $i$f$record = false;
            Timer.Sample sample$iv = Timer.Companion.start$default((Timer.Companion)Timer.Companion, null, (int)1, null);
            try {
                boolean bl = false;
                Response response2 = EventDispatcher.this.httpClient.newCall(request).execute();
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"httpClient.newCall(request).execute()");
                response = response2;
                boolean bl2 = false;
                boolean bl3 = false;
                Response it$iv = response;
                boolean bl4 = false;
                ApiCallMetrics.INSTANCE.record(operation$iv, sample$iv, it$iv);
            }
            catch (Exception e$iv) {
                void this_$iv;
                this_$iv.record(operation$iv, sample$iv, null);
                throw (Throwable)e$iv;
            }
            Response response3 = response;
            object = (Closeable)response3;
            boolean bl = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                Response it = (Response)object;
                boolean bl6 = false;
                this.handleResponse(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        private final void handleResponse(Response response) {
            int n = response.code();
            int n2 = n;
            if (200 <= n2 && 299 >= n2) {
                EventDispatcher.this.delete(this.events);
            } else {
                n2 = n;
                if (400 <= n2 && 499 >= n2) {
                    EventDispatcher.this.delete(this.events);
                } else {
                    throw (Throwable)new IllegalStateException("Http status code: " + response.code());
                }
            }
        }

        public EventDispatchTask(List<EventEntity> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.events = events;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/hackle/android/internal/event/EventDispatcher$DeleteEventTask;", "Ljava/lang/Runnable;", "events", "", "Lio/hackle/android/internal/database/workspace/EventEntity;", "(Lio/hackle/android/internal/event/EventDispatcher;Ljava/util/List;)V", "run", "", "hackle-android-sdk_release"})
    public final class DeleteEventTask
    implements Runnable {
        private final List<EventEntity> events;

        @Override
        public void run() {
            try {
                EventDispatcher.this.eventRepository.delete(this.events);
            }
            catch (Exception e) {
                log.error((Function0)new Function0<String>(e){
                    final /* synthetic */ Exception $e;

                    @NotNull
                    public final String invoke() {
                        return "Failed to delete events: " + this.$e;
                    }
                    {
                        this.$e = exception;
                        super(0);
                    }
                });
            }
        }

        public DeleteEventTask(List<EventEntity> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.events = events;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/hackle/android/internal/event/EventDispatcher$UpdateEventToPendingTask;", "Ljava/lang/Runnable;", "events", "", "Lio/hackle/android/internal/database/workspace/EventEntity;", "(Lio/hackle/android/internal/event/EventDispatcher;Ljava/util/List;)V", "run", "", "hackle-android-sdk_release"})
    public final class UpdateEventToPendingTask
    implements Runnable {
        private final List<EventEntity> events;

        @Override
        public void run() {
            try {
                EventDispatcher.this.eventRepository.update(this.events, EventEntity.Status.PENDING);
            }
            catch (Exception e) {
                log.error((Function0)new Function0<String>(e){
                    final /* synthetic */ Exception $e;

                    @NotNull
                    public final String invoke() {
                        return "Failed to update events: " + this.$e;
                    }
                    {
                        this.$e = exception;
                        super(0);
                    }
                });
            }
        }

        public UpdateEventToPendingTask(List<EventEntity> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.events = events;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/hackle/android/internal/event/EventDispatcher$Companion;", "", "()V", "CONTENT_TYPE", "Lokhttp3/MediaType;", "kotlin.jvm.PlatformType", "EVENT_DISPATCH_PATH", "", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

