/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.event;

import io.hackle.sdk.common.decision.DecisionReason;
import io.hackle.sdk.core.event.UserEvent;
import io.hackle.sdk.core.user.HackleUser;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/hackle/android/internal/event/ExposureEventDeduplicationDeterminer;", "", "exposureEventDedupIntervalMillis", "", "(I)V", "cache", "Ljava/util/HashMap;", "Lio/hackle/android/internal/event/ExposureEventDeduplicationDeterminer$Key;", "", "Lkotlin/collections/HashMap;", "currentUser", "Lio/hackle/sdk/core/user/HackleUser;", "isDeduplicationTarget", "", "event", "Lio/hackle/sdk/core/event/UserEvent;", "Key", "hackle-android-sdk_release"})
public final class ExposureEventDeduplicationDeterminer {
    private HashMap<Key, Long> cache;
    private HackleUser currentUser;
    private final int exposureEventDedupIntervalMillis;

    public final boolean isDeduplicationTarget(@NotNull UserEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.exposureEventDedupIntervalMillis == -1) {
            return false;
        }
        UserEvent userEvent = event;
        if (!(userEvent instanceof UserEvent.Exposure)) {
            userEvent = null;
        }
        UserEvent.Exposure exposure = (UserEvent.Exposure)userEvent;
        if (exposure == null) {
            return false;
        }
        UserEvent.Exposure exposureEvent = exposure;
        HackleUser hackleUser = this.currentUser;
        if (Intrinsics.areEqual((Object)event.getUser().getIdentifiers(), (Object)(hackleUser != null ? hackleUser.getIdentifiers() : null)) ^ true) {
            this.currentUser = event.getUser();
            boolean bl = false;
            this.cache = new HashMap();
        }
        Key key = Key.Companion.from(exposureEvent);
        long now = System.currentTimeMillis();
        Long firstExposureTimeMillis = this.cache.get(key);
        if (firstExposureTimeMillis != null && now - firstExposureTimeMillis <= (long)this.exposureEventDedupIntervalMillis) {
            return true;
        }
        ((Map)this.cache).put(key, now);
        return false;
    }

    public ExposureEventDeduplicationDeterminer(int exposureEventDedupIntervalMillis) {
        this.exposureEventDedupIntervalMillis = exposureEventDedupIntervalMillis;
        boolean bl = false;
        this.cache = new HashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J8\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lio/hackle/android/internal/event/ExposureEventDeduplicationDeterminer$Key;", "", "experimentId", "", "variationId", "variationKey", "", "decisionReason", "Lio/hackle/sdk/common/decision/DecisionReason;", "(JLjava/lang/Long;Ljava/lang/String;Lio/hackle/sdk/common/decision/DecisionReason;)V", "getDecisionReason", "()Lio/hackle/sdk/common/decision/DecisionReason;", "getExperimentId", "()J", "getVariationId", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getVariationKey", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(JLjava/lang/Long;Ljava/lang/String;Lio/hackle/sdk/common/decision/DecisionReason;)Lio/hackle/android/internal/event/ExposureEventDeduplicationDeterminer$Key;", "equals", "", "other", "hashCode", "", "toString", "Companion", "hackle-android-sdk_release"})
    public static final class Key {
        private final long experimentId;
        @Nullable
        private final Long variationId;
        @NotNull
        private final String variationKey;
        @NotNull
        private final DecisionReason decisionReason;
        public static final Companion Companion = new Companion(null);

        public final long getExperimentId() {
            return this.experimentId;
        }

        @Nullable
        public final Long getVariationId() {
            return this.variationId;
        }

        @NotNull
        public final String getVariationKey() {
            return this.variationKey;
        }

        @NotNull
        public final DecisionReason getDecisionReason() {
            return this.decisionReason;
        }

        public Key(long experimentId, @Nullable Long variationId, @NotNull String variationKey, @NotNull DecisionReason decisionReason) {
            Intrinsics.checkNotNullParameter((Object)variationKey, (String)"variationKey");
            Intrinsics.checkNotNullParameter((Object)decisionReason, (String)"decisionReason");
            this.experimentId = experimentId;
            this.variationId = variationId;
            this.variationKey = variationKey;
            this.decisionReason = decisionReason;
        }

        public final long component1() {
            return this.experimentId;
        }

        @Nullable
        public final Long component2() {
            return this.variationId;
        }

        @NotNull
        public final String component3() {
            return this.variationKey;
        }

        @NotNull
        public final DecisionReason component4() {
            return this.decisionReason;
        }

        @NotNull
        public final Key copy(long experimentId, @Nullable Long variationId, @NotNull String variationKey, @NotNull DecisionReason decisionReason) {
            Intrinsics.checkNotNullParameter((Object)variationKey, (String)"variationKey");
            Intrinsics.checkNotNullParameter((Object)decisionReason, (String)"decisionReason");
            return new Key(experimentId, variationId, variationKey, decisionReason);
        }

        public static /* synthetic */ Key copy$default(Key key, long l, Long l2, String string2, DecisionReason decisionReason, int n, Object object) {
            if ((n & 1) != 0) {
                l = key.experimentId;
            }
            if ((n & 2) != 0) {
                l2 = key.variationId;
            }
            if ((n & 4) != 0) {
                string2 = key.variationKey;
            }
            if ((n & 8) != 0) {
                decisionReason = key.decisionReason;
            }
            return key.copy(l, l2, string2, decisionReason);
        }

        @NotNull
        public String toString() {
            return "Key(experimentId=" + this.experimentId + ", variationId=" + this.variationId + ", variationKey=" + this.variationKey + ", decisionReason=" + this.decisionReason + ")";
        }

        public int hashCode() {
            Long l = this.variationId;
            String string2 = this.variationKey;
            DecisionReason decisionReason = this.decisionReason;
            return ((Long.hashCode(this.experimentId) * 31 + (l != null ? ((Object)l).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (decisionReason != null ? decisionReason.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Key)) break block3;
                    Key key = (Key)object;
                    if (this.experimentId != key.experimentId || !Intrinsics.areEqual((Object)this.variationId, (Object)key.variationId) || !Intrinsics.areEqual((Object)this.variationKey, (Object)key.variationKey) || !Intrinsics.areEqual((Object)this.decisionReason, (Object)key.decisionReason)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/hackle/android/internal/event/ExposureEventDeduplicationDeterminer$Key$Companion;", "", "()V", "from", "Lio/hackle/android/internal/event/ExposureEventDeduplicationDeterminer$Key;", "exposureEvent", "Lio/hackle/sdk/core/event/UserEvent$Exposure;", "hackle-android-sdk_release"})
        public static final class Companion {
            @NotNull
            public final Key from(@NotNull UserEvent.Exposure exposureEvent) {
                Intrinsics.checkNotNullParameter((Object)exposureEvent, (String)"exposureEvent");
                return new Key(exposureEvent.getExperiment().getId(), exposureEvent.getVariationId(), exposureEvent.getVariationKey(), exposureEvent.getDecisionReason());
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

