/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.http;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/hackle/android/internal/http/SdkHeaderInterceptor;", "Lokhttp3/Interceptor;", "sdkKey", "", "sdkName", "sdkVersion", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "userAgent", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "hackle-android-sdk_release"})
public final class SdkHeaderInterceptor
implements Interceptor {
    private final String userAgent;
    private final String sdkKey;
    private final String sdkName;
    private final String sdkVersion;
    private static final String SDK_KEY_HEADER = "X-HACKLE-SDK-KEY";
    private static final String SDK_NAME_HEADER = "X-HACKLE-SDK-NAME";
    private static final String SDK_VERSION_HEADER = "X-HACKLE-SDK-VERSION";
    private static final String SDK_TIME_HEADER_NAME = "X-HACKLE-SDK-TIME";
    private static final String USER_AGENT_HEADER = "User-Agent";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request newRequest = chain.request().newBuilder().addHeader(SDK_KEY_HEADER, this.sdkKey).addHeader(SDK_NAME_HEADER, this.sdkName).addHeader(SDK_VERSION_HEADER, this.sdkVersion).addHeader(SDK_TIME_HEADER_NAME, String.valueOf(System.currentTimeMillis())).addHeader(USER_AGENT_HEADER, this.userAgent).build();
        Response response = chain.proceed(newRequest);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(newRequest)");
        return response;
    }

    public SdkHeaderInterceptor(@NotNull String sdkKey, @NotNull String sdkName, @NotNull String sdkVersion) {
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)sdkName, (String)"sdkName");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        this.sdkKey = sdkKey;
        this.sdkName = sdkName;
        this.sdkVersion = sdkVersion;
        this.userAgent = this.sdkName + '/' + this.sdkVersion;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/hackle/android/internal/http/SdkHeaderInterceptor$Companion;", "", "()V", "SDK_KEY_HEADER", "", "SDK_NAME_HEADER", "SDK_TIME_HEADER_NAME", "SDK_VERSION_HEADER", "USER_AGENT_HEADER", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

