/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.http;

import android.content.Context;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.security.ProviderInstaller;
import io.hackle.android.internal.http.Tls;
import io.hackle.android.internal.http.Tls12SocketFactory;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/hackle/android/internal/http/Tls;", "", "()V", "V_1_2", "", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "defaultTrustManager", "Ljavax/net/ssl/X509TrustManager;", "tls12SocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "update", "", "context", "Landroid/content/Context;", "hackle-android-sdk_release"})
public final class Tls {
    private static final Logger log;
    @NotNull
    public static final String V_1_2 = "TLSv1.2";
    public static final Tls INSTANCE;

    public final void update(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            SSLContext.getInstance(V_1_2);
        }
        catch (NoSuchAlgorithmException _) {
            log.info((Function0)update.1.INSTANCE);
            try {
                ProviderInstaller.installIfNeeded((Context)context);
            }
            catch (GooglePlayServicesRepairableException _2) {
                log.error((Function0)update.2.INSTANCE);
            }
            catch (GooglePlayServicesNotAvailableException _3) {
                log.error((Function0)update.3.INSTANCE);
            }
        }
    }

    @NotNull
    public final X509TrustManager defaultTrustManager() {
        TrustManagerFactory trustManagerFactory;
        TrustManagerFactory trustManagerFactory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        boolean bl = false;
        boolean bl2 = false;
        TrustManagerFactory $this$apply = trustManagerFactory2;
        boolean bl3 = false;
        $this$apply.init((KeyStore)null);
        TrustManagerFactory trustManagerFactory3 = trustManagerFactory = trustManagerFactory2;
        Intrinsics.checkNotNullExpressionValue((Object)trustManagerFactory3, (String)"trustManagerFactory");
        Object[] trustManagers = trustManagerFactory3.getTrustManagers();
        bl = trustManagers.length == 1 && trustManagers[0] instanceof X509TrustManager;
        bl2 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Unexpected default trust managers: " + Arrays.toString(trustManagers);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        TrustManager trustManager = trustManagers[0];
        if (trustManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        return (X509TrustManager)trustManager;
    }

    @NotNull
    public final SSLSocketFactory tls12SocketFactory() {
        SSLContext context;
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        boolean bl = false;
        boolean bl2 = false;
        SSLContext $this$apply = sSLContext;
        boolean bl3 = false;
        $this$apply.init(null, null, null);
        SSLContext sSLContext2 = context = sSLContext;
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext2, (String)"context");
        SSLSocketFactory sSLSocketFactory = sSLContext2.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"context.socketFactory");
        return new Tls12SocketFactory(sSLSocketFactory);
    }

    private Tls() {
    }

    static {
        Tls tls;
        INSTANCE = tls = new Tls();
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = Tls.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }
}

