/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.inappmessage.trigger;

import io.hackle.android.internal.inappmessage.storage.InAppMessageImpression;
import io.hackle.android.internal.inappmessage.storage.InAppMessageImpressionStorage;
import io.hackle.android.internal.inappmessage.trigger.InAppMessageEventTriggerDeterminer;
import io.hackle.sdk.core.event.UserEvent;
import io.hackle.sdk.core.model.InAppMessage;
import io.hackle.sdk.core.workspace.Workspace;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerFrequencyCapDeterminer;", "Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerDeterminer;", "storage", "Lio/hackle/android/internal/inappmessage/storage/InAppMessageImpressionStorage;", "(Lio/hackle/android/internal/inappmessage/storage/InAppMessageImpressionStorage;)V", "createMatchContexts", "", "Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerFrequencyCapDeterminer$MatchContext;", "frequencyCap", "Lio/hackle/sdk/core/model/InAppMessage$EventTrigger$FrequencyCap;", "isTriggerTarget", "", "workspace", "Lio/hackle/sdk/core/workspace/Workspace;", "inAppMessage", "Lio/hackle/sdk/core/model/InAppMessage;", "event", "Lio/hackle/sdk/core/event/UserEvent$Track;", "DurationCapPredicate", "FrequencyCapPredicate", "IdentifierCapPredicate", "MatchContext", "hackle-android-sdk_release"})
public final class InAppMessageEventTriggerFrequencyCapDeterminer
implements InAppMessageEventTriggerDeterminer {
    private final InAppMessageImpressionStorage storage;

    @Override
    public boolean isTriggerTarget(@NotNull Workspace workspace, @NotNull InAppMessage inAppMessage, @NotNull UserEvent.Track event) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InAppMessage.EventTrigger.FrequencyCap frequencyCap = inAppMessage.getEventTrigger().getFrequencyCap();
        if (frequencyCap == null) {
            return true;
        }
        InAppMessage.EventTrigger.FrequencyCap frequencyCap2 = frequencyCap;
        List<MatchContext> contexts = this.createMatchContexts(frequencyCap2);
        if (contexts.isEmpty()) {
            return true;
        }
        List<InAppMessageImpression> impressions = this.storage.get(inAppMessage);
        for (InAppMessageImpression impression : impressions) {
            for (MatchContext context : contexts) {
                if (!context.matches((UserEvent)event, impression)) continue;
                return false;
            }
        }
        return true;
    }

    private final List<MatchContext> createMatchContexts(InAppMessage.EventTrigger.FrequencyCap frequencyCap) {
        boolean bl = false;
        List contexts = new ArrayList();
        for (InAppMessage.EventTrigger.IdentifierCap identifierCap : frequencyCap.getIdentifierCaps()) {
            IdentifierCapPredicate predicate = new IdentifierCapPredicate(identifierCap);
            contexts.add(new MatchContext(predicate));
        }
        InAppMessage.EventTrigger.DurationCap durationCap = frequencyCap.getDurationCap();
        if (durationCap != null) {
            contexts.add(new MatchContext(new DurationCapPredicate(durationCap)));
        }
        return contexts;
    }

    public InAppMessageEventTriggerFrequencyCapDeterminer(@NotNull InAppMessageImpressionStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerFrequencyCapDeterminer$MatchContext;", "", "predicate", "Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerFrequencyCapDeterminer$FrequencyCapPredicate;", "(Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerFrequencyCapDeterminer$FrequencyCapPredicate;)V", "matchCount", "", "matches", "", "event", "Lio/hackle/sdk/core/event/UserEvent;", "impression", "Lio/hackle/android/internal/inappmessage/storage/InAppMessageImpression;", "hackle-android-sdk_release"})
    private static final class MatchContext {
        private int matchCount;
        private final FrequencyCapPredicate predicate;

        public final boolean matches(@NotNull UserEvent event, @NotNull InAppMessageImpression impression) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)impression, (String)"impression");
            if (this.predicate.matches(event, impression)) {
                int n = this.matchCount;
                this.matchCount = n + 1;
            }
            return this.matchCount >= this.predicate.getThresholdCount();
        }

        public MatchContext(@NotNull FrequencyCapPredicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            this.predicate = predicate;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerFrequencyCapDeterminer$FrequencyCapPredicate;", "", "thresholdCount", "", "getThresholdCount", "()I", "matches", "", "event", "Lio/hackle/sdk/core/event/UserEvent;", "impression", "Lio/hackle/android/internal/inappmessage/storage/InAppMessageImpression;", "hackle-android-sdk_release"})
    public static interface FrequencyCapPredicate {
        public int getThresholdCount();

        public boolean matches(@NotNull UserEvent var1, @NotNull InAppMessageImpression var2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerFrequencyCapDeterminer$IdentifierCapPredicate;", "Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerFrequencyCapDeterminer$FrequencyCapPredicate;", "identifierCap", "Lio/hackle/sdk/core/model/InAppMessage$EventTrigger$IdentifierCap;", "(Lio/hackle/sdk/core/model/InAppMessage$EventTrigger$IdentifierCap;)V", "thresholdCount", "", "getThresholdCount", "()I", "matches", "", "event", "Lio/hackle/sdk/core/event/UserEvent;", "impression", "Lio/hackle/android/internal/inappmessage/storage/InAppMessageImpression;", "hackle-android-sdk_release"})
    public static final class IdentifierCapPredicate
    implements FrequencyCapPredicate {
        private final InAppMessage.EventTrigger.IdentifierCap identifierCap;

        @Override
        public int getThresholdCount() {
            return this.identifierCap.getCount();
        }

        @Override
        public boolean matches(@NotNull UserEvent event, @NotNull InAppMessageImpression impression) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)impression, (String)"impression");
            String string2 = (String)event.getUser().getIdentifiers().get(this.identifierCap.getIdentifierType());
            if (string2 == null) {
                return false;
            }
            String userIdentifier = string2;
            String string3 = impression.getIdentifiers().get(this.identifierCap.getIdentifierType());
            if (string3 == null) {
                return false;
            }
            String impressionIdentifier = string3;
            return Intrinsics.areEqual((Object)userIdentifier, (Object)impressionIdentifier);
        }

        public IdentifierCapPredicate(@NotNull InAppMessage.EventTrigger.IdentifierCap identifierCap) {
            Intrinsics.checkNotNullParameter((Object)identifierCap, (String)"identifierCap");
            this.identifierCap = identifierCap;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerFrequencyCapDeterminer$DurationCapPredicate;", "Lio/hackle/android/internal/inappmessage/trigger/InAppMessageEventTriggerFrequencyCapDeterminer$FrequencyCapPredicate;", "durationCap", "Lio/hackle/sdk/core/model/InAppMessage$EventTrigger$DurationCap;", "(Lio/hackle/sdk/core/model/InAppMessage$EventTrigger$DurationCap;)V", "thresholdCount", "", "getThresholdCount", "()I", "matches", "", "event", "Lio/hackle/sdk/core/event/UserEvent;", "impression", "Lio/hackle/android/internal/inappmessage/storage/InAppMessageImpression;", "hackle-android-sdk_release"})
    public static final class DurationCapPredicate
    implements FrequencyCapPredicate {
        private final InAppMessage.EventTrigger.DurationCap durationCap;

        @Override
        public int getThresholdCount() {
            return this.durationCap.getCount();
        }

        @Override
        public boolean matches(@NotNull UserEvent event, @NotNull InAppMessageImpression impression) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)impression, (String)"impression");
            return event.getTimestamp() - impression.getTimestamp() <= this.durationCap.getDurationMillis();
        }

        public DurationCapPredicate(@NotNull InAppMessage.EventTrigger.DurationCap durationCap) {
            Intrinsics.checkNotNullParameter((Object)durationCap, (String)"durationCap");
            this.durationCap = durationCap;
        }
    }
}

