/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import io.hackle.android.internal.lifecycle.ActivityProvider;
import io.hackle.android.ui.HackleActivity;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0003)*+B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u001a\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0018\u0010!\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u001dH\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u0018R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00068V@RX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/hackle/android/internal/lifecycle/LifecycleManager;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Lio/hackle/android/internal/lifecycle/ActivityProvider;", "()V", "_currentActivity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "newValue", "currentActivity", "getCurrentActivity", "()Landroid/app/Activity;", "setCurrentActivity", "(Landroid/app/Activity;)V", "currentState", "Lio/hackle/android/internal/lifecycle/LifecycleManager$LifecycleState;", "listeners", "", "Lio/hackle/android/internal/lifecycle/LifecycleManager$LifecycleStateListener;", "addStateListener", "", "listener", "dispatch", "state", "timestamp", "", "dispatchForce", "onActivityCreated", "activity", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "registerActivityLifecycleCallbacks", "context", "Landroid/content/Context;", "repeatCurrentState", "Companion", "LifecycleState", "LifecycleStateListener", "hackle-android-sdk_release"})
public final class LifecycleManager
implements Application.ActivityLifecycleCallbacks,
ActivityProvider {
    private WeakReference<Activity> _currentActivity;
    private LifecycleState currentState;
    private final List<LifecycleStateListener> listeners = new CopyOnWriteArrayList();
    private static final Logger logger;
    private static LifecycleManager _instance;
    public static final Companion Companion;

    @Override
    @Nullable
    public Activity getCurrentActivity() {
        WeakReference<Activity> weakReference = this._currentActivity;
        return weakReference != null ? (Activity)weakReference.get() : null;
    }

    private void setCurrentActivity(Activity newValue) {
        this._currentActivity = new WeakReference<Activity>(newValue);
    }

    public final void registerActivityLifecycleCallbacks(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.Application");
        }
        Application app = (Application)context2;
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public final void repeatCurrentState(long timestamp) {
        block0: {
            LifecycleState lifecycleState = this.currentState;
            if (lifecycleState == null) break block0;
            LifecycleState lifecycleState2 = lifecycleState;
            boolean bl = false;
            boolean bl2 = false;
            LifecycleState it = lifecycleState2;
            boolean bl3 = false;
            logger.debug((Function0)new Function0<String>(it, this, timestamp){
                final /* synthetic */ LifecycleState $it;
                final /* synthetic */ LifecycleManager this$0;
                final /* synthetic */ long $timestamp$inlined;
                {
                    this.$it = lifecycleState;
                    this.this$0 = lifecycleManager;
                    this.$timestamp$inlined = l;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Repeat current lifecycle state [" + (Object)((Object)this.$it) + ':' + this.$timestamp$inlined + ']';
                }
            });
            this.dispatchForce(it, timestamp);
        }
    }

    public static /* synthetic */ void repeatCurrentState$default(LifecycleManager lifecycleManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = System.currentTimeMillis();
        }
        lifecycleManager.repeatCurrentState(l);
    }

    public final void addStateListener(@NotNull LifecycleStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Collection collection = this.listeners;
        boolean bl = false;
        collection.add(listener);
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Intrinsics.areEqual((Object)this.getCurrentActivity(), (Object)activity) ^ true && !(activity instanceof HackleActivity)) {
            this.setCurrentActivity(activity);
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Intrinsics.areEqual((Object)this.getCurrentActivity(), (Object)activity) ^ true && !(activity instanceof HackleActivity)) {
            this.setCurrentActivity(activity);
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Intrinsics.areEqual((Object)activity, (Object)this.getCurrentActivity())) {
            this.setCurrentActivity(null);
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Intrinsics.areEqual((Object)this.getCurrentActivity(), (Object)activity) ^ true && !(activity instanceof HackleActivity)) {
            this.setCurrentActivity(activity);
        }
        LifecycleManager.dispatch$default(this, LifecycleState.FOREGROUND, 0L, 2, null);
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        LifecycleManager.dispatch$default(this, LifecycleState.BACKGROUND, 0L, 2, null);
    }

    private final void dispatch(LifecycleState state, long timestamp) {
        this.currentState = state;
        this.dispatchForce(state, timestamp);
    }

    static /* synthetic */ void dispatch$default(LifecycleManager lifecycleManager, LifecycleState lifecycleState, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        lifecycleManager.dispatch(lifecycleState, l);
    }

    private final void dispatchForce(LifecycleState state, long timestamp) {
        for (LifecycleStateListener listener : this.listeners) {
            try {
                listener.onState(state, timestamp);
            }
            catch (Throwable throwable) {
                logger.error((Function0)new Function0<String>(listener, state, throwable){
                    final /* synthetic */ LifecycleStateListener $listener;
                    final /* synthetic */ LifecycleState $state;
                    final /* synthetic */ Throwable $throwable;

                    @NotNull
                    public final String invoke() {
                        return "Unexpected exception calling " + this.$listener.getClass().getSimpleName() + '[' + (Object)((Object)this.$state) + "]: " + this.$throwable;
                    }
                    {
                        this.$listener = lifecycleStateListener;
                        this.$state = lifecycleState;
                        this.$throwable = throwable;
                        super(0);
                    }
                });
            }
            logger.debug((Function0)new Function0<String>(state, timestamp){
                final /* synthetic */ LifecycleState $state;
                final /* synthetic */ long $timestamp;

                @NotNull
                public final String invoke() {
                    return "Dispatched lifecycle state [" + (Object)((Object)this.$state) + ':' + this.$timestamp + ']';
                }
                {
                    this.$state = lifecycleState;
                    this.$timestamp = l;
                    super(0);
                }
            });
        }
    }

    static /* synthetic */ void dispatchForce$default(LifecycleManager lifecycleManager, LifecycleState lifecycleState, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        lifecycleManager.dispatchForce(lifecycleState, l);
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = LifecycleManager.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        logger = delegatingLoggerFactory.getLogger(string2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/hackle/android/internal/lifecycle/LifecycleManager$LifecycleState;", "", "(Ljava/lang/String;I)V", "FOREGROUND", "BACKGROUND", "hackle-android-sdk_release"})
    public static final class LifecycleState
    extends Enum<LifecycleState> {
        public static final /* enum */ LifecycleState FOREGROUND;
        public static final /* enum */ LifecycleState BACKGROUND;
        private static final /* synthetic */ LifecycleState[] $VALUES;

        static {
            LifecycleState[] lifecycleStateArray = new LifecycleState[2];
            LifecycleState[] lifecycleStateArray2 = lifecycleStateArray;
            lifecycleStateArray[0] = FOREGROUND = new LifecycleState();
            lifecycleStateArray[1] = BACKGROUND = new LifecycleState();
            $VALUES = lifecycleStateArray;
        }

        public static LifecycleState[] values() {
            return (LifecycleState[])$VALUES.clone();
        }

        public static LifecycleState valueOf(String string2) {
            return Enum.valueOf(LifecycleState.class, string2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lio/hackle/android/internal/lifecycle/LifecycleManager$LifecycleStateListener;", "", "onState", "", "state", "Lio/hackle/android/internal/lifecycle/LifecycleManager$LifecycleState;", "timestamp", "", "hackle-android-sdk_release"})
    public static interface LifecycleStateListener {
        public void onState(@NotNull LifecycleState var1, long var2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/hackle/android/internal/lifecycle/LifecycleManager$Companion;", "", "()V", "_instance", "Lio/hackle/android/internal/lifecycle/LifecycleManager;", "logger", "Lio/hackle/sdk/core/internal/log/Logger;", "getInstance", "hackle-android-sdk_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final LifecycleManager getInstance() {
            LifecycleManager lifecycleManager = _instance;
            if (lifecycleManager == null) {
                boolean bl = false;
                boolean bl2 = false;
                synchronized (this) {
                    boolean bl3 = false;
                    LifecycleManager lifecycleManager2 = _instance;
                    if (lifecycleManager2 == null) {
                        LifecycleManager lifecycleManager3 = new LifecycleManager();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        LifecycleManager it = lifecycleManager3;
                        boolean bl6 = false;
                        _instance = it;
                        lifecycleManager2 = lifecycleManager3;
                    }
                    LifecycleManager lifecycleManager4 = lifecycleManager2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl20 : MonitorExitStatement: MONITOREXIT : this
                    lifecycleManager = lifecycleManager4;
                }
            }
            return lifecycleManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

