/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.log;

import android.util.Log;
import io.hackle.sdk.core.internal.log.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\u0016\u0010\t\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\u0016\u0010\f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\u001f\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0082\bJ\u0016\u0010\u0011\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/hackle/android/internal/log/AndroidLogger;", "Lio/hackle/sdk/core/internal/log/Logger;", "()V", "TAG", "", "debug", "", "msg", "Lkotlin/Function0;", "error", "x", "", "info", "loggingIfEnabled", "level", "", "logging", "warn", "Factory", "hackle-android-sdk_release"})
public final class AndroidLogger
implements Logger {
    private static final String TAG = "HackleSdk";
    public static final AndroidLogger INSTANCE;

    public void debug(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        AndroidLogger androidLogger = this;
        int level$iv = 3;
        boolean $i$f$loggingIfEnabled = false;
        if (Factory.INSTANCE.getLogLevel() <= level$iv) {
            boolean bl = false;
            Log.d((String)TAG, (String)((String)msg.invoke()));
        }
    }

    public void info(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        AndroidLogger androidLogger = this;
        int level$iv = 4;
        boolean $i$f$loggingIfEnabled = false;
        if (Factory.INSTANCE.getLogLevel() <= level$iv) {
            boolean bl = false;
            Log.i((String)TAG, (String)((String)msg.invoke()));
        }
    }

    public void warn(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        AndroidLogger androidLogger = this;
        int level$iv = 5;
        boolean $i$f$loggingIfEnabled = false;
        if (Factory.INSTANCE.getLogLevel() <= level$iv) {
            boolean bl = false;
            Log.w((String)TAG, (String)((String)msg.invoke()));
        }
    }

    public void error(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        AndroidLogger androidLogger = this;
        int level$iv = 6;
        boolean $i$f$loggingIfEnabled = false;
        if (Factory.INSTANCE.getLogLevel() <= level$iv) {
            boolean bl = false;
            Log.e((String)TAG, (String)((String)msg.invoke()));
        }
    }

    public void error(@NotNull Throwable x, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        AndroidLogger androidLogger = this;
        int level$iv = 6;
        boolean $i$f$loggingIfEnabled = false;
        if (Factory.INSTANCE.getLogLevel() <= level$iv) {
            boolean bl = false;
            Log.e((String)TAG, (String)((String)msg.invoke()), (Throwable)x);
        }
    }

    private final void loggingIfEnabled(int level, Function0<Unit> logging) {
        int $i$f$loggingIfEnabled = 0;
        if (Factory.INSTANCE.getLogLevel() <= level) {
            logging.invoke();
        }
    }

    private AndroidLogger() {
    }

    static {
        AndroidLogger androidLogger;
        INSTANCE = androidLogger = new AndroidLogger();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lio/hackle/android/internal/log/AndroidLogger$Factory;", "Lio/hackle/sdk/core/internal/log/Logger$Factory;", "()V", "logLevel", "", "getLogLevel", "()I", "setLogLevel", "(I)V", "getLogger", "Lio/hackle/sdk/core/internal/log/Logger;", "name", "", "level", "hackle-android-sdk_release"})
    public static final class Factory
    implements Logger.Factory {
        private static int logLevel;
        public static final Factory INSTANCE;

        public final int getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(int n) {
            logLevel = n;
        }

        @NotNull
        public final Factory logLevel(int level) {
            Factory factory = this;
            boolean bl = false;
            boolean bl2 = false;
            Factory $this$apply = factory;
            boolean bl3 = false;
            logLevel = level;
            return factory;
        }

        @NotNull
        public Logger getLogger(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return INSTANCE;
        }

        private Factory() {
        }

        static {
            Factory factory;
            INSTANCE = factory = new Factory();
            logLevel = 4;
        }
    }
}

