/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.model;

import io.hackle.android.internal.model.Device;
import io.hackle.android.internal.platform.Platform;
import io.hackle.android.internal.platform.model.DeviceInfo;
import io.hackle.android.internal.platform.model.PackageInfo;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\f\u0010\u0019\u001a\u00020\u0003*\u00020\u001aH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lio/hackle/android/internal/model/DeviceImpl;", "Lio/hackle/android/internal/model/Device;", "id", "", "platform", "Lio/hackle/android/internal/platform/Platform;", "(Ljava/lang/String;Lio/hackle/android/internal/platform/Platform;)V", "getId", "()Ljava/lang/String;", "getPlatform", "()Lio/hackle/android/internal/platform/Platform;", "properties", "", "", "getProperties", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "toLocaleString", "Ljava/util/Locale;", "hackle-android-sdk_release"})
public final class DeviceImpl
implements Device {
    @NotNull
    private final String id;
    @NotNull
    private final Platform platform;

    @Override
    @NotNull
    public Map<String, Object> getProperties() {
        PackageInfo packageInfo = this.platform.getPackageInfo();
        DeviceInfo deviceInfo = this.platform.getCurrentDeviceInfo();
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"platform", (Object)"Android"), TuplesKt.to((Object)"packageName", (Object)packageInfo.getPackageName()), TuplesKt.to((Object)"versionName", (Object)packageInfo.getVersionName()), TuplesKt.to((Object)"versionCode", (Object)packageInfo.getVersionCode()), TuplesKt.to((Object)"osName", (Object)deviceInfo.getOsName()), TuplesKt.to((Object)"osVersion", (Object)deviceInfo.getOsVersion()), TuplesKt.to((Object)"deviceModel", (Object)deviceInfo.getModel()), TuplesKt.to((Object)"deviceType", (Object)deviceInfo.getType()), TuplesKt.to((Object)"deviceBrand", (Object)deviceInfo.getBrand()), TuplesKt.to((Object)"deviceManufacturer", (Object)deviceInfo.getManufacturer()), TuplesKt.to((Object)"locale", (Object)this.toLocaleString(deviceInfo.getLocale())), TuplesKt.to((Object)"language", (Object)deviceInfo.getLocale().getLanguage()), TuplesKt.to((Object)"timeZone", (Object)deviceInfo.getTimezone().getID()), TuplesKt.to((Object)"screenWidth", (Object)deviceInfo.getScreenInfo().getWidth()), TuplesKt.to((Object)"screenHeight", (Object)deviceInfo.getScreenInfo().getHeight()), TuplesKt.to((Object)"isApp", (Object)true)});
    }

    private final String toLocaleString(Locale $this$toLocaleString) {
        return $this$toLocaleString.getLanguage() + '-' + $this$toLocaleString.getCountry();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    public DeviceImpl(@NotNull String id2, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.id = id2;
        this.platform = platform;
    }

    @NotNull
    public final String component1() {
        return this.getId();
    }

    @NotNull
    public final Platform component2() {
        return this.platform;
    }

    @NotNull
    public final DeviceImpl copy(@NotNull String id2, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        return new DeviceImpl(id2, platform);
    }

    public static /* synthetic */ DeviceImpl copy$default(DeviceImpl deviceImpl, String string2, Platform platform, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = deviceImpl.getId();
        }
        if ((n & 2) != 0) {
            platform = deviceImpl.platform;
        }
        return deviceImpl.copy(string2, platform);
    }

    @NotNull
    public String toString() {
        return "DeviceImpl(id=" + this.getId() + ", platform=" + this.platform + ")";
    }

    public int hashCode() {
        String string2 = this.getId();
        Platform platform = this.platform;
        return (string2 != null ? string2.hashCode() : 0) * 31 + (platform != null ? platform.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DeviceImpl)) break block3;
                DeviceImpl deviceImpl = (DeviceImpl)object;
                if (!Intrinsics.areEqual((Object)this.getId(), (Object)deviceImpl.getId()) || !Intrinsics.areEqual((Object)this.platform, (Object)deviceImpl.platform)) break block3;
            }
            return true;
        }
        return false;
    }
}

