/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.monitoring.metric;

import io.hackle.sdk.common.decision.Decision;
import io.hackle.sdk.common.decision.FeatureFlagDecision;
import io.hackle.sdk.common.decision.RemoteConfigDecision;
import io.hackle.sdk.core.decision.InAppMessageDecision;
import io.hackle.sdk.core.internal.metrics.Metrics;
import io.hackle.sdk.core.internal.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00102\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0011\u00a8\u0006\u0012"}, d2={"Lio/hackle/android/internal/monitoring/metric/DecisionMetrics;", "", "()V", "experiment", "", "sample", "Lio/hackle/sdk/core/internal/metrics/Timer$Sample;", "key", "", "decision", "Lio/hackle/sdk/common/decision/Decision;", "featureFlag", "Lio/hackle/sdk/common/decision/FeatureFlagDecision;", "inAppMessage", "Lio/hackle/sdk/core/decision/InAppMessageDecision;", "remoteConfig", "", "Lio/hackle/sdk/common/decision/RemoteConfigDecision;", "hackle-android-sdk_release"})
public final class DecisionMetrics {
    public static final DecisionMetrics INSTANCE;

    public final void experiment(@NotNull Timer.Sample sample, long key, @NotNull Decision decision) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        Intrinsics.checkNotNullParameter((Object)decision, (String)"decision");
        HashMap tags = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"key", (Object)String.valueOf(key)), TuplesKt.to((Object)"variation", (Object)decision.getVariation().name()), TuplesKt.to((Object)"reason", (Object)decision.getReason().name())});
        Timer timer = Metrics.INSTANCE.timer("experiment.decision", (Map)tags);
        sample.stop(timer);
    }

    public final void featureFlag(@NotNull Timer.Sample sample, long key, @NotNull FeatureFlagDecision decision) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        Intrinsics.checkNotNullParameter((Object)decision, (String)"decision");
        HashMap tags = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"key", (Object)String.valueOf(key)), TuplesKt.to((Object)"on", (Object)String.valueOf(decision.isOn())), TuplesKt.to((Object)"reason", (Object)decision.getReason().name())});
        Timer timer = Metrics.INSTANCE.timer("feature.flag.decision", (Map)tags);
        sample.stop(timer);
    }

    public final void remoteConfig(@NotNull Timer.Sample sample, @NotNull String key, @NotNull RemoteConfigDecision<?> decision) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(decision, (String)"decision");
        HashMap tags = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"key", (Object)key), TuplesKt.to((Object)"reason", (Object)decision.getReason().name())});
        Timer timer = Metrics.INSTANCE.timer("remote.config.decision", (Map)tags);
        sample.stop(timer);
    }

    public final void inAppMessage(@NotNull Timer.Sample sample, long key, @NotNull InAppMessageDecision decision) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        Intrinsics.checkNotNullParameter((Object)decision, (String)"decision");
        HashMap tags = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"key", (Object)String.valueOf(key)), TuplesKt.to((Object)"show", (Object)(decision.isShow() ? "true" : "false")), TuplesKt.to((Object)"reason", (Object)decision.getReason().name())});
        Timer timer = Metrics.INSTANCE.timer("iam.decision", (Map)tags);
        sample.stop(timer);
    }

    private DecisionMetrics() {
    }

    static {
        DecisionMetrics decisionMetrics;
        INSTANCE = decisionMetrics = new DecisionMetrics();
    }
}

