/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.notification;

import io.hackle.android.internal.database.repository.KeyValueRepository;
import io.hackle.android.internal.database.repository.NotificationHistoryRepository;
import io.hackle.android.internal.database.shared.NotificationHistoryEntity;
import io.hackle.android.internal.notification.NotificationEventKt;
import io.hackle.android.internal.notification.NotificationManager;
import io.hackle.android.internal.notification.RegisterPushTokenEvent;
import io.hackle.android.internal.user.UserListener;
import io.hackle.android.internal.user.UserManager;
import io.hackle.android.ui.notification.NotificationData;
import io.hackle.android.ui.notification.NotificationDataReceiver;
import io.hackle.sdk.common.Event;
import io.hackle.sdk.common.User;
import io.hackle.sdk.core.HackleCore;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import io.hackle.sdk.core.user.HackleUser;
import io.hackle.sdk.core.workspace.Workspace;
import io.hackle.sdk.core.workspace.WorkspaceFetcher;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0002./B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0016J \u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u00112\b\b\u0002\u0010 \u001a\u00020!J \u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R(\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00118B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/hackle/android/internal/notification/NotificationManager;", "Lio/hackle/android/ui/notification/NotificationDataReceiver;", "Lio/hackle/android/internal/user/UserListener;", "core", "Lio/hackle/sdk/core/HackleCore;", "executor", "Ljava/util/concurrent/Executor;", "workspaceFetcher", "Lio/hackle/sdk/core/workspace/WorkspaceFetcher;", "userManager", "Lio/hackle/android/internal/user/UserManager;", "preferences", "Lio/hackle/android/internal/database/repository/KeyValueRepository;", "repository", "Lio/hackle/android/internal/database/repository/NotificationHistoryRepository;", "(Lio/hackle/sdk/core/HackleCore;Ljava/util/concurrent/Executor;Lio/hackle/sdk/core/workspace/WorkspaceFetcher;Lio/hackle/android/internal/user/UserManager;Lio/hackle/android/internal/database/repository/KeyValueRepository;Lio/hackle/android/internal/database/repository/NotificationHistoryRepository;)V", "value", "", "_registeredPushToken", "get_registeredPushToken", "()Ljava/lang/String;", "set_registeredPushToken", "(Ljava/lang/String;)V", "flushing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "registeredPushToken", "getRegisteredPushToken", "flush", "", "notifyPushTokenChanged", "user", "Lio/hackle/sdk/common/User;", "timestamp", "", "onNotificationDataReceived", "data", "Lio/hackle/android/ui/notification/NotificationData;", "onUserUpdated", "oldUser", "newUser", "saveInLocal", "setPushToken", "fcmToken", "track", "event", "Lio/hackle/sdk/common/Event;", "Companion", "FlushTask", "hackle-android-sdk_release"})
public final class NotificationManager
implements NotificationDataReceiver,
UserListener {
    private final AtomicBoolean flushing;
    private final HackleCore core;
    private final Executor executor;
    private final WorkspaceFetcher workspaceFetcher;
    private final UserManager userManager;
    private final KeyValueRepository preferences;
    private final NotificationHistoryRepository repository;
    private static final String KEY_FCM_TOKEN = "fcm_token";
    private static final int DEFAULT_FLUSH_BATCH_SIZE = 5;
    private static final Logger log;
    public static final Companion Companion;

    private final String get_registeredPushToken() {
        return this.preferences.getString(KEY_FCM_TOKEN);
    }

    private final void set_registeredPushToken(String value) {
        if (value == null) {
            this.preferences.remove(KEY_FCM_TOKEN);
        } else {
            this.preferences.putString(KEY_FCM_TOKEN, value);
        }
    }

    @Nullable
    public final String getRegisteredPushToken() {
        return this.get_registeredPushToken();
    }

    public final void setPushToken(@NotNull String fcmToken, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)fcmToken, (String)"fcmToken");
        try {
            if (Intrinsics.areEqual((Object)this.get_registeredPushToken(), (Object)fcmToken)) {
                log.debug((Function0)setPushToken.1.INSTANCE);
                return;
            }
            this.set_registeredPushToken(fcmToken);
            this.notifyPushTokenChanged(this.userManager.getCurrentUser(), timestamp);
        }
        catch (Exception e) {
            log.debug((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to register FCM push token: " + this.$e;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    public static /* synthetic */ void setPushToken$default(NotificationManager notificationManager, String string2, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        notificationManager.setPushToken(string2, l);
    }

    public final void flush() {
        if (this.flushing.getAndSet(true)) {
            return;
        }
        this.executor.execute(new FlushTask(this, 0, 1, null));
    }

    @Override
    public void onUserUpdated(@NotNull User oldUser, @NotNull User newUser, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)oldUser, (String)"oldUser");
        Intrinsics.checkNotNullParameter((Object)newUser, (String)"newUser");
        this.notifyPushTokenChanged(newUser, timestamp);
    }

    @Override
    public void onNotificationDataReceived(@NotNull NotificationData data, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Workspace workspace = this.workspaceFetcher.fetch();
            if (workspace == null || workspace.getId() != data.getWorkspaceId() || workspace.getEnvironmentId() != data.getEnvironmentId()) {
                if (workspace == null) {
                    log.debug((Function0)onNotificationDataReceived.1.INSTANCE);
                } else {
                    log.debug((Function0)new Function0<String>(workspace, data){
                        final /* synthetic */ Workspace $workspace;
                        final /* synthetic */ NotificationData $data;

                        @NotNull
                        public final String invoke() {
                            return "Current environment(" + this.$workspace.getId() + ':' + this.$workspace.getEnvironmentId() + ") is not same as notification environment(" + this.$data.getWorkspaceId() + ':' + this.$data.getEnvironmentId() + ").";
                        }
                        {
                            this.$workspace = workspace;
                            this.$data = notificationData;
                            super(0);
                        }
                    });
                }
                this.saveInLocal(data, timestamp);
                return;
            }
            this.track(NotificationEventKt.toTrackEvent(data), this.userManager.getCurrentUser(), timestamp);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(data){
                final /* synthetic */ NotificationData $data;

                @NotNull
                public final String invoke() {
                    return "Failed to handle notification data: " + this.$data.getMessageId();
                }
                {
                    this.$data = notificationData;
                    super(0);
                }
            });
        }
    }

    private final void notifyPushTokenChanged(User user, long timestamp) {
        String fcmToken = this.preferences.getString(KEY_FCM_TOKEN);
        CharSequence charSequence = fcmToken;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            log.debug((Function0)notifyPushTokenChanged.1.INSTANCE);
            return;
        }
        Event event = NotificationEventKt.toTrackEvent$default(new RegisterPushTokenEvent(fcmToken), null, 1, null);
        this.track(event, user, timestamp);
    }

    private final void saveInLocal(NotificationData data, long timestamp) {
        this.executor.execute(new Runnable(this, data, timestamp){
            final /* synthetic */ NotificationManager this$0;
            final /* synthetic */ NotificationData $data;
            final /* synthetic */ long $timestamp;

            public final void run() {
                try {
                    NotificationManager.access$getRepository$p(this.this$0).save(this.$data, this.$timestamp);
                    NotificationManager.access$getLog$cp().debug((Function0)new Function0<String>(this){
                        final /* synthetic */ saveInLocal.1 this$0;

                        @NotNull
                        public final String invoke() {
                            return "Saved notification data: " + this.this$0.$data.getPushMessageId() + '[' + this.this$0.$timestamp + ']';
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                catch (Exception e) {
                    NotificationManager.access$getLog$cp().debug((Function0)new Function0<String>(e){
                        final /* synthetic */ Exception $e;

                        @NotNull
                        public final String invoke() {
                            return "Notification data save error: " + this.$e;
                        }
                        {
                            this.$e = exception;
                            super(0);
                        }
                    });
                }
            }
            {
                this.this$0 = notificationManager;
                this.$data = notificationData;
                this.$timestamp = l;
            }
        });
    }

    private final void track(Event event, User user, long timestamp) {
        HackleUser hackleUser = this.userManager.toHackleUser(user);
        this.core.track(event, hackleUser, timestamp);
        log.debug((Function0)new Function0<String>(event){
            final /* synthetic */ Event $event;

            @NotNull
            public final String invoke() {
                return this.$event.getKey() + " event queued.";
            }
            {
                this.$event = event;
                super(0);
            }
        });
    }

    public NotificationManager(@NotNull HackleCore core, @NotNull Executor executor, @NotNull WorkspaceFetcher workspaceFetcher, @NotNull UserManager userManager, @NotNull KeyValueRepository preferences, @NotNull NotificationHistoryRepository repository) {
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)workspaceFetcher, (String)"workspaceFetcher");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.core = core;
        this.executor = executor;
        this.workspaceFetcher = workspaceFetcher;
        this.userManager = userManager;
        this.preferences = preferences;
        this.repository = repository;
        this.flushing = new AtomicBoolean(false);
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = NotificationManager.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/hackle/android/internal/notification/NotificationManager$FlushTask;", "Ljava/lang/Runnable;", "batchSize", "", "(Lio/hackle/android/internal/notification/NotificationManager;I)V", "run", "", "hackle-android-sdk_release"})
    private final class FlushTask
    implements Runnable {
        private final int batchSize;
        final /* synthetic */ NotificationManager this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            try {
                Workspace workspace = this.this$0.workspaceFetcher.fetch();
                if (workspace == null) {
                    log.debug((Function0)run.1.INSTANCE);
                    return;
                }
                User user = this.this$0.userManager.getCurrentUser();
                int totalCount = this.this$0.repository.count(workspace.getId(), workspace.getEnvironmentId());
                if (totalCount <= 0) {
                    log.debug((Function0)run.2.INSTANCE);
                    return;
                }
                double d = (double)totalCount / (double)this.batchSize;
                boolean bl = false;
                int loop = (int)Math.ceil(d);
                log.debug((Function0)new Function0<String>(totalCount){
                    final /* synthetic */ int $totalCount;

                    @NotNull
                    public final String invoke() {
                        return "Notification data: " + this.$totalCount;
                    }
                    {
                        this.$totalCount = n;
                        super(0);
                    }
                });
                int n = 0;
                int n2 = loop;
                while (n < n2) {
                    void index;
                    List<NotificationHistoryEntity> notifications = this.this$0.repository.getEntities(workspace.getId(), workspace.getEnvironmentId(), this.batchSize);
                    if (notifications.isEmpty()) {
                        break;
                    }
                    for (NotificationHistoryEntity notification : notifications) {
                        this.this$0.track(NotificationEventKt.toTrackEvent(notification), user, notification.getTimestamp());
                        log.debug((Function0)new Function0<String>(notification){
                            final /* synthetic */ NotificationHistoryEntity $notification;

                            @NotNull
                            public final String invoke() {
                                return "Notification data[id=" + this.$notification.getHistoryId() + "] successfully processed.";
                            }
                            {
                                this.$notification = notificationHistoryEntity;
                                super(0);
                            }
                        });
                    }
                    this.this$0.repository.delete(notifications);
                    log.debug((Function0)new Function0<String>(notifications){
                        final /* synthetic */ List $notifications;

                        @NotNull
                        public final String invoke() {
                            return "Flushed notification data: " + this.$notifications.size() + " items";
                        }
                        {
                            this.$notifications = list;
                            super(0);
                        }
                    });
                    ++index;
                }
            }
            catch (Exception e) {
                log.debug((Function0)new Function0<String>(e){
                    final /* synthetic */ Exception $e;

                    @NotNull
                    public final String invoke() {
                        return "Failed to flush notification data: " + this.$e;
                    }
                    {
                        this.$e = exception;
                        super(0);
                    }
                });
            }
            finally {
                this.this$0.flushing.set(false);
                log.debug((Function0)run.7.INSTANCE);
            }
        }

        public FlushTask(NotificationManager this$0, int batchSize) {
            this.this$0 = this$0;
            this.batchSize = batchSize;
        }

        public /* synthetic */ FlushTask(NotificationManager notificationManager, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 5;
            }
            this(notificationManager, n);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/hackle/android/internal/notification/NotificationManager$Companion;", "", "()V", "DEFAULT_FLUSH_BATCH_SIZE", "", "KEY_FCM_TOKEN", "", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

