/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.platform;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import io.hackle.android.internal.platform.Platform;
import io.hackle.android.internal.platform.helper.DeviceHelper;
import io.hackle.android.internal.platform.model.DeviceInfo;
import io.hackle.android.internal.platform.model.PackageInfo;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/hackle/android/internal/platform/AndroidPlatform;", "Lio/hackle/android/internal/platform/Platform;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "packageInfo", "Lio/hackle/android/internal/platform/model/PackageInfo;", "getCurrentDeviceInfo", "Lio/hackle/android/internal/platform/model/DeviceInfo;", "getPackageInfo", "hackle-android-sdk_release"})
public final class AndroidPlatform
implements Platform {
    private final PackageInfo packageInfo;
    @NotNull
    private final Context context;

    @Override
    @NotNull
    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    @Override
    @NotNull
    public DeviceInfo getCurrentDeviceInfo() {
        DisplayMetrics displayMetrics = DeviceHelper.INSTANCE.getDisplayMetrics(this.context);
        String string2 = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Build.VERSION.RELEASE");
        String string3 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Build.MODEL");
        String string4 = DeviceHelper.INSTANCE.getDeviceType(this.context);
        String string5 = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"Build.BRAND");
        String string6 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"Build.MANUFACTURER");
        Locale locale = DeviceHelper.INSTANCE.getDeviceLocale();
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"TimeZone.getDefault()");
        return new DeviceInfo("Android", string2, string3, string4, string5, string6, locale, timeZone, new DeviceInfo.ScreenInfo(displayMetrics.widthPixels, displayMetrics.heightPixels));
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public AndroidPlatform(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        String packageName = "";
        String versionName = "";
        long versionCode = 0L;
        try {
            long l;
            android.content.pm.PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            String string2 = packageInfo.packageName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageInfo.packageName");
            packageName = string2;
            String string3 = packageInfo.versionName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"packageInfo.versionName");
            versionName = string3;
            if (Build.VERSION.SDK_INT >= 28) {
                android.content.pm.PackageInfo packageInfo2 = packageInfo;
                Intrinsics.checkNotNullExpressionValue((Object)packageInfo2, (String)"packageInfo");
                l = packageInfo2.getLongVersionCode();
            } else {
                l = packageInfo.versionCode;
            }
            versionCode = l;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.packageInfo = new PackageInfo(packageName, versionName, versionCode);
    }
}

