/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.platform.helper;

import android.app.UiModeManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.LocaleList;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/hackle/android/internal/platform/helper/DeviceHelper;", "", "()V", "WINDOW_SIZE_MEDIUM", "", "getDeviceLocale", "Ljava/util/Locale;", "getDeviceType", "", "context", "Landroid/content/Context;", "getDisplayMetrics", "Landroid/util/DisplayMetrics;", "hackle-android-sdk_release"})
public final class DeviceHelper {
    private static final int WINDOW_SIZE_MEDIUM = 600;
    public static final DeviceHelper INSTANCE;

    @NotNull
    public final String getDeviceType(@NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("uimode");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.UiModeManager");
        }
        UiModeManager service = (UiModeManager)object;
        switch (service.getCurrentModeType()) {
            case 1: {
                Resources resources = context.getResources();
                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
                if (resources.getConfiguration().smallestScreenWidthDp < 600) {
                    string2 = "phone";
                    break;
                }
                string2 = "tablet";
                break;
            }
            case 4: {
                string2 = "tv";
                break;
            }
            case 2: {
                string2 = "pc";
                break;
            }
            case 3: {
                string2 = "car";
                break;
            }
            case 5: {
                string2 = "appliance";
                break;
            }
            case 6: {
                string2 = "watch";
                break;
            }
            case 7: {
                string2 = "vr";
                break;
            }
            default: {
                string2 = "undefined";
            }
        }
        return string2;
    }

    @NotNull
    public final Locale getDeviceLocale() {
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        Configuration configuration = resources.getConfiguration();
        if (Build.VERSION.SDK_INT >= 24) {
            Locale locale;
            Configuration configuration2 = configuration;
            Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"configuration");
            LocaleList localeList = configuration2.getLocales();
            Intrinsics.checkNotNullExpressionValue((Object)localeList, (String)"configuration.locales");
            if (localeList.isEmpty()) {
                Locale locale2 = Locale.getDefault();
                locale = locale2;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"Locale.getDefault()");
            } else {
                Locale locale3 = configuration.getLocales().get(0);
                locale = locale3;
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"configuration.locales[0]");
            }
            return locale;
        }
        Locale locale = configuration.locale;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"configuration.locale");
        return locale;
    }

    @NotNull
    public final DisplayMetrics getDisplayMetrics(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DisplayMetrics metrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            Object object = context.getSystemService("display");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.hardware.display.DisplayManager");
            }
            DisplayManager displayManager = (DisplayManager)object;
            Display display = displayManager.getDisplay(0);
            display.getRealMetrics(metrics);
        } else {
            Object object = context.getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager windowManager = (WindowManager)object;
            Display display = windowManager.getDefaultDisplay();
            display.getMetrics(metrics);
        }
        return metrics;
    }

    private DeviceHelper() {
    }

    static {
        DeviceHelper deviceHelper;
        INSTANCE = deviceHelper = new DeviceHelper();
    }
}

