/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.remoteconfig;

import io.hackle.android.internal.monitoring.metric.DecisionMetrics;
import io.hackle.android.internal.user.UserManager;
import io.hackle.sdk.common.HackleRemoteConfig;
import io.hackle.sdk.common.User;
import io.hackle.sdk.common.decision.DecisionReason;
import io.hackle.sdk.common.decision.RemoteConfigDecision;
import io.hackle.sdk.core.HackleCore;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import io.hackle.sdk.core.internal.metrics.Timer;
import io.hackle.sdk.core.model.ValueType;
import io.hackle.sdk.core.user.HackleUser;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ5\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u0002H\u000bH\u0002\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/hackle/android/internal/remoteconfig/HackleRemoteConfigImpl;", "Lio/hackle/sdk/common/HackleRemoteConfig;", "user", "Lio/hackle/sdk/common/User;", "core", "Lio/hackle/sdk/core/HackleCore;", "userManager", "Lio/hackle/android/internal/user/UserManager;", "(Lio/hackle/sdk/common/User;Lio/hackle/sdk/core/HackleCore;Lio/hackle/android/internal/user/UserManager;)V", "get", "Lio/hackle/sdk/common/decision/RemoteConfigDecision;", "T", "", "key", "", "requiredType", "Lio/hackle/sdk/core/model/ValueType;", "defaultValue", "(Ljava/lang/String;Lio/hackle/sdk/core/model/ValueType;Ljava/lang/Object;)Lio/hackle/sdk/common/decision/RemoteConfigDecision;", "getBoolean", "", "getDouble", "", "getInt", "", "getLong", "", "getString", "Companion", "hackle-android-sdk_release"})
public final class HackleRemoteConfigImpl
implements HackleRemoteConfig {
    private final User user;
    private final HackleCore core;
    private final UserManager userManager;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public String getString(@NotNull String key, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return (String)this.get(key, ValueType.STRING, defaultValue).getValue();
    }

    public int getInt(@NotNull String key, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ((Number)this.get(key, ValueType.NUMBER, defaultValue).getValue()).intValue();
    }

    public long getLong(@NotNull String key, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ((Number)this.get(key, ValueType.NUMBER, defaultValue).getValue()).longValue();
    }

    public double getDouble(@NotNull String key, double defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ((Number)this.get(key, ValueType.NUMBER, defaultValue).getValue()).doubleValue();
    }

    public boolean getBoolean(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Boolean)this.get(key, ValueType.BOOLEAN, defaultValue).getValue();
    }

    private final <T> RemoteConfigDecision<T> get(String key, ValueType requiredType, T defaultValue) {
        RemoteConfigDecision remoteConfigDecision;
        Timer.Sample sample = Timer.Companion.start$default((Timer.Companion)Timer.Companion, null, (int)1, null);
        try {
            HackleUser hackleUser = this.userManager.resolve(this.user);
            remoteConfigDecision = this.core.remoteConfig(key, hackleUser, requiredType, defaultValue);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(key){
                final /* synthetic */ String $key;

                @NotNull
                public final String invoke() {
                    return "Unexpected exception while deciding remote config parameter[" + this.$key + "]. Returning default value.";
                }
                {
                    this.$key = string2;
                    super(0);
                }
            });
            remoteConfigDecision = RemoteConfigDecision.Companion.of(defaultValue, DecisionReason.EXCEPTION);
        }
        boolean bl = false;
        boolean bl2 = false;
        RemoteConfigDecision it = remoteConfigDecision;
        boolean bl3 = false;
        DecisionMetrics.INSTANCE.remoteConfig(sample, key, it);
        return remoteConfigDecision;
    }

    public HackleRemoteConfigImpl(@Nullable User user, @NotNull HackleCore core, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        this.user = user;
        this.core = core;
        this.userManager = userManager;
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = HackleRemoteConfigImpl.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/hackle/android/internal/remoteconfig/HackleRemoteConfigImpl$Companion;", "", "()V", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

