/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.session;

import io.hackle.android.internal.session.Session;
import io.hackle.android.internal.session.SessionListener;
import io.hackle.android.internal.user.UserManager;
import io.hackle.sdk.common.Event;
import io.hackle.sdk.common.User;
import io.hackle.sdk.core.HackleCore;
import io.hackle.sdk.core.event.UserEvent;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import io.hackle.sdk.core.user.HackleUser;
import io.hackle.sdk.core.user.IdentifierType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/hackle/android/internal/session/SessionEventTracker;", "Lio/hackle/android/internal/session/SessionListener;", "userManager", "Lio/hackle/android/internal/user/UserManager;", "core", "Lio/hackle/sdk/core/HackleCore;", "(Lio/hackle/android/internal/user/UserManager;Lio/hackle/sdk/core/HackleCore;)V", "onSessionEnded", "", "session", "Lio/hackle/android/internal/session/Session;", "user", "Lio/hackle/sdk/common/User;", "timestamp", "", "onSessionStarted", "track", "eventKey", "", "Companion", "hackle-android-sdk_release"})
public final class SessionEventTracker
implements SessionListener {
    private final UserManager userManager;
    private final HackleCore core;
    private static final Logger log;
    private static final String SESSION_START_EVENT_NAME = "$session_start";
    private static final String SESSION_END_EVENT_NAME = "$session_end";
    public static final Companion Companion;

    @Override
    public void onSessionStarted(@NotNull Session session, @NotNull User user, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.track(SESSION_START_EVENT_NAME, session, user, timestamp);
    }

    @Override
    public void onSessionEnded(@NotNull Session session, @NotNull User user, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.track(SESSION_END_EVENT_NAME, session, user, timestamp);
    }

    private final void track(String eventKey, Session session, User user, long timestamp) {
        Event event = Event.Companion.of(eventKey);
        HackleUser hackleUser = this.userManager.toHackleUser(user).toBuilder().identifier(IdentifierType.SESSION, session.getId(), false).build();
        this.core.track(event, hackleUser, timestamp);
        log.debug((Function0)new Function0<String>(eventKey, session){
            final /* synthetic */ String $eventKey;
            final /* synthetic */ Session $session;

            @NotNull
            public final String invoke() {
                return this.$eventKey + " event tracked [" + this.$session.getId() + ']';
            }
            {
                this.$eventKey = string2;
                this.$session = session;
                super(0);
            }
        });
    }

    public SessionEventTracker(@NotNull UserManager userManager, @NotNull HackleCore core) {
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        this.userManager = userManager;
        this.core = core;
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = SessionEventTracker.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/hackle/android/internal/session/SessionEventTracker$Companion;", "", "()V", "SESSION_END_EVENT_NAME", "", "SESSION_START_EVENT_NAME", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "isSessionEvent", "", "event", "Lio/hackle/sdk/core/event/UserEvent;", "hackle-android-sdk_release"})
    public static final class Companion {
        public final boolean isSessionEvent(@NotNull UserEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            UserEvent userEvent = event;
            if (!(userEvent instanceof UserEvent.Track)) {
                userEvent = null;
            }
            UserEvent.Track track2 = (UserEvent.Track)userEvent;
            if (track2 == null) {
                return false;
            }
            UserEvent.Track trackEvent = track2;
            return Intrinsics.areEqual((Object)trackEvent.getEvent().getKey(), (Object)SessionEventTracker.SESSION_START_EVENT_NAME) || Intrinsics.areEqual((Object)trackEvent.getEvent().getKey(), (Object)SessionEventTracker.SESSION_END_EVENT_NAME);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

