/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.session;

import io.hackle.android.internal.database.repository.KeyValueRepository;
import io.hackle.android.internal.lifecycle.AppState;
import io.hackle.android.internal.lifecycle.AppStateChangeListener;
import io.hackle.android.internal.session.Session;
import io.hackle.android.internal.session.SessionListener;
import io.hackle.android.internal.session.SessionManager;
import io.hackle.android.internal.session.SessionManager$WhenMappings;
import io.hackle.android.internal.user.UserListener;
import io.hackle.android.internal.user.UserManager;
import io.hackle.sdk.common.User;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u0019J\b\u0010\u001f\u001a\u00020\u0019H\u0002J\b\u0010 \u001a\u00020\u0019H\u0002J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\bH\u0016J \u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u000bH\u0002J\u0016\u0010+\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\bJ\u0016\u0010,\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010-\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\bR\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/hackle/android/internal/session/SessionManager;", "Lio/hackle/android/internal/lifecycle/AppStateChangeListener;", "Lio/hackle/android/internal/user/UserListener;", "userManager", "Lio/hackle/android/internal/user/UserManager;", "keyValueRepository", "Lio/hackle/android/internal/database/repository/KeyValueRepository;", "sessionTimeoutMillis", "", "(Lio/hackle/android/internal/user/UserManager;Lio/hackle/android/internal/database/repository/KeyValueRepository;J)V", "<set-?>", "Lio/hackle/android/internal/session/Session;", "currentSession", "getCurrentSession", "()Lio/hackle/android/internal/session/Session;", "lastEventTime", "getLastEventTime", "()Ljava/lang/Long;", "Ljava/lang/Long;", "requiredSession", "getRequiredSession", "sessionListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lio/hackle/android/internal/session/SessionListener;", "addListener", "", "listener", "endSession", "user", "Lio/hackle/sdk/common/User;", "initialize", "loadLastEventTime", "loadSession", "newSession", "timestamp", "onChanged", "state", "Lio/hackle/android/internal/lifecycle/AppState;", "onUserUpdated", "oldUser", "newUser", "saveSession", "session", "startNewSession", "startNewSessionIfNeeded", "updateLastEventTime", "Companion", "hackle-android-sdk_release"})
public final class SessionManager
implements AppStateChangeListener,
UserListener {
    private final CopyOnWriteArrayList<SessionListener> sessionListeners;
    @Nullable
    private Session currentSession;
    @Nullable
    private Long lastEventTime;
    private final UserManager userManager;
    private final KeyValueRepository keyValueRepository;
    private final long sessionTimeoutMillis;
    private static final Logger log;
    private static final String SESSION_ID_KEY = "session_id";
    private static final String LAST_EVENT_TIME_KEY = "last_event_time";
    public static final Companion Companion;

    @NotNull
    public final Session getRequiredSession() {
        Session session = this.currentSession;
        if (session == null) {
            session = Session.Companion.getUNKNOWN();
        }
        return session;
    }

    @Nullable
    public final Session getCurrentSession() {
        return this.currentSession;
    }

    @Nullable
    public final Long getLastEventTime() {
        return this.lastEventTime;
    }

    public final void initialize() {
        this.loadSession();
        this.loadLastEventTime();
        log.debug((Function0)initialize.1.INSTANCE);
    }

    public final void addListener(@NotNull SessionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.sessionListeners.add(listener);
        log.debug((Function0)new Function0<String>(listener){
            final /* synthetic */ SessionListener $listener;

            @NotNull
            public final String invoke() {
                return "SessionListener added [" + this.$listener.getClass().getSimpleName() + ']';
            }
            {
                this.$listener = sessionListener;
                super(0);
            }
        });
    }

    @NotNull
    public final Session startNewSession(@NotNull User user, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.endSession(user);
        return this.newSession(user, timestamp);
    }

    @NotNull
    public final Session startNewSessionIfNeeded(@NotNull User user, long timestamp) {
        Session session;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Long l = this.lastEventTime;
        if (l == null) {
            return this.startNewSession(user, timestamp);
        }
        long lastEventTime = l;
        Session currentSession = this.currentSession;
        if (currentSession != null && timestamp - lastEventTime < this.sessionTimeoutMillis) {
            this.updateLastEventTime(timestamp);
            session = currentSession;
        } else {
            session = this.startNewSession(user, timestamp);
        }
        return session;
    }

    public final void updateLastEventTime(long timestamp) {
        this.lastEventTime = timestamp;
        this.keyValueRepository.putLong(LAST_EVENT_TIME_KEY, timestamp);
        log.debug((Function0)new Function0<String>(timestamp){
            final /* synthetic */ long $timestamp;

            @NotNull
            public final String invoke() {
                return "LastEventTime updated [" + this.$timestamp + ']';
            }
            {
                this.$timestamp = l;
                super(0);
            }
        });
    }

    private final void endSession(User user) {
        Session session = this.currentSession;
        if (session == null) {
            return;
        }
        Session currentSession = session;
        Long l = this.lastEventTime;
        if (l == null) {
            return;
        }
        long lastEventTime = l;
        for (SessionListener listener : this.sessionListeners) {
            listener.onSessionEnded(currentSession, user, lastEventTime);
        }
        log.debug((Function0)new Function0<String>(currentSession){
            final /* synthetic */ Session $currentSession;

            @NotNull
            public final String invoke() {
                return "Session ended [" + this.$currentSession.getId() + ']';
            }
            {
                this.$currentSession = session;
                super(0);
            }
        });
    }

    private final Session newSession(User user, long timestamp) {
        Session newSession2;
        this.currentSession = newSession2 = Session.Companion.create(timestamp);
        this.saveSession(newSession2);
        this.updateLastEventTime(timestamp);
        for (SessionListener listener : this.sessionListeners) {
            listener.onSessionStarted(newSession2, user, timestamp);
        }
        log.debug((Function0)new Function0<String>(newSession2){
            final /* synthetic */ Session $newSession;

            @NotNull
            public final String invoke() {
                return "Session started [" + this.$newSession.getId() + ']';
            }
            {
                this.$newSession = session;
                super(0);
            }
        });
        return newSession2;
    }

    private final void saveSession(Session session) {
        this.keyValueRepository.putString(SESSION_ID_KEY, session.getId());
        log.debug((Function0)new Function0<String>(session){
            final /* synthetic */ Session $session;

            @NotNull
            public final String invoke() {
                return "Session saved [" + this.$session.getId() + ']';
            }
            {
                this.$session = session;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void loadSession() {
        Session session;
        String sessionId = this.keyValueRepository.getString(SESSION_ID_KEY);
        SessionManager sessionManager = this;
        String string2 = sessionId;
        if (string2 != null) {
            void it;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = string3;
            SessionManager sessionManager2 = sessionManager;
            boolean bl3 = false;
            Session session2 = new Session((String)it);
            sessionManager = sessionManager2;
            session = session2;
        } else {
            session = null;
        }
        sessionManager.currentSession = session;
        log.debug((Function0)new Function0<String>(sessionId){
            final /* synthetic */ String $sessionId;

            @NotNull
            public final String invoke() {
                return "Session loaded [" + this.$sessionId + ']';
            }
            {
                this.$sessionId = string2;
                super(0);
            }
        });
    }

    private final void loadLastEventTime() {
        long lastEventTime = this.keyValueRepository.getLong(LAST_EVENT_TIME_KEY, -1L);
        if (lastEventTime > 0L) {
            this.lastEventTime = lastEventTime;
        }
        log.debug((Function0)new Function0<String>(this){
            final /* synthetic */ SessionManager this$0;

            @NotNull
            public final String invoke() {
                return "LastEventTime loaded [" + this.this$0.getLastEventTime() + ']';
            }
            {
                this.this$0 = sessionManager;
                super(0);
            }
        });
    }

    @Override
    public void onChanged(@NotNull AppState state, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        switch (SessionManager$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                this.startNewSessionIfNeeded(this.userManager.getCurrentUser(), timestamp);
                break;
            }
            case 2: {
                this.updateLastEventTime(timestamp);
                Session session = this.currentSession;
                if (session != null) {
                    Session session2 = session;
                    boolean bl = false;
                    boolean bl2 = false;
                    Session it = session2;
                    boolean bl3 = false;
                    this.saveSession(it);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void onUserUpdated(@NotNull User oldUser, @NotNull User newUser, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)oldUser, (String)"oldUser");
        Intrinsics.checkNotNullParameter((Object)newUser, (String)"newUser");
        this.endSession(oldUser);
        this.newSession(newUser, timestamp);
    }

    public SessionManager(@NotNull UserManager userManager, @NotNull KeyValueRepository keyValueRepository, long sessionTimeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)keyValueRepository, (String)"keyValueRepository");
        this.userManager = userManager;
        this.keyValueRepository = keyValueRepository;
        this.sessionTimeoutMillis = sessionTimeoutMillis;
        this.sessionListeners = new CopyOnWriteArrayList();
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = SessionManager.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    public static final /* synthetic */ Long access$getLastEventTime$p(SessionManager $this) {
        return $this.lastEventTime;
    }

    public static final /* synthetic */ void access$setLastEventTime$p(SessionManager $this, Long l) {
        $this.lastEventTime = l;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/hackle/android/internal/session/SessionManager$Companion;", "", "()V", "LAST_EVENT_TIME_KEY", "", "SESSION_ID_KEY", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

