/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.sync;

import io.hackle.android.internal.sync.CompositeSynchronizer;
import io.hackle.android.internal.sync.Synchronization;
import io.hackle.android.internal.sync.Synchronizer;
import io.hackle.android.internal.sync.SynchronizerType;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001J\b\u0010\r\u001a\u00020\tH\u0016J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/hackle/android/internal/sync/CompositeSynchronizer;", "Lio/hackle/android/internal/sync/Synchronizer;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Ljava/util/concurrent/ExecutorService;)V", "synchronizations", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lio/hackle/android/internal/sync/Synchronization;", "add", "", "type", "Lio/hackle/android/internal/sync/SynchronizerType;", "synchronizer", "sync", "toString", "", "Companion", "SyncJob", "hackle-android-sdk_release"})
public final class CompositeSynchronizer
implements Synchronizer {
    private final CopyOnWriteArrayList<Synchronization> synchronizations;
    private final ExecutorService executor;
    private static final Logger log;
    public static final Companion Companion;

    public final void add(@NotNull SynchronizerType type, @NotNull Synchronizer synchronizer) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        this.synchronizations.add(new Synchronization(type, synchronizer));
        log.debug((Function0)new Function0<String>(synchronizer){
            final /* synthetic */ Synchronizer $synchronizer;

            @NotNull
            public final String invoke() {
                return "Synchronizer added [" + this.$synchronizer.getClass().getSimpleName() + ']';
            }
            {
                this.$synchronizer = synchronizer;
                super(0);
            }
        });
    }

    @Override
    public void sync() {
        boolean bl = false;
        List jobs = new ArrayList();
        for (Synchronization synchronization : this.synchronizations) {
            try {
                Future<?> future2 = this.executor.submit(new Runnable(synchronization){
                    final /* synthetic */ Synchronization $synchronization;

                    public final void run() {
                        this.$synchronization.getSynchronizer().sync();
                    }
                    {
                        this.$synchronization = synchronization;
                    }
                });
                Synchronization synchronization2 = synchronization;
                Intrinsics.checkNotNullExpressionValue((Object)synchronization2, (String)"synchronization");
                Future<?> future3 = future2;
                Intrinsics.checkNotNullExpressionValue(future3, (String)"future");
                jobs.add(new SyncJob(synchronization2, future3));
            }
            catch (Exception e) {
                log.error((Function0)new Function0<String>(synchronization, e){
                    final /* synthetic */ Synchronization $synchronization;
                    final /* synthetic */ Exception $e;

                    @NotNull
                    public final String invoke() {
                        return "Failed to sync " + this.$synchronization + ": " + this.$e;
                    }
                    {
                        this.$synchronization = synchronization;
                        this.$e = exception;
                        super(0);
                    }
                });
            }
        }
        Iterable $this$forEach$iv = jobs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SyncJob it = (SyncJob)element$iv;
            boolean bl2 = false;
            it.await();
        }
    }

    public final void sync(@NotNull SynchronizerType type) {
        Object v0;
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Iterable iterable = this.synchronizations;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Synchronization it = (Synchronization)t;
                boolean bl3 = false;
                if (!(it.getType() == type)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Synchronization synchronization = v0;
        boolean bl4 = false;
        bl = false;
        if (synchronization == null) {
            boolean bl5 = false;
            String string2 = "Unsupported SynchronizerType [" + (Object)((Object)type) + ']';
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        synchronization.getSynchronizer().sync();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.synchronizations, (CharSequence)", ", (CharSequence)"CompositeSynchronizer(", (CharSequence)")", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
    }

    public CompositeSynchronizer(@NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        this.synchronizations = new CopyOnWriteArrayList();
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = CompositeSynchronizer.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bR\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/hackle/android/internal/sync/CompositeSynchronizer$SyncJob;", "", "synchronization", "Lio/hackle/android/internal/sync/Synchronization;", "future", "Ljava/util/concurrent/Future;", "(Lio/hackle/android/internal/sync/Synchronization;Ljava/util/concurrent/Future;)V", "await", "", "hackle-android-sdk_release"})
    public static final class SyncJob {
        private final Synchronization synchronization;
        private final Future<?> future;

        public final void await() {
            try {
                this.future.get();
            }
            catch (Exception e) {
                log.error((Function0)new Function0<String>(this, e){
                    final /* synthetic */ SyncJob this$0;
                    final /* synthetic */ Exception $e;

                    @NotNull
                    public final String invoke() {
                        return "Failed to sync " + SyncJob.access$getSynchronization$p(this.this$0).getSynchronizer() + ": " + this.$e;
                    }
                    {
                        this.this$0 = syncJob;
                        this.$e = exception;
                        super(0);
                    }
                });
            }
        }

        public SyncJob(@NotNull Synchronization synchronization, @NotNull Future<?> future2) {
            Intrinsics.checkNotNullParameter((Object)synchronization, (String)"synchronization");
            Intrinsics.checkNotNullParameter(future2, (String)"future");
            this.synchronization = synchronization;
            this.future = future2;
        }

        public static final /* synthetic */ Synchronization access$getSynchronization$p(SyncJob $this) {
            return $this.synchronization;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/hackle/android/internal/sync/CompositeSynchronizer$Companion;", "", "()V", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

