/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.sync;

import io.hackle.android.internal.lifecycle.AppState;
import io.hackle.android.internal.lifecycle.AppStateChangeListener;
import io.hackle.android.internal.sync.CompositeSynchronizer;
import io.hackle.android.internal.sync.PollingSynchronizer$WhenMappings;
import io.hackle.android.internal.sync.Synchronizer;
import io.hackle.android.internal.sync.SynchronizerType;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import io.hackle.sdk.core.internal.scheduler.ScheduledJob;
import io.hackle.sdk.core.internal.scheduler.Scheduler;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\rJ\b\u0010\u0013\u001a\u00020\rH\u0016J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/hackle/android/internal/sync/PollingSynchronizer;", "Lio/hackle/android/internal/sync/Synchronizer;", "Lio/hackle/android/internal/lifecycle/AppStateChangeListener;", "delegate", "Lio/hackle/android/internal/sync/CompositeSynchronizer;", "scheduler", "Lio/hackle/sdk/core/internal/scheduler/Scheduler;", "intervalMillis", "", "(Lio/hackle/android/internal/sync/CompositeSynchronizer;Lio/hackle/sdk/core/internal/scheduler/Scheduler;J)V", "pollingJob", "Lio/hackle/sdk/core/internal/scheduler/ScheduledJob;", "onChanged", "", "state", "Lio/hackle/android/internal/lifecycle/AppState;", "timestamp", "start", "stop", "sync", "type", "Lio/hackle/android/internal/sync/SynchronizerType;", "toString", "", "Companion", "hackle-android-sdk_release"})
public final class PollingSynchronizer
implements Synchronizer,
AppStateChangeListener {
    private ScheduledJob pollingJob;
    private final CompositeSynchronizer delegate;
    private final Scheduler scheduler;
    private final long intervalMillis;
    private static final Object LOCK;
    private static final Logger log;
    public static final Companion Companion;

    @Override
    public void sync() {
        try {
            this.delegate.sync();
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(this, e){
                final /* synthetic */ PollingSynchronizer this$0;
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to sync " + PollingSynchronizer.access$getDelegate$p(this.this$0) + ": " + this.$e;
                }
                {
                    this.this$0 = pollingSynchronizer;
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    public final void sync(@NotNull SynchronizerType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        try {
            this.delegate.sync(type);
        }
        catch (Exception e) {
            log.error((Function0)new Function0<String>(this, e){
                final /* synthetic */ PollingSynchronizer this$0;
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to sync " + PollingSynchronizer.access$getDelegate$p(this.this$0) + ": " + this.$e;
                }
                {
                    this.this$0 = pollingSynchronizer;
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        if (this.intervalMillis == (long)-1) {
            return;
        }
        Object object = LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.pollingJob != null) {
                return;
            }
            this.pollingJob = this.scheduler.schedulePeriodically(this.intervalMillis, this.intervalMillis, TimeUnit.MILLISECONDS, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PollingSynchronizer this$0;
                {
                    this.this$0 = pollingSynchronizer;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.sync();
                }
            });
            log.info((Function0)new Function0<String>(this){
                final /* synthetic */ PollingSynchronizer this$0;
                {
                    this.this$0 = pollingSynchronizer;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.this$0 + " started polling. Poll every " + PollingSynchronizer.access$getIntervalMillis$p(this.this$0) + "ms.";
                }
            });
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (this.intervalMillis == (long)-1) {
            return;
        }
        Object object = LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            ScheduledJob scheduledJob = this.pollingJob;
            if (scheduledJob != null) {
                scheduledJob.cancel();
            }
            this.pollingJob = null;
            log.info((Function0)new Function0<String>(this){
                final /* synthetic */ PollingSynchronizer this$0;
                {
                    this.this$0 = pollingSynchronizer;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.this$0 + " stopped polling.";
                }
            });
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void onChanged(@NotNull AppState state, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        switch (PollingSynchronizer$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                this.start();
                break;
            }
            case 2: {
                this.stop();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public String toString() {
        return "PollingSynchronizer(" + this.delegate + ", " + this.intervalMillis + "ms)";
    }

    public PollingSynchronizer(@NotNull CompositeSynchronizer delegate, @NotNull Scheduler scheduler, long intervalMillis) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        this.delegate = delegate;
        this.scheduler = scheduler;
        this.intervalMillis = intervalMillis;
    }

    static {
        Companion = new Companion(null);
        LOCK = new Object();
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = PollingSynchronizer.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    public static final /* synthetic */ CompositeSynchronizer access$getDelegate$p(PollingSynchronizer $this) {
        return $this.delegate;
    }

    public static final /* synthetic */ long access$getIntervalMillis$p(PollingSynchronizer $this) {
        return $this.intervalMillis;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/hackle/android/internal/sync/PollingSynchronizer$Companion;", "", "()V", "LOCK", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

