/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.user;

import io.hackle.android.internal.model.Device;
import io.hackle.android.internal.user.UserCohort;
import io.hackle.android.internal.user.UserCohorts;
import io.hackle.sdk.common.User;
import io.hackle.sdk.core.model.Cohort;
import io.hackle.sdk.core.model.Identifier;
import io.hackle.sdk.core.model.Identifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\u0016\u0010\b\u001a\u00020\t*\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\u0016\u0010\u000b\u001a\u00020\u0002*\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u0006H\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0012"}, d2={"resolvedIdentifiers", "Lio/hackle/sdk/core/model/Identifiers;", "Lio/hackle/sdk/common/User;", "getResolvedIdentifiers", "(Lio/hackle/sdk/common/User;)Lio/hackle/sdk/core/model/Identifiers;", "filterBy", "Lio/hackle/android/internal/user/UserCohorts;", "user", "identifierEquals", "", "other", "mergeWith", "rawCohorts", "", "Lio/hackle/sdk/core/model/Cohort;", "with", "device", "Lio/hackle/android/internal/model/Device;", "hackle-android-sdk_release"})
public final class UserExtensionsKt {
    public static final boolean identifierEquals(@NotNull User $this$identifierEquals, @Nullable User other) {
        Intrinsics.checkNotNullParameter((Object)$this$identifierEquals, (String)"$this$identifierEquals");
        if (other == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)$this$identifierEquals.getUserId(), (Object)other.getUserId()) && Intrinsics.areEqual((Object)$this$identifierEquals.getDeviceId(), (Object)other.getDeviceId());
    }

    @NotNull
    public static final User mergeWith(@NotNull User $this$mergeWith, @Nullable User other) {
        Intrinsics.checkNotNullParameter((Object)$this$mergeWith, (String)"$this$mergeWith");
        return other == null ? $this$mergeWith : (UserExtensionsKt.identifierEquals($this$mergeWith, other) ? User.copy$default((User)$this$mergeWith, null, null, null, null, (Map)MapsKt.plus((Map)other.getProperties(), (Map)$this$mergeWith.getProperties()), null, (int)47, null) : $this$mergeWith);
    }

    @NotNull
    public static final User with(@NotNull User $this$with, @NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$this$with");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        User.Builder builder = $this$with.toBuilder();
        if ($this$with.getId() == null) {
            builder.id(device.getId());
        }
        if ($this$with.getDeviceId() == null) {
            builder.deviceId(device.getId());
        }
        return builder.build();
    }

    @NotNull
    public static final Identifiers getResolvedIdentifiers(@NotNull User $this$resolvedIdentifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvedIdentifiers, (String)"$this$resolvedIdentifiers");
        return Identifiers.Companion.from($this$resolvedIdentifiers);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final UserCohorts filterBy(@NotNull UserCohorts $this$filterBy, @NotNull User user) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$filterBy, (String)"$this$filterBy");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Identifiers identifiers = UserExtensionsKt.getResolvedIdentifiers(user);
        Map<Identifier, UserCohort> $this$filter$iv = $this$filterBy.asMap();
        boolean $i$f$filter = false;
        Map<Identifier, UserCohort> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var9_8 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_8.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!identifiers.contains((Identifier)it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map filtered = destination$iv$iv;
        return UserCohorts.Companion.from(filtered);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cohort> rawCohorts(@NotNull UserCohorts $this$rawCohorts) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$rawCohorts, (String)"$this$rawCohorts");
        Iterable $this$flatMap$iv = $this$rawCohorts.asList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            UserCohort it = (UserCohort)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getCohorts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

