/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.internal.workspace;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.hackle.android.internal.http.HttpKt;
import io.hackle.android.internal.model.Sdk;
import io.hackle.android.internal.monitoring.metric.ApiCallMetrics;
import io.hackle.android.internal.utils.JsonKt;
import io.hackle.android.internal.workspace.WorkspaceConfigDto;
import io.hackle.android.internal.workspace.WorkspaceImpl;
import io.hackle.sdk.core.internal.metrics.Timer;
import io.hackle.sdk.core.workspace.Workspace;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/hackle/android/internal/workspace/HttpWorkspaceFetcher;", "", "sdk", "Lio/hackle/android/internal/model/Sdk;", "sdkUri", "", "httpClient", "Lokhttp3/OkHttpClient;", "(Lio/hackle/android/internal/model/Sdk;Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "lastModified", "url", "Lokhttp3/HttpUrl;", "kotlin.jvm.PlatformType", "createRequest", "Lokhttp3/Request;", "execute", "Lokhttp3/Response;", "request", "fetchIfModified", "Lio/hackle/sdk/core/workspace/Workspace;", "handleResponse", "response", "Companion", "hackle-android-sdk_release"})
public final class HttpWorkspaceFetcher {
    private final HttpUrl url;
    private String lastModified;
    private final OkHttpClient httpClient;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Workspace fetchIfModified() {
        Workspace workspace;
        Request request = this.createRequest();
        Response response = this.execute(request);
        Closeable closeable = (Closeable)response;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl3 = false;
            workspace = this.handleResponse(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return workspace;
    }

    private final Request createRequest() {
        Request.Builder builder = new Request.Builder().url(this.url);
        boolean bl = false;
        boolean bl2 = false;
        Request.Builder $this$apply = builder;
        boolean bl3 = false;
        String string2 = this.lastModified;
        if (string2 != null) {
            String string3 = string2;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string3;
            boolean bl6 = false;
            $this$apply.header("If-Modified-Since", it);
        }
        Request request = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"Request.Builder()\n      \u2026 } }\n            .build()");
        return request;
    }

    /*
     * WARNING - void declaration
     */
    private final Response execute(Request request) {
        Response response;
        ApiCallMetrics apiCallMetrics = ApiCallMetrics.INSTANCE;
        String operation$iv = "get.workspace";
        boolean $i$f$record = false;
        Timer.Sample sample$iv = Timer.Companion.start$default((Timer.Companion)Timer.Companion, null, (int)1, null);
        try {
            boolean bl = false;
            Response response2 = this.httpClient.newCall(request).execute();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"httpClient.newCall(request).execute()");
            response = response2;
            boolean bl2 = false;
            boolean bl3 = false;
            Response it$iv = response;
            boolean bl4 = false;
            ApiCallMetrics.INSTANCE.record(operation$iv, sample$iv, it$iv);
        }
        catch (Exception e$iv) {
            void this_$iv;
            this_$iv.record(operation$iv, sample$iv, null);
            throw (Throwable)e$iv;
        }
        return response;
    }

    private final Workspace handleResponse(Response response) {
        ResponseBody responseBody;
        if (HttpKt.isNotModified(response)) {
            return null;
        }
        boolean bl = response.isSuccessful();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl42 = false;
            String string2 = "Http status code: " + response.code();
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.lastModified = response.header("Last-Modified");
        ResponseBody responseBody2 = response.body();
        bl3 = false;
        boolean bl42 = false;
        if (responseBody2 == null) {
            boolean bl5 = false;
            String bl42 = "Response body is null";
            throw (Throwable)new IllegalStateException(bl42.toString());
        }
        ResponseBody $this$parse$iv = responseBody = responseBody2;
        boolean $i$f$parse = false;
        String string3 = $this$parse$iv.string();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"string()");
        String $this$parseJson$iv$iv = string3;
        boolean $i$f$parseJson = false;
        Gson $this$fromJson$iv$iv$iv = JsonKt.access$getGSON$p();
        boolean $i$f$fromJson = false;
        boolean $i$f$gsonTypeRef = false;
        WorkspaceConfigDto dto = (WorkspaceConfigDto)$this$fromJson$iv$iv$iv.fromJson($this$parseJson$iv$iv, ((TypeToken)new TypeToken<WorkspaceConfigDto>(){}).getType());
        return WorkspaceImpl.Companion.from(dto);
    }

    public HttpWorkspaceFetcher(@NotNull Sdk sdk, @NotNull String sdkUri, @NotNull OkHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)sdkUri, (String)"sdkUri");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.httpClient = httpClient;
        this.url = HttpUrl.get((String)HttpWorkspaceFetcher.Companion.url(sdk, sdkUri));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lio/hackle/android/internal/workspace/HttpWorkspaceFetcher$Companion;", "", "()V", "url", "", "sdk", "Lio/hackle/android/internal/model/Sdk;", "sdkUri", "hackle-android-sdk_release"})
    public static final class Companion {
        private final String url(Sdk sdk, String sdkUri) {
            return sdkUri + "/api/v2/workspaces/" + sdk.getKey() + "/config";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

