/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.ui.explorer.base;

import io.hackle.android.internal.notification.NotificationManager;
import io.hackle.android.internal.user.UserManager;
import io.hackle.android.ui.explorer.storage.HackleUserManualOverrideStorage;
import io.hackle.sdk.common.decision.Decision;
import io.hackle.sdk.common.decision.FeatureFlagDecision;
import io.hackle.sdk.core.HackleCore;
import io.hackle.sdk.core.internal.metrics.Metrics;
import io.hackle.sdk.core.model.Experiment;
import io.hackle.sdk.core.user.HackleUser;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fJ\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014J\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00170\u00100\u000fJ\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0011J\u0006\u0010\"\u001a\u00020\u001aJ\u0006\u0010#\u001a\u00020\u001aJ\u000e\u0010$\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0011J\u0016\u0010%\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0015J\u0016\u0010'\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/hackle/android/ui/explorer/base/HackleUserExplorerService;", "", "core", "Lio/hackle/sdk/core/HackleCore;", "userManager", "Lio/hackle/android/internal/user/UserManager;", "abTestOverrideStorage", "Lio/hackle/android/ui/explorer/storage/HackleUserManualOverrideStorage;", "featureFlagOverrideStorage", "notificationManager", "Lio/hackle/android/internal/notification/NotificationManager;", "(Lio/hackle/sdk/core/HackleCore;Lio/hackle/android/internal/user/UserManager;Lio/hackle/android/ui/explorer/storage/HackleUserManualOverrideStorage;Lio/hackle/android/ui/explorer/storage/HackleUserManualOverrideStorage;Lio/hackle/android/internal/notification/NotificationManager;)V", "currentUser", "Lio/hackle/sdk/core/user/HackleUser;", "getAbTestDecisions", "", "Lkotlin/Pair;", "Lio/hackle/sdk/core/model/Experiment;", "Lio/hackle/sdk/common/decision/Decision;", "getAbTestOverrides", "", "", "getFeatureFlagDecisions", "Lio/hackle/sdk/common/decision/FeatureFlagDecision;", "getFeatureFlagOverrides", "increment", "", "experimentType", "Lio/hackle/sdk/core/model/Experiment$Type;", "operation", "", "registeredPushToken", "resetAbTestOverride", "experiment", "resetAllAbTestOverride", "resetAllFeatureFlagOverride", "resetFeatureFlagOverride", "setAbTestOverride", "variationId", "setFeatureFlagOverride", "hackle-android-sdk_release"})
public final class HackleUserExplorerService {
    private final HackleCore core;
    private final UserManager userManager;
    private final HackleUserManualOverrideStorage abTestOverrideStorage;
    private final HackleUserManualOverrideStorage featureFlagOverrideStorage;
    private final NotificationManager notificationManager;

    @NotNull
    public final HackleUser currentUser() {
        return this.userManager.resolve(null);
    }

    @Nullable
    public final String registeredPushToken() {
        return this.notificationManager.getRegisteredPushToken();
    }

    @NotNull
    public final List<Pair<Experiment, Decision>> getAbTestDecisions() {
        return MapsKt.toList((Map)this.core.experiments(this.currentUser()));
    }

    @NotNull
    public final Map<Long, Long> getAbTestOverrides() {
        return this.abTestOverrideStorage.getAll();
    }

    public final void setAbTestOverride(@NotNull Experiment experiment, long variationId) {
        Intrinsics.checkNotNullParameter((Object)experiment, (String)"experiment");
        this.abTestOverrideStorage.set(experiment, variationId);
        this.increment(Experiment.Type.AB_TEST, "set");
    }

    public final void resetAbTestOverride(@NotNull Experiment experiment) {
        Intrinsics.checkNotNullParameter((Object)experiment, (String)"experiment");
        this.abTestOverrideStorage.remove(experiment);
        this.increment(Experiment.Type.AB_TEST, "reset");
    }

    public final void resetAllAbTestOverride() {
        this.abTestOverrideStorage.clear();
        this.increment(Experiment.Type.AB_TEST, "reset.all");
    }

    @NotNull
    public final List<Pair<Experiment, FeatureFlagDecision>> getFeatureFlagDecisions() {
        return MapsKt.toList((Map)this.core.featureFlags(this.currentUser()));
    }

    @NotNull
    public final Map<Long, Long> getFeatureFlagOverrides() {
        return this.featureFlagOverrideStorage.getAll();
    }

    public final void setFeatureFlagOverride(@NotNull Experiment experiment, long variationId) {
        Intrinsics.checkNotNullParameter((Object)experiment, (String)"experiment");
        this.featureFlagOverrideStorage.set(experiment, variationId);
        this.increment(Experiment.Type.FEATURE_FLAG, "set");
    }

    public final void resetFeatureFlagOverride(@NotNull Experiment experiment) {
        Intrinsics.checkNotNullParameter((Object)experiment, (String)"experiment");
        this.featureFlagOverrideStorage.remove(experiment);
        this.increment(Experiment.Type.FEATURE_FLAG, "reset");
    }

    public final void resetAllFeatureFlagOverride() {
        this.featureFlagOverrideStorage.clear();
        this.increment(Experiment.Type.FEATURE_FLAG, "reset.all");
    }

    private final void increment(Experiment.Type experimentType, String operation) {
        Map tags = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"experiment.type", (Object)experimentType.name()), TuplesKt.to((Object)"operation", (Object)operation)});
        Metrics.INSTANCE.counter("experiment.manual.override", tags).increment();
    }

    public HackleUserExplorerService(@NotNull HackleCore core, @NotNull UserManager userManager, @NotNull HackleUserManualOverrideStorage abTestOverrideStorage, @NotNull HackleUserManualOverrideStorage featureFlagOverrideStorage, @NotNull NotificationManager notificationManager) {
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)abTestOverrideStorage, (String)"abTestOverrideStorage");
        Intrinsics.checkNotNullParameter((Object)featureFlagOverrideStorage, (String)"featureFlagOverrideStorage");
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        this.core = core;
        this.userManager = userManager;
        this.abTestOverrideStorage = abTestOverrideStorage;
        this.featureFlagOverrideStorage = featureFlagOverrideStorage;
        this.notificationManager = notificationManager;
    }
}

