/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.ui.explorer.view.button;

import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import io.hackle.android.R;
import io.hackle.android.ui.explorer.activity.HackleUserExplorerActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/hackle/android/ui/explorer/view/button/HackleUserExplorerButton;", "Landroid/widget/FrameLayout;", "Landroid/view/View$OnTouchListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "initialTouchX", "", "initialTouchY", "initialX", "initialY", "logo", "Landroid/widget/ImageView;", "initLayout", "", "isClick", "", "startX", "endX", "startY", "endY", "onTouch", "v", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "hackle-android-sdk_release"})
public final class HackleUserExplorerButton
extends FrameLayout
implements View.OnTouchListener {
    private final ImageView logo;
    private float initialX;
    private float initialTouchX;
    private float initialY;
    private float initialTouchY;

    private final void initLayout() {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 0x800055;
        params.setMargins(0, 0, 24, 24);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.requestLayout();
    }

    public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        switch (event.getAction()) {
            case 0: {
                this.initialX = v.getX();
                this.initialY = v.getY();
                this.initialTouchX = event.getRawX();
                this.initialTouchY = event.getRawY();
                bl = true;
                break;
            }
            case 2: {
                v.setX(this.initialX + (event.getRawX() - this.initialTouchX));
                v.setY(this.initialY + (event.getRawY() - this.initialTouchY));
                bl = true;
                break;
            }
            case 1: {
                if (this.isClick(this.initialTouchX, event.getRawX(), this.initialTouchY, event.getRawY())) {
                    v.performClick();
                    Intent intent = new Intent(v.getContext(), HackleUserExplorerActivity.class);
                    v.getContext().startActivity(intent);
                }
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isClick(float startX, float endX, float startY, float endY) {
        float f = startX - endX;
        boolean bl = false;
        float differenceX = Math.abs(f);
        float f2 = startY - endY;
        boolean bl2 = false;
        float differenceY = Math.abs(f2);
        return !(differenceX > (float)10) && !(differenceY > (float)10);
    }

    public HackleUserExplorerButton(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        View root = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.hackle_view_user_explorer_button, (ViewGroup)this, true);
        View view = root.findViewById(R.id.hackle_image_view_logo);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"root.findViewById(R.id.hackle_image_view_logo)");
        this.logo = (ImageView)view;
        this.initLayout();
        this.setOnTouchListener(this);
    }

    public HackleUserExplorerButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        View root = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.hackle_view_user_explorer_button, (ViewGroup)this, true);
        View view = root.findViewById(R.id.hackle_image_view_logo);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"root.findViewById(R.id.hackle_image_view_logo)");
        this.logo = (ImageView)view;
        this.initLayout();
        this.setOnTouchListener(this);
    }
}

