/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.ui.inappmessage;

import android.app.Activity;
import io.hackle.android.internal.inappmessage.presentation.InAppMessagePresentationContext;
import io.hackle.android.internal.inappmessage.presentation.InAppMessagePresenter;
import io.hackle.android.internal.lifecycle.ActivityProvider;
import io.hackle.android.internal.task.TaskExecutors;
import io.hackle.android.ui.inappmessage.InAppMessageExtensionsKt;
import io.hackle.android.ui.inappmessage.event.InAppMessageEventHandler;
import io.hackle.android.ui.inappmessage.view.InAppMessageView;
import io.hackle.android.ui.inappmessage.view.InAppMessageViewFactory;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import io.hackle.sdk.core.model.InAppMessage;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/hackle/android/ui/inappmessage/InAppMessageUi;", "Lio/hackle/android/internal/inappmessage/presentation/InAppMessagePresenter;", "activityProvider", "Lio/hackle/android/internal/lifecycle/ActivityProvider;", "messageViewFactory", "Lio/hackle/android/ui/inappmessage/view/InAppMessageViewFactory;", "eventHandler", "Lio/hackle/android/ui/inappmessage/event/InAppMessageEventHandler;", "(Lio/hackle/android/internal/lifecycle/ActivityProvider;Lio/hackle/android/ui/inappmessage/view/InAppMessageViewFactory;Lio/hackle/android/ui/inappmessage/event/InAppMessageEventHandler;)V", "<set-?>", "Lio/hackle/android/ui/inappmessage/view/InAppMessageView;", "currentMessageView", "getCurrentMessageView", "()Lio/hackle/android/ui/inappmessage/view/InAppMessageView;", "getEventHandler", "()Lio/hackle/android/ui/inappmessage/event/InAppMessageEventHandler;", "opening", "Ljava/util/concurrent/atomic/AtomicBoolean;", "closeCurrent", "", "isSupportedOrientation", "", "activity", "Landroid/app/Activity;", "context", "Lio/hackle/android/internal/inappmessage/presentation/InAppMessagePresentationContext;", "present", "presentNow", "Companion", "hackle-android-sdk_release"})
public final class InAppMessageUi
implements InAppMessagePresenter {
    @Nullable
    private InAppMessageView currentMessageView;
    private final AtomicBoolean opening;
    private final ActivityProvider activityProvider;
    private final InAppMessageViewFactory messageViewFactory;
    @NotNull
    private final InAppMessageEventHandler eventHandler;
    private static final Logger log;
    private static InAppMessageUi INSTANCE;
    public static final Companion Companion;

    @Nullable
    public final InAppMessageView getCurrentMessageView() {
        return this.currentMessageView;
    }

    @Override
    public void present(@NotNull InAppMessagePresentationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TaskExecutors.INSTANCE.runOnUiThread((Function0<Unit>)((Function0)new Function0<Unit>(this, context){
            final /* synthetic */ InAppMessageUi this$0;
            final /* synthetic */ InAppMessagePresentationContext $context;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                if (!InAppMessageUi.access$getOpening$p(this.this$0).compareAndSet(false, true)) {
                    return;
                }
                try {
                    InAppMessageUi.access$presentNow(this.this$0, this.$context);
                }
                finally {
                    InAppMessageUi.access$getOpening$p(this.this$0).set(false);
                }
            }
            {
                this.this$0 = inAppMessageUi;
                this.$context = inAppMessagePresentationContext;
                super(0);
            }
        }));
    }

    private final void presentNow(InAppMessagePresentationContext context) {
        block5: {
            Activity activity = this.activityProvider.getCurrentActivity();
            if (activity == null) {
                return;
            }
            Activity activity2 = activity;
            if (this.currentMessageView != null) {
                return;
            }
            if (!this.isSupportedOrientation(activity2, context)) {
                return;
            }
            InAppMessageView messageView = null;
            try {
                this.currentMessageView = messageView = this.messageViewFactory.create(context, this);
                messageView.open(activity2);
            }
            catch (Throwable e) {
                log.error((Function0)new Function0<String>(e){
                    final /* synthetic */ Throwable $e;

                    @NotNull
                    public final String invoke() {
                        return "Failed to present InAppMessage: " + this.$e;
                    }
                    {
                        this.$e = throwable;
                        super(0);
                    }
                });
                InAppMessageView inAppMessageView = messageView;
                if (inAppMessageView == null) break block5;
                inAppMessageView.close();
            }
        }
    }

    private final boolean isSupportedOrientation(Activity activity, InAppMessagePresentationContext context) {
        InAppMessage.Orientation orientation = InAppMessageExtensionsKt.getOrientation(activity);
        if (orientation == null) {
            return false;
        }
        InAppMessage.Orientation orientation2 = orientation;
        return InAppMessageExtensionsKt.supports(context.getInAppMessage(), orientation2);
    }

    public final void closeCurrent() {
        this.currentMessageView = null;
    }

    @NotNull
    public final InAppMessageEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public InAppMessageUi(@NotNull ActivityProvider activityProvider, @NotNull InAppMessageViewFactory messageViewFactory, @NotNull InAppMessageEventHandler eventHandler) {
        Intrinsics.checkNotNullParameter((Object)activityProvider, (String)"activityProvider");
        Intrinsics.checkNotNullParameter((Object)messageViewFactory, (String)"messageViewFactory");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        this.activityProvider = activityProvider;
        this.messageViewFactory = messageViewFactory;
        this.eventHandler = eventHandler;
        this.opening = new AtomicBoolean(false);
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = InAppMessageUi.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    public static final /* synthetic */ AtomicBoolean access$getOpening$p(InAppMessageUi $this) {
        return $this.opening;
    }

    public static final /* synthetic */ void access$presentNow(InAppMessageUi $this, InAppMessagePresentationContext context) {
        $this.presentNow(context);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/hackle/android/ui/inappmessage/InAppMessageUi$Companion;", "", "()V", "INSTANCE", "Lio/hackle/android/ui/inappmessage/InAppMessageUi;", "instance", "getInstance", "()Lio/hackle/android/ui/inappmessage/InAppMessageUi;", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "create", "activityProvider", "Lio/hackle/android/internal/lifecycle/ActivityProvider;", "messageViewFactory", "Lio/hackle/android/ui/inappmessage/view/InAppMessageViewFactory;", "eventHandler", "Lio/hackle/android/ui/inappmessage/event/InAppMessageEventHandler;", "hackle-android-sdk_release"})
    public static final class Companion {
        @NotNull
        public final InAppMessageUi create(@NotNull ActivityProvider activityProvider, @NotNull InAppMessageViewFactory messageViewFactory, @NotNull InAppMessageEventHandler eventHandler) {
            Intrinsics.checkNotNullParameter((Object)activityProvider, (String)"activityProvider");
            Intrinsics.checkNotNullParameter((Object)messageViewFactory, (String)"messageViewFactory");
            Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
            InAppMessageUi inAppMessageUi = INSTANCE;
            if (inAppMessageUi == null) {
                InAppMessageUi inAppMessageUi2 = new InAppMessageUi(activityProvider, messageViewFactory, eventHandler);
                boolean bl = false;
                boolean bl2 = false;
                InAppMessageUi it = inAppMessageUi2;
                boolean bl3 = false;
                INSTANCE = it;
                inAppMessageUi = inAppMessageUi2;
            }
            return inAppMessageUi;
        }

        @NotNull
        public final InAppMessageUi getInstance() {
            InAppMessageUi inAppMessageUi = INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            if (inAppMessageUi == null) {
                boolean bl3 = false;
                String string2 = "InAppMessageUi not initialized";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            return inAppMessageUi;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

