/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.ui.inappmessage.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import io.hackle.android.ui.inappmessage.view.InAppMessageImageView;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0014J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/hackle/android/ui/inappmessage/view/InAppMessageImageView;", "Landroid/widget/ImageView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "aspectRatio", "", "path", "Landroid/graphics/Path;", "radii", "", "radius", "rect", "Landroid/graphics/RectF;", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setAspectRatio", "Companion", "hackle-android-sdk_release"})
public final class InAppMessageImageView
extends ImageView {
    private Path path;
    private RectF rect;
    private float radius;
    private float[] radii;
    private float aspectRatio;
    private static final Logger log;
    public static final Companion Companion;

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)0x40000000);
        super.onMeasure(widthSpec, heightMeasureSpec);
        int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.aspectRatio != -1.0f && this.getMeasuredHeight() > 0 && this.getMeasuredWidth() > 0) {
            int newWidth = this.getMeasuredWidth();
            int n = (int)((float)newWidth / this.aspectRatio);
            int n2 = (int)((double)parentHeight * 0.8);
            boolean bl = false;
            int maxHeight = Math.min(n, n2) + 1;
            newWidth = (int)((float)maxHeight * this.aspectRatio);
            n2 = this.getMeasuredHeight();
            bl = false;
            int newHeight = Math.min(n2, maxHeight);
            this.setMeasuredDimension(newWidth, newHeight);
        } else {
            this.setMeasuredDimension(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    protected void onDraw(@Nullable Canvas canvas) {
        try {
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                Canvas canvas3 = canvas2;
                boolean bl = false;
                boolean bl2 = false;
                Canvas it = canvas3;
                boolean bl3 = false;
                this.rect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
                this.path.reset();
                this.path.addRoundRect(this.rect, this.radii, Path.Direction.CW);
                it.clipPath(this.path);
                super.onDraw(it);
            }
        }
        catch (Exception e) {
            log.error((Function0)onDraw.2.INSTANCE);
        }
    }

    public final void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
        this.requestLayout();
    }

    public InAppMessageImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.path = new Path();
        this.rect = new RectF();
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        Resources resources = context2.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        this.radius = 8.0f * resources.getDisplayMetrics().density;
        this.radii = new float[]{this.radius, this.radius, this.radius, this.radius, 0.0f, 0.0f, 0.0f, 0.0f};
        this.aspectRatio = -1.0f;
    }

    public InAppMessageImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.path = new Path();
        this.rect = new RectF();
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        Resources resources = context2.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        this.radius = 8.0f * resources.getDisplayMetrics().density;
        this.radii = new float[]{this.radius, this.radius, this.radius, this.radius, 0.0f, 0.0f, 0.0f, 0.0f};
        this.aspectRatio = -1.0f;
    }

    public InAppMessageImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.path = new Path();
        this.rect = new RectF();
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        Resources resources = context2.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        this.radius = 8.0f * resources.getDisplayMetrics().density;
        this.radii = new float[]{this.radius, this.radius, this.radius, this.radius, 0.0f, 0.0f, 0.0f, 0.0f};
        this.aspectRatio = -1.0f;
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = InAppMessageImageView.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/hackle/android/ui/inappmessage/view/InAppMessageImageView$Companion;", "", "()V", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

