/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.ui.inappmessage.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import io.hackle.android.R;
import io.hackle.android.ui.inappmessage.view.InAppMessageImageView;
import io.hackle.sdk.core.model.InAppMessage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0017"}, d2={"Lio/hackle/android/ui/inappmessage/view/InAppMessageModalFrame;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "onMeasure", "", "widthMeasureSpec", "", "heightMeasureSpec", "resize", "width", "height", "setImageViewStyle", "message", "Lio/hackle/sdk/core/model/InAppMessage$Message;", "inAppMessageImageView", "Lio/hackle/android/ui/inappmessage/view/InAppMessageImageView;", "setModalFrameStyle", "Companion", "hackle-android-sdk_release"})
public final class InAppMessageModalFrame
extends RelativeLayout {
    private static final float NO_TEXT_IMAGE_VIEW_ASPECT_RATIO = 0.6666667f;
    private static final float TEXT_IMAGE_VIEW_ASPECT_RATIO = 2.9f;
    public static final Companion Companion = new Companion(null);

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minWidth = this.getResources().getDimensionPixelSize(R.dimen.io_hackle_inappmessage_modal_min_width);
        int maxWidth = this.getResources().getDimensionPixelSize(R.dimen.io_hackle_inappmessage_modal_max_width);
        int maxHeight = this.getResources().getDimensionPixelSize(R.dimen.io_hackle_inappmessage_modal_max_height);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int n = this.getMeasuredHeight();
        boolean bl = false;
        int newMaxHeight = Math.min(maxHeight, n);
        if (this.getMeasuredWidth() < minWidth) {
            this.setMeasuredDimension(minWidth, this.getMeasuredHeight());
        } else if (this.getMeasuredWidth() > maxWidth) {
            this.resize(maxWidth, newMaxHeight);
        } else {
            this.resize(this.getMeasuredWidth(), newMaxHeight);
        }
    }

    private final void resize(int width, int height) {
        View view = this.getChildAt(0);
        if (view instanceof ImageView) {
            if (((ImageView)view).getDrawable() != null) {
                int imageWidth = ((ImageView)view).getMeasuredWidth();
                boolean bl = false;
                int newWidth = Math.min(imageWidth, width);
                this.setMeasuredDimension(newWidth, height);
            } else {
                this.setMeasuredDimension(width, height);
            }
        }
    }

    public final void setModalFrameStyle(@NotNull InAppMessage.Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(0);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        int dpi = resources.getDisplayMetrics().densityDpi;
        gradientDrawable.setCornerRadius((float)(8 * dpi / 160));
        gradientDrawable.setColor(Color.parseColor((String)message.getBackground().getColor()));
        this.setBackground((Drawable)gradientDrawable);
    }

    public final void setImageViewStyle(@NotNull InAppMessage.Message message, @NotNull InAppMessageImageView inAppMessageImageView) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)inAppMessageImageView), (String)"inAppMessageImageView");
        if (message.getText() != null) {
            inAppMessageImageView.setAspectRatio(2.9f);
        } else {
            inAppMessageImageView.setAspectRatio(0.6666667f);
        }
    }

    public InAppMessageModalFrame(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public InAppMessageModalFrame(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/hackle/android/ui/inappmessage/view/InAppMessageModalFrame$Companion;", "", "()V", "NO_TEXT_IMAGE_VIEW_ASPECT_RATIO", "", "TEXT_IMAGE_VIEW_ASPECT_RATIO", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

