/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.ui.notification;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.core.app.NotificationManagerCompat;
import io.hackle.android.internal.task.TaskExecutors;
import io.hackle.android.ui.notification.NotificationBroadcastReceiver;
import io.hackle.android.ui.notification.NotificationData;
import io.hackle.android.ui.notification.NotificationFactory;
import io.hackle.android.ui.notification.NotificationHandler;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\r"}, d2={"Lio/hackle/android/ui/notification/NotificationBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "displayNotification", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "isAppInForeground", "onReceive", "", "Companion", "hackle-android-sdk_release"})
public final class NotificationBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "hackle_notification";
    private static final Logger log;
    public static final Companion Companion;

    public void onReceive(@NotNull Context context, @Nullable Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (intent != null) {
            TaskExecutors.INSTANCE.runOnBackground((Function0<Unit>)((Function0)new Function0<Unit>(this, context, intent){
                final /* synthetic */ NotificationBroadcastReceiver this$0;
                final /* synthetic */ Context $context;
                final /* synthetic */ Intent $intent;

                public final void invoke() {
                    try {
                        NotificationBroadcastReceiver.access$displayNotification(this.this$0, this.$context, this.$intent);
                    }
                    catch (Exception e) {
                        NotificationBroadcastReceiver.access$getLog$cp().error((Throwable)e, (Function0)onReceive.1.INSTANCE);
                    }
                }
                {
                    this.this$0 = notificationBroadcastReceiver;
                    this.$context = context;
                    this.$intent = intent;
                    super(0);
                }
            }));
        }
    }

    private final boolean displayNotification(Context context, Intent intent) {
        if (!NotificationHandler.Companion.isHackleIntent(intent)) {
            log.debug((Function0)displayNotification.1.INSTANCE);
            return false;
        }
        Bundle notificationExtras = intent.getExtras();
        if (notificationExtras == null) {
            log.debug((Function0)displayNotification.2.INSTANCE);
            return false;
        }
        NotificationData notificationData = NotificationData.Companion.from(intent);
        if (notificationData == null) {
            log.debug((Function0)displayNotification.3.INSTANCE);
            return false;
        }
        log.debug((Function0)new Function0<String>(notificationData){
            final /* synthetic */ NotificationData $notificationData;

            @NotNull
            public final String invoke() {
                return "Parsed notification data: " + this.$notificationData;
            }
            {
                this.$notificationData = notificationData;
                super(0);
            }
        });
        if (!notificationData.getShowForeground() && this.isAppInForeground(context)) {
            log.debug((Function0)displayNotification.5.INSTANCE);
            return false;
        }
        try {
            Notification notification = NotificationFactory.INSTANCE.createNotification(context, notificationExtras, notificationData);
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"NotificationManagerCompat.from(context)");
            NotificationManagerCompat notificationManager = notificationManagerCompat;
            notificationManager.notify(TAG, notificationData.getNotificationId(), notification);
        }
        catch (Exception e) {
            log.debug((Function0)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    String string2 = this.$e.getMessage();
                    if (string2 == null) {
                        string2 = "Handle notification intent error.";
                    }
                    return string2;
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            return false;
        }
        return true;
    }

    private final boolean isAppInForeground(Context context) {
        Object object = context.getSystemService("keyguard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.KeyguardManager");
        }
        KeyguardManager keyguardManager = (KeyguardManager)object;
        if (keyguardManager.isKeyguardLocked()) {
            return false;
        }
        Object object2 = context.getSystemService("activity");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager activityManager = (ActivityManager)object2;
        List list = activityManager.getRunningAppProcesses();
        if (list == null) {
            return false;
        }
        List appProcesses = list;
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !Intrinsics.areEqual((Object)appProcess.processName, (Object)context.getPackageName())) continue;
            return true;
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = NotificationBroadcastReceiver.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }

    public static final /* synthetic */ boolean access$displayNotification(NotificationBroadcastReceiver $this, Context context, Intent intent) {
        return $this.displayNotification(context, intent);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/hackle/android/ui/notification/NotificationBroadcastReceiver$Companion;", "", "()V", "TAG", "", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "hackle-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

