/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.ui.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.core.app.NotificationCompat;
import com.bumptech.glide.Glide;
import io.hackle.android.ui.notification.NotificationData;
import io.hackle.android.ui.notification.NotificationFactory;
import io.hackle.android.ui.notification.NotificationTrampolineActivity;
import io.hackle.sdk.core.internal.log.Logger;
import io.hackle.sdk.core.internal.log.delegate.DelegatingLoggerFactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/hackle/android/ui/notification/NotificationFactory;", "", "()V", "log", "Lio/hackle/sdk/core/internal/log/Logger;", "createNotification", "Landroid/app/Notification;", "context", "Landroid/content/Context;", "extras", "Landroid/os/Bundle;", "data", "Lio/hackle/android/ui/notification/NotificationData;", "getDefaultNotificationChannelId", "", "loadImageFromUrl", "Landroid/graphics/Bitmap;", "url", "setBigPicture", "", "bigPictureStyle", "Landroidx/core/app/NotificationCompat$BigPictureStyle;", "setBigPictureStyle", "builder", "Landroidx/core/app/NotificationCompat$Builder;", "setBigThumbnailIcon", "setContentIntent", "setContentText", "setContentTitle", "setPriority", "setSmallIcon", "setThumbnailIcon", "setVisibility", "hackle-android-sdk_release"})
public final class NotificationFactory {
    private static final Logger log;
    public static final NotificationFactory INSTANCE;

    @NotNull
    public final Notification createNotification(@NotNull Context context, @NotNull Bundle extras, @NotNull NotificationData data) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String channelId = this.getDefaultNotificationChannelId(context);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelId);
        builder.setAutoCancel(true);
        this.setPriority(builder);
        this.setVisibility(builder);
        this.setSmallIcon(context, builder, data);
        this.setThumbnailIcon(context, builder, data);
        this.setContentTitle(builder, data);
        this.setContentText(builder, data);
        this.setContentIntent(context, builder, extras, data);
        this.setBigPictureStyle(context, builder, data);
        Notification notification = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"builder.build()");
        return notification;
    }

    private final String getDefaultNotificationChannelId(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context.getSystemService("notification");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
            }
            NotificationManager notificationManager = (NotificationManager)object;
            if (notificationManager.getNotificationChannel("io_hackle_android_default_notification_channel_id") == null) {
                log.debug((Function0)getDefaultNotificationChannelId.1.INSTANCE);
                NotificationChannel channel = new NotificationChannel("io_hackle_android_default_notification_channel_id", (CharSequence)"default", 3);
                notificationManager.createNotificationChannel(channel);
                log.debug((Function0)getDefaultNotificationChannelId.2.INSTANCE);
            }
        }
        return "io_hackle_android_default_notification_channel_id";
    }

    private final void setPriority(NotificationCompat.Builder builder) {
        builder.setPriority(0);
    }

    private final void setVisibility(NotificationCompat.Builder builder) {
        builder.setVisibility(1);
    }

    private final void setSmallIcon(Context context, NotificationCompat.Builder builder, NotificationData data) {
        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager\n \u2026ageManager.GET_META_DATA)");
        ApplicationInfo metadata = applicationInfo;
        builder.setSmallIcon(metadata.icon);
        CharSequence charSequence = data.getIconColorFilter();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            try {
                builder.setColor(Color.parseColor((String)data.getIconColorFilter()));
            }
            catch (Exception _) {
                log.debug((Function0)new Function0<String>(data){
                    final /* synthetic */ NotificationData $data;

                    @NotNull
                    public final String invoke() {
                        return "Hex color parsing error: " + this.$data.getIconColorFilter();
                    }
                    {
                        this.$data = notificationData;
                        super(0);
                    }
                });
            }
        }
    }

    private final void setThumbnailIcon(Context context, NotificationCompat.Builder builder, NotificationData data) {
        String string2 = data.getThumbnailImageUrl();
        if (string2 == null) {
            return;
        }
        String imageUrl = string2;
        Bitmap bitmap = this.loadImageFromUrl(context, imageUrl);
        if (bitmap == null) {
            return;
        }
        Bitmap image = bitmap;
        builder.setLargeIcon(image);
    }

    private final void setContentTitle(NotificationCompat.Builder builder, NotificationData data) {
        String string2 = data.getTitle();
        if (string2 == null) {
            return;
        }
        String title = string2;
        builder.setContentTitle((CharSequence)title);
    }

    private final void setContentText(NotificationCompat.Builder builder, NotificationData data) {
        String string2 = data.getBody();
        if (string2 == null) {
            return;
        }
        String body = string2;
        builder.setContentText((CharSequence)body);
    }

    private final void setContentIntent(Context context, NotificationCompat.Builder builder, Bundle extras, NotificationData data) {
        Intent notificationIntent = new Intent(context, NotificationTrampolineActivity.class);
        notificationIntent.setFlags(0x24000000);
        String string2 = data.getLink();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String $this$apply = string3;
            boolean bl3 = false;
            notificationIntent.setData(Uri.parse((String)$this$apply));
        }
        notificationIntent.putExtras(extras);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)((int)System.currentTimeMillis()), (Intent)notificationIntent, (int)0x44000000);
        builder.setContentIntent(pendingIntent);
    }

    private final void setBigPictureStyle(Context context, NotificationCompat.Builder builder, NotificationData data) {
        CharSequence charSequence = data.getLargeImageUrl();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
        this.setBigThumbnailIcon(context, bigPictureStyle, data);
        this.setBigPicture(context, bigPictureStyle, data);
        builder.setStyle((NotificationCompat.Style)bigPictureStyle);
    }

    private final void setBigThumbnailIcon(Context context, NotificationCompat.BigPictureStyle bigPictureStyle, NotificationData data) {
        String string2 = data.getThumbnailImageUrl();
        if (string2 == null) {
            return;
        }
        String imageUrl = string2;
        Bitmap bitmap = this.loadImageFromUrl(context, imageUrl);
        if (bitmap == null) {
            return;
        }
        Bitmap image = bitmap;
        bigPictureStyle.bigLargeIcon(image);
    }

    private final void setBigPicture(Context context, NotificationCompat.BigPictureStyle bigPictureStyle, NotificationData data) {
        String string2 = data.getLargeImageUrl();
        if (string2 == null) {
            return;
        }
        String imageUrl = string2;
        Bitmap bitmap = this.loadImageFromUrl(context, imageUrl);
        if (bitmap == null) {
            return;
        }
        Bitmap image = bitmap;
        bigPictureStyle.bigPicture(image);
    }

    private final Bitmap loadImageFromUrl(Context context, String url) {
        try {
            return (Bitmap)Glide.with((Context)context).asBitmap().load(url).submit().get();
        }
        catch (Exception e) {
            log.debug((Function0)new Function0<String>(url){
                final /* synthetic */ String $url;

                @NotNull
                public final String invoke() {
                    return "Failed to load image: " + this.$url;
                }
                {
                    this.$url = string2;
                    super(0);
                }
            });
            return null;
        }
    }

    private NotificationFactory() {
    }

    static {
        NotificationFactory notificationFactory;
        INSTANCE = notificationFactory = new NotificationFactory();
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        DelegatingLoggerFactory delegatingLoggerFactory = this_$iv.getFactory();
        String string2 = NotificationFactory.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
        log = delegatingLoggerFactory.getLogger(string2);
    }
}

