/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.android.ui.notification;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import io.hackle.android.internal.database.DatabaseHelper;
import io.hackle.android.internal.database.repository.NotificationHistoryRepositoryImpl;
import io.hackle.android.internal.task.TaskExecutors;
import io.hackle.android.ui.notification.DefaultNotificationDataReceiver;
import io.hackle.android.ui.notification.NotificationData;
import io.hackle.android.ui.notification.NotificationDataReceiver;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/hackle/android/ui/notification/NotificationHandler;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "receiver", "Lio/hackle/android/ui/notification/NotificationDataReceiver;", "handleNotificationData", "", "data", "Lio/hackle/android/ui/notification/NotificationData;", "timestamp", "", "setNotificationDataReceiver", "Companion", "hackle-android-sdk_release"})
public final class NotificationHandler {
    private NotificationDataReceiver receiver;
    private static NotificationHandler _instance;
    public static final Companion Companion;

    public final void setNotificationDataReceiver(@NotNull NotificationDataReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        this.receiver = receiver;
    }

    public final void handleNotificationData(@NotNull NotificationData data, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.receiver.onNotificationDataReceived(data, timestamp);
    }

    public static /* synthetic */ void handleNotificationData$default(NotificationHandler notificationHandler, NotificationData notificationData, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        notificationHandler.handleNotificationData(notificationData, l);
    }

    public NotificationHandler(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.receiver = new DefaultNotificationDataReceiver(TaskExecutors.INSTANCE.default(), new NotificationHistoryRepositoryImpl(DatabaseHelper.INSTANCE.getSharedDatabase(context)));
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/hackle/android/ui/notification/NotificationHandler$Companion;", "", "()V", "_instance", "Lio/hackle/android/ui/notification/NotificationHandler;", "getInstance", "context", "Landroid/content/Context;", "isHackleIntent", "", "intent", "Landroid/content/Intent;", "hackle-android-sdk_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final NotificationHandler getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            NotificationHandler notificationHandler = _instance;
            if (notificationHandler == null) {
                boolean bl = false;
                boolean bl2 = false;
                synchronized (this) {
                    boolean bl3 = false;
                    NotificationHandler notificationHandler2 = _instance;
                    if (notificationHandler2 == null) {
                        Context context2 = context.getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
                        NotificationHandler notificationHandler3 = new NotificationHandler(context2);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        NotificationHandler it = notificationHandler3;
                        boolean bl6 = false;
                        _instance = it;
                        notificationHandler2 = notificationHandler3;
                    }
                    NotificationHandler notificationHandler4 = notificationHandler2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl22 : MonitorExitStatement: MONITOREXIT : this
                    notificationHandler = notificationHandler4;
                }
            }
            return notificationHandler;
        }

        public final boolean isHackleIntent(@NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            Bundle bundle = intent.getExtras();
            if (bundle == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"intent.extras ?: return false");
            Bundle extras = bundle;
            return extras.containsKey("hackle");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

