/*
 * Decompiled with CFR 0.152.
 */
package io.hapticlabs.hapticlabsplayer;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import io.hapticlabs.hapticlabsplayer.UtilsKt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/hapticlabs/hapticlabsplayer/LowLatencyAudioPlayer;", "", "filePath", "", "context", "Landroid/content/Context;", "<init>", "(Ljava/lang/String;Landroid/content/Context;)V", "audioTrack", "Landroid/media/AudioTrack;", "extractor", "Landroid/media/MediaExtractor;", "codec", "Landroid/media/MediaCodec;", "info", "Landroid/media/MediaCodec$BufferInfo;", "isEOS", "", "preload", "", "playAudio", "hapticlabsplayer_release"})
public final class LowLatencyAudioPlayer {
    @NotNull
    private final String filePath;
    @NotNull
    private final Context context;
    @Nullable
    private AudioTrack audioTrack;
    @Nullable
    private MediaExtractor extractor;
    @Nullable
    private MediaCodec codec;
    @Nullable
    private MediaCodec.BufferInfo info;
    private boolean isEOS;

    public LowLatencyAudioPlayer(@NotNull String filePath, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.filePath = filePath;
        this.context = context;
    }

    public final void preload() {
        String uncompressedPath = UtilsKt.getUncompressedPath(this.filePath, this.context);
        this.extractor = new MediaExtractor();
        try {
            MediaExtractor mediaExtractor = this.extractor;
            if (mediaExtractor != null) {
                mediaExtractor.setDataSource(uncompressedPath);
            }
            MediaFormat format = null;
            MediaExtractor mediaExtractor2 = this.extractor;
            Intrinsics.checkNotNull((Object)mediaExtractor2);
            int n = mediaExtractor2.getTrackCount();
            for (int i = 0; i < n; ++i) {
                String mime;
                MediaExtractor mediaExtractor3 = this.extractor;
                Intrinsics.checkNotNull((Object)mediaExtractor3);
                format = mediaExtractor3.getTrackFormat(i);
                String string = mime = format.getString("mime");
                boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null) : false;
                if (!bl) continue;
                MediaExtractor mediaExtractor4 = this.extractor;
                Intrinsics.checkNotNull((Object)mediaExtractor4);
                mediaExtractor4.selectTrack(i);
                MediaCodec mediaCodec = this.codec = MediaCodec.createDecoderByType((String)mime);
                if (mediaCodec == null) break;
                mediaCodec.configure(format, null, null, 0);
                break;
            }
            if (this.codec == null) {
                return;
            }
            MediaCodec mediaCodec = this.codec;
            if (mediaCodec != null) {
                mediaCodec.start();
            }
            this.info = new MediaCodec.BufferInfo();
            MediaFormat mediaFormat = format;
            Intrinsics.checkNotNull((Object)mediaFormat);
            int sampleRate = mediaFormat.getInteger("sample-rate");
            int channelCount = format.getInteger("channel-count");
            int channelConfig = channelCount == 1 ? 4 : 12;
            int audioFormat = 2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (!this.isEOS) {
                MediaCodec mediaCodec2 = this.codec;
                Intrinsics.checkNotNull((Object)mediaCodec2);
                int inIndex = mediaCodec2.dequeueInputBuffer(10000L);
                if (inIndex >= 0) {
                    MediaCodec mediaCodec3 = this.codec;
                    Intrinsics.checkNotNull((Object)mediaCodec3);
                    ByteBuffer buffer = mediaCodec3.getInputBuffer(inIndex);
                    if (buffer != null) {
                        MediaExtractor mediaExtractor5 = this.extractor;
                        Intrinsics.checkNotNull((Object)mediaExtractor5);
                        int sampleSize = mediaExtractor5.readSampleData(buffer, 0);
                        if (sampleSize < 0) {
                            MediaCodec mediaCodec4 = this.codec;
                            Intrinsics.checkNotNull((Object)mediaCodec4);
                            mediaCodec4.queueInputBuffer(inIndex, 0, 0, 0L, 4);
                            this.isEOS = true;
                        } else {
                            MediaCodec mediaCodec5 = this.codec;
                            Intrinsics.checkNotNull((Object)mediaCodec5);
                            MediaExtractor mediaExtractor6 = this.extractor;
                            Intrinsics.checkNotNull((Object)mediaExtractor6);
                            mediaCodec5.queueInputBuffer(inIndex, 0, sampleSize, mediaExtractor6.getSampleTime(), 0);
                            MediaExtractor mediaExtractor7 = this.extractor;
                            Intrinsics.checkNotNull((Object)mediaExtractor7);
                            mediaExtractor7.advance();
                        }
                    }
                }
                MediaCodec mediaCodec6 = this.codec;
                Intrinsics.checkNotNull((Object)mediaCodec6);
                MediaCodec.BufferInfo bufferInfo = this.info;
                Intrinsics.checkNotNull((Object)bufferInfo);
                int outIndex = mediaCodec6.dequeueOutputBuffer(bufferInfo, 10000L);
                switch (outIndex) {
                    case -2: {
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        MediaCodec mediaCodec7 = this.codec;
                        Intrinsics.checkNotNull((Object)mediaCodec7);
                        ByteBuffer outBuffer = mediaCodec7.getOutputBuffer(outIndex);
                        MediaCodec.BufferInfo bufferInfo2 = this.info;
                        Intrinsics.checkNotNull((Object)bufferInfo2);
                        byte[] chunk = new byte[bufferInfo2.size];
                        if (outBuffer == null) break;
                        outBuffer.get(chunk);
                        outBuffer.clear();
                        try {
                            byteArrayOutputStream.write(chunk);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        MediaCodec mediaCodec8 = this.codec;
                        Intrinsics.checkNotNull((Object)mediaCodec8);
                        mediaCodec8.releaseOutputBuffer(outIndex, false);
                    }
                }
                MediaCodec.BufferInfo bufferInfo3 = this.info;
                Intrinsics.checkNotNull((Object)bufferInfo3);
                if ((bufferInfo3.flags & 4) == 0) continue;
            }
            MediaCodec mediaCodec9 = this.codec;
            Intrinsics.checkNotNull((Object)mediaCodec9);
            mediaCodec9.stop();
            MediaCodec mediaCodec10 = this.codec;
            Intrinsics.checkNotNull((Object)mediaCodec10);
            mediaCodec10.release();
            MediaExtractor mediaExtractor8 = this.extractor;
            Intrinsics.checkNotNull((Object)mediaExtractor8);
            mediaExtractor8.release();
            byte[] fullBuffer = byteArrayOutputStream.toByteArray();
            AudioTrack audioTrack = this.audioTrack = new AudioTrack.Builder().setAudioAttributes(new AudioAttributes.Builder().setUsage(13).setContentType(4).build()).setAudioFormat(new AudioFormat.Builder().setSampleRate(sampleRate).setChannelMask(channelConfig).setEncoding(audioFormat).build()).setBufferSizeInBytes(fullBuffer.length).setTransferMode(0).build();
            if (audioTrack != null) {
                audioTrack.write(fullBuffer, 0, fullBuffer.length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void playAudio() {
        block0: {
            AudioTrack audioTrack = this.audioTrack;
            if (audioTrack == null) break block0;
            audioTrack.play();
        }
    }
}

