/*
 * Decompiled with CFR 0.152.
 */
package io.hapticlabs.hapticlabsplayer;

import android.content.Context;
import android.os.Build;
import android.os.Vibrator;
import android.os.VibratorManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"isAssetPath", "", "path", "", "context", "Landroid/content/Context;", "getVibrator", "Landroid/os/Vibrator;", "getUncompressedPath", "getUncompressedAssetPath", "assetName", "hapticlabsplayer_release"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nio/hapticlabs/hapticlabsplayer/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class UtilsKt {
    public static final boolean isAssetPath(@NotNull String path, @NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            context.getAssets().open(path).close();
            bl = true;
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final Vibrator getVibrator(@NotNull Context context) {
        Vibrator vibrator;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 31) {
            Object object = context.getSystemService("vibrator_manager");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.VibratorManager");
            VibratorManager vibratorManager = (VibratorManager)object;
            Vibrator vibrator2 = vibratorManager.getDefaultVibrator();
            Intrinsics.checkNotNull((Object)vibrator2);
            vibrator = vibrator2;
        } else {
            Object object = context.getSystemService("vibrator");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.Vibrator");
            vibrator = (Vibrator)object;
        }
        return vibrator;
    }

    @NotNull
    public static final String getUncompressedPath(@NotNull String path, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String normalizedPath = Build.VERSION.SDK_INT >= 26 ? ((Object)Paths.get(path, new String[0]).normalize()).toString() : path;
        return UtilsKt.isAssetPath(normalizedPath, context) ? UtilsKt.getUncompressedAssetPath(normalizedPath, context) : normalizedPath;
    }

    @NotNull
    public static final String getUncompressedAssetPath(@NotNull String assetName, @NotNull Context context) {
        File outFile;
        File outDir;
        Intrinsics.checkNotNullParameter((Object)assetName, (String)"assetName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File uncompressedDir = new File(context.getFilesDir(), "hapticlabsplayer_uncompressed");
        if (!uncompressedDir.exists()) {
            uncompressedDir.mkdirs();
        }
        if ((outDir = (outFile = new File(uncompressedDir, assetName)).getParentFile()) != null && !outDir.exists()) {
            outDir.mkdirs();
        }
        if (outFile.exists()) {
            String string = outFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return string;
        }
        try {
            InputStream inputStream = context.getAssets().open(assetName);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
            InputStream inputStream2 = inputStream;
            FileOutputStream outputStream = new FileOutputStream(outFile);
            byte[] buffer = new byte[1024];
            int length = 0;
            while (true) {
                int n;
                int it = n = inputStream2.read(buffer);
                boolean bl = false;
                length = it;
                if (n <= 0) break;
                outputStream.write(buffer, 0, length);
            }
            inputStream2.close();
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String string = outFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }
}

