/*
 * Decompiled with CFR 0.152.
 */
package io.hapticlabs.hapticlabsplayer;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.audiofx.HapticGenerator;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.os.VibrationEffect;
import android.os.Vibrator;
import androidx.mediarouter.media.MediaRouter;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.hapticlabs.hapticlabsplayer.LowLatencyAudioPlayer;
import io.hapticlabs.hapticlabsplayer.UtilsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0004J\b\u0010\u0011\u001a\u00020\u0007H\u0002J\u001c\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016J\u001c\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016J\u001c\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/hapticlabs/hapticlabsplayer/HapticlabsPlayer;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "hapticSupportLevel", "", "getHapticSupportLevel", "()I", "mediaPlayer", "Landroid/media/MediaPlayer;", "audioPlayer", "handler", "Landroid/os/Handler;", "finalize", "", "determineHapticSupportLevel", "play", "directoryPath", "", "completionCallback", "Lkotlin/Function0;", "playHLA", "path", "playOGG", "playBuiltIn", "name", "hapticlabsplayer_release"})
@SourceDebugExtension(value={"SMAP\nHapticlabsPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HapticlabsPlayer.kt\nio/hapticlabs/hapticlabsplayer/HapticlabsPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1#2:295\n*E\n"})
public final class HapticlabsPlayer {
    @NotNull
    private final Context context;
    private final int hapticSupportLevel;
    @NotNull
    private MediaPlayer mediaPlayer;
    @NotNull
    private MediaPlayer audioPlayer;
    @Nullable
    private Handler handler;

    public HapticlabsPlayer(@NotNull Context context) {
        boolean isAvailable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.hapticSupportLevel = this.determineHapticSupportLevel();
        this.mediaPlayer = new MediaPlayer();
        this.audioPlayer = new MediaPlayer();
        if (Build.VERSION.SDK_INT >= 29) {
            this.mediaPlayer.setAudioAttributes(new AudioAttributes.Builder().setHapticChannelsMuted(false).build());
        }
        if (Build.VERSION.SDK_INT >= 31 && (isAvailable = HapticGenerator.isAvailable())) {
            HapticGenerator hapticGenerator = HapticGenerator.create((int)this.mediaPlayer.getAudioSessionId());
            Intrinsics.checkNotNullExpressionValue((Object)hapticGenerator, (String)"create(...)");
            HapticGenerator generator = hapticGenerator;
            generator.setEnabled(false);
        }
    }

    public final int getHapticSupportLevel() {
        return this.hapticSupportLevel;
    }

    protected final void finalize() {
        this.mediaPlayer.release();
        this.audioPlayer.release();
    }

    private final int determineHapticSupportLevel() {
        Vibrator vibrator = UtilsKt.getVibrator(this.context);
        int level = vibrator.hasVibrator() ? (Build.VERSION.SDK_INT >= 26 && vibrator.hasAmplitudeControl() ? (Build.VERSION.SDK_INT >= 29 && AudioManager.isHapticPlaybackSupported() ? 3 : 2) : 1) : 0;
        return level;
    }

    public final void play(@NotNull String directoryPath, @NotNull Function0<Unit> completionCallback) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
        switch (this.hapticSupportLevel) {
            case 0: {
                return;
            }
            case 1: {
                String path = directoryPath + "/lvl1/main.hla";
                this.playHLA(path, completionCallback);
                return;
            }
            case 2: {
                String path = directoryPath + "/lvl2/main.hla";
                this.playHLA(path, completionCallback);
                return;
            }
            case 3: {
                String path = directoryPath + "/lvl3/main.ogg";
                this.playOGG(path, completionCallback);
                return;
            }
        }
    }

    public final void playHLA(@NotNull String path, @NotNull Function0<Unit> completionCallback) {
        block8: {
            int n;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
            String data = null;
            String uncompressedPath = UtilsKt.getUncompressedPath(path, this.context);
            File file = new File(uncompressedPath);
            FileInputStream fis = new FileInputStream(file);
            byte[] dataBytes = new byte[(int)file.length()];
            fis.read(dataBytes);
            fis.close();
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            data = new String(dataBytes, charset2);
            Gson gson = new Gson();
            JsonObject jsonObject = (JsonObject)gson.fromJson(data, JsonObject.class);
            JsonArray amplitudesArray = jsonObject.getAsJsonArray("Amplitudes");
            int[] amplitudes = new int[amplitudesArray.size()];
            int n2 = amplitudesArray.size();
            for (int i = 0; i < n2; ++i) {
                amplitudes[i] = Math.abs(amplitudesArray.get(i).getAsInt());
            }
            int repeat = jsonObject.get("Repeat").getAsInt();
            JsonArray timingsArray = jsonObject.getAsJsonArray("Timings");
            long[] timings = new long[timingsArray.size()];
            int n3 = timingsArray.size();
            for (int i = 0; i < n3; ++i) {
                timings[i] = timingsArray.get(i).getAsLong();
            }
            long durationMs = jsonObject.get("Duration").getAsLong();
            JsonArray audiosArray = jsonObject.getAsJsonArray("Audios");
            if (Build.VERSION.SDK_INT < 26) break block8;
            VibrationEffect vibrationEffect = VibrationEffect.createWaveform((long[])timings, (int[])amplitudes, (int)repeat);
            Vibrator vibrator = UtilsKt.getVibrator(this.context);
            int n4 = 0;
            int n5 = audiosArray.size();
            LowLatencyAudioPlayer[] lowLatencyAudioPlayerArray = new LowLatencyAudioPlayer[n5];
            while (n4 < n5) {
                n = n4++;
                lowLatencyAudioPlayerArray[n] = new LowLatencyAudioPlayer("", this.context);
            }
            LowLatencyAudioPlayer[] audioTrackPlayers = lowLatencyAudioPlayerArray;
            int[] audioDelays = new int[audiosArray.size()];
            String audioDirectoryPath = StringsKt.substringBeforeLast$default((String)path, (char)'/', null, (int)2, null);
            n = audiosArray.size();
            for (int i = 0; i < n; ++i) {
                JsonObject audioObject = audiosArray.get(i).getAsJsonObject();
                int time = audioObject.get("Time").getAsInt();
                String fileName = audioDirectoryPath + "/" + audioObject.get("Filename").getAsString();
                LowLatencyAudioPlayer audioTrackPlayer = new LowLatencyAudioPlayer(fileName, this.context);
                audioTrackPlayer.preload();
                audioTrackPlayers[i] = audioTrackPlayer;
                audioDelays[i] = time;
            }
            int syncDelay = 0;
            if (this.handler == null) {
                this.handler = new Handler(Looper.getMainLooper());
            }
            long startTime = SystemClock.uptimeMillis() + (long)syncDelay;
            int n6 = audiosArray.size();
            for (int i = 0; i < n6; ++i) {
                Handler handler = this.handler;
                if (handler == null) continue;
                handler.postAtTime(() -> HapticlabsPlayer.playHLA$lambda$0(audioTrackPlayers, i), startTime + (long)audioDelays[i]);
            }
            Handler handler = this.handler;
            if (handler != null) {
                handler.postAtTime(() -> HapticlabsPlayer.playHLA$lambda$1(vibrator, vibrationEffect), startTime);
            }
            Handler handler2 = this.handler;
            if (handler2 != null) {
                handler2.postAtTime(() -> HapticlabsPlayer.playHLA$lambda$2(completionCallback), startTime + durationMs);
            }
        }
    }

    public final void playOGG(@NotNull String path, @NotNull Function0<Unit> completionCallback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
        String uncompressedPath = UtilsKt.getUncompressedPath(path, this.context);
        this.mediaPlayer.release();
        this.mediaPlayer = new MediaPlayer();
        AudioAttributes.Builder mediaPlayerAudioAttributes = new AudioAttributes.Builder().setUsage(14).setContentType(4);
        if (Build.VERSION.SDK_INT >= 29) {
            mediaPlayerAudioAttributes.setHapticChannelsMuted(false);
        }
        this.mediaPlayer.setAudioAttributes(mediaPlayerAudioAttributes.build());
        this.mediaPlayer.setDataSource(uncompressedPath);
        MediaRouter mediaRouter = MediaRouter.getInstance((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)mediaRouter, (String)"getInstance(...)");
        MediaRouter router = mediaRouter;
        boolean useSeparateAudio = false;
        if (!router.getSelectedRoute().isDeviceSpeaker()) {
            AudioDeviceInfo builtInSpeaker;
            AudioDeviceInfo audioDeviceInfo;
            block10: {
                Object object = this.context.getSystemService("audio");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
                AudioManager audioManager = (AudioManager)object;
                AudioDeviceInfo[] outputDevices = audioManager.getDevices(2);
                Intrinsics.checkNotNull((Object)outputDevices);
                AudioDeviceInfo[] audioDeviceInfoArray = outputDevices;
                int n = audioDeviceInfoArray.length;
                for (int i = 0; i < n; ++i) {
                    AudioDeviceInfo audioDeviceInfo2;
                    AudioDeviceInfo it = audioDeviceInfo2 = audioDeviceInfoArray[i];
                    boolean bl = false;
                    if (!(it.getType() == 2)) continue;
                    audioDeviceInfo = audioDeviceInfo2;
                    break block10;
                }
                audioDeviceInfo = null;
            }
            AudioDeviceInfo it = builtInSpeaker = audioDeviceInfo;
            boolean bl = false;
            useSeparateAudio = true;
            this.audioPlayer.release();
            this.audioPlayer = new MediaPlayer();
            AudioAttributes.Builder audioPlayerAttributesBuilder = new AudioAttributes.Builder().setUsage(14).setContentType(4);
            if (Build.VERSION.SDK_INT >= 29) {
                audioPlayerAttributesBuilder.setHapticChannelsMuted(true);
            }
            this.audioPlayer.setAudioAttributes(audioPlayerAttributesBuilder.build());
            this.mediaPlayer.setVolume(0.0f, 0.0f);
            if (Build.VERSION.SDK_INT >= 28) {
                this.mediaPlayer.setPreferredDevice(builtInSpeaker);
            }
            this.audioPlayer.setDataSource(uncompressedPath);
            try {
                this.audioPlayer.prepare();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.mediaPlayer.prepare();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (useSeparateAudio) {
            this.audioPlayer.start();
        }
        this.mediaPlayer.start();
        this.mediaPlayer.setOnCompletionListener(arg_0 -> HapticlabsPlayer.playOGG$lambda$5(completionCallback, arg_0));
    }

    public final void playBuiltIn(@NotNull String name) {
        block16: {
            Integer effect;
            Integer n;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (Build.VERSION.SDK_INT < 29) break block16;
            switch (name) {
                case "Click": {
                    n = 0;
                    break;
                }
                case "Double Click": {
                    n = 1;
                    break;
                }
                case "Heavy Click": {
                    n = 5;
                    break;
                }
                case "Tick": {
                    n = 2;
                    break;
                }
                default: {
                    n = null;
                }
            }
            Integer n2 = effect = n;
            if (n2 == null) break block16;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            UtilsKt.getVibrator(this.context).vibrate(VibrationEffect.createPredefined((int)it));
        }
    }

    private static final void playHLA$lambda$0(LowLatencyAudioPlayer[] $audioTrackPlayers, int $i) {
        Intrinsics.checkNotNullParameter((Object)$audioTrackPlayers, (String)"$audioTrackPlayers");
        $audioTrackPlayers[$i].playAudio();
    }

    private static final void playHLA$lambda$1(Vibrator $vibrator, VibrationEffect $vibrationEffect) {
        Intrinsics.checkNotNullParameter((Object)$vibrator, (String)"$vibrator");
        $vibrator.vibrate($vibrationEffect);
    }

    private static final void playHLA$lambda$2(Function0 $completionCallback) {
        Intrinsics.checkNotNullParameter((Object)$completionCallback, (String)"$completionCallback");
        $completionCallback.invoke();
    }

    private static final void playOGG$lambda$5(Function0 $completionCallback, MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)$completionCallback, (String)"$completionCallback");
        $completionCallback.invoke();
    }
}

