/*
 * Decompiled with CFR 0.152.
 */
package io.hapticlabs.hapticlabsplayer;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.media.audiofx.HapticGenerator;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.os.VibrationEffect;
import android.os.Vibrator;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.hapticlabs.hapticlabsplayer.HapticCapabilities;
import io.hapticlabs.hapticlabsplayer.LoadedOGG;
import io.hapticlabs.hapticlabsplayer.LowLatencyAudioPlayer;
import io.hapticlabs.hapticlabsplayer.UtilsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0004J\b\u0010\u001d\u001a\u00020\u0007H\u0002J\u001c\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!J\u001c\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!JF\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001126\u0010 \u001a2\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\u001c0&J\u001c\u0010,\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!J\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0013j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/hapticlabs/hapticlabsplayer/HapticlabsPlayer;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "hapticsCapabilities", "Lio/hapticlabs/hapticlabsplayer/HapticCapabilities;", "getHapticsCapabilities", "()Lio/hapticlabs/hapticlabsplayer/HapticCapabilities;", "mediaPlayer", "Landroid/media/MediaPlayer;", "audioPlayer", "oggPool", "Landroid/media/SoundPool;", "poolMap", "Lkotlin/collections/HashMap;", "", "Lio/hapticlabs/hapticlabsplayer/LoadedOGG;", "Ljava/util/HashMap;", "Ljava/util/HashMap;", "poolMutex", "Ljava/util/concurrent/locks/ReentrantLock;", "handler", "Landroid/os/Handler;", "isBuiltInSpeakerSelected", "", "finalize", "", "determineHapticCapabilities", "play", "directoryPath", "completionCallback", "Lkotlin/Function0;", "playHLA", "path", "ensureOGGIsLoaded", "uncompressedPath", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "soundId", "duration", "playOGG", "playBuiltIn", "hapticlabsplayer_release"})
@SourceDebugExtension(value={"SMAP\nHapticlabsPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HapticlabsPlayer.kt\nio/hapticlabs/hapticlabsplayer/HapticlabsPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,423:1\n1#2:424\n*E\n"})
public final class HapticlabsPlayer {
    @NotNull
    private final Context context;
    @NotNull
    private final HapticCapabilities hapticsCapabilities;
    @NotNull
    private MediaPlayer mediaPlayer;
    @NotNull
    private MediaPlayer audioPlayer;
    @NotNull
    private SoundPool oggPool;
    @NotNull
    private HashMap<String, LoadedOGG> poolMap;
    @NotNull
    private ReentrantLock poolMutex;
    @NotNull
    private Handler handler;
    private boolean isBuiltInSpeakerSelected;

    public HapticlabsPlayer(@NotNull Context context) {
        boolean isAvailable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.hapticsCapabilities = this.determineHapticCapabilities();
        this.poolMap = new HashMap();
        this.poolMutex = new ReentrantLock();
        this.isBuiltInSpeakerSelected = true;
        this.mediaPlayer = new MediaPlayer();
        this.audioPlayer = new MediaPlayer();
        if (Build.VERSION.SDK_INT >= 29) {
            this.mediaPlayer.setAudioAttributes(new AudioAttributes.Builder().setHapticChannelsMuted(false).build());
        }
        if (Build.VERSION.SDK_INT >= 31 && (isAvailable = HapticGenerator.isAvailable())) {
            HapticGenerator hapticGenerator = HapticGenerator.create((int)this.mediaPlayer.getAudioSessionId());
            Intrinsics.checkNotNullExpressionValue((Object)hapticGenerator, (String)"create(...)");
            HapticGenerator generator = hapticGenerator;
            generator.setEnabled(false);
        }
        AudioAttributes.Builder oggPoolAudioAttributes = new AudioAttributes.Builder().setUsage(14).setContentType(4);
        if (Build.VERSION.SDK_INT >= 29) {
            oggPoolAudioAttributes.setHapticChannelsMuted(false);
        }
        this.oggPool = new SoundPool.Builder().setAudioAttributes(oggPoolAudioAttributes.build()).build();
        this.handler = new Handler(Looper.getMainLooper());
        this.handler.post(() -> HapticlabsPlayer._init_$lambda$0(this));
    }

    @NotNull
    public final HapticCapabilities getHapticsCapabilities() {
        return this.hapticsCapabilities;
    }

    protected final void finalize() {
        this.mediaPlayer.release();
        this.audioPlayer.release();
        this.oggPool.release();
    }

    private final HapticCapabilities determineHapticCapabilities() {
        Vibrator vibrator = UtilsKt.getVibrator(this.context);
        boolean supportsOnOff = vibrator.hasVibrator();
        boolean supportsAmplitudeControl = Build.VERSION.SDK_INT >= 26 && vibrator.hasAmplitudeControl();
        boolean supportsAudioCoupled = Build.VERSION.SDK_INT >= 29 && AudioManager.isHapticPlaybackSupported();
        return new HapticCapabilities(supportsOnOff, supportsAmplitudeControl, supportsAudioCoupled, Build.VERSION.SDK_INT >= 36 && vibrator.areEnvelopeEffectsSupported(), Build.VERSION.SDK_INT >= 34 ? vibrator.getResonantFrequency() : Float.NaN, Build.VERSION.SDK_INT >= 36 ? vibrator.getFrequencyProfile() : null, Build.VERSION.SDK_INT >= 34 ? UtilsKt.getVibrator(this.context).getQFactor() : Float.NaN, Build.VERSION.SDK_INT >= 36 ? UtilsKt.getVibrator(this.context).getEnvelopeEffectInfo() : null, supportsOnOff ? (supportsAmplitudeControl ? (supportsAudioCoupled ? 3 : 2) : 1) : 0);
    }

    public final void play(@NotNull String directoryPath, @NotNull Function0<Unit> completionCallback) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
        switch (this.hapticsCapabilities.getHapticSupportLevel()) {
            case 0: {
                return;
            }
            case 1: {
                String path = directoryPath + "/lvl1/main.hla";
                this.playHLA(path, completionCallback);
                return;
            }
            case 2: {
                String path = directoryPath + "/lvl2/main.hla";
                this.playHLA(path, completionCallback);
                return;
            }
            case 3: {
                String path = directoryPath + "/lvl3/main.ogg";
                this.playOGG(path, completionCallback);
                return;
            }
        }
    }

    public final void playHLA(@NotNull String path, @NotNull Function0<Unit> completionCallback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
        String data = null;
        String uncompressedPath = UtilsKt.getUncompressedPath(path, this.context);
        File file = new File(uncompressedPath);
        FileInputStream fis = new FileInputStream(file);
        byte[] dataBytes = new byte[(int)file.length()];
        fis.read(dataBytes);
        fis.close();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        data = new String(dataBytes, charset2);
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(data, JsonObject.class);
        JsonArray amplitudesArray = jsonObject.getAsJsonArray("Amplitudes");
        int[] amplitudes = new int[amplitudesArray.size()];
        int n = amplitudesArray.size();
        for (int i = 0; i < n; ++i) {
            amplitudes[i] = Math.abs(amplitudesArray.get(i).getAsInt());
        }
        int repeat = jsonObject.get("Repeat").getAsInt();
        JsonArray timingsArray = jsonObject.getAsJsonArray("Timings");
        long[] timings = new long[timingsArray.size()];
        int n2 = timingsArray.size();
        for (int i = 0; i < n2; ++i) {
            timings[i] = timingsArray.get(i).getAsLong();
        }
        long durationMs = jsonObject.get("Duration").getAsLong();
        JsonArray audiosArray = jsonObject.getAsJsonArray("Audios");
        if (Build.VERSION.SDK_INT >= 26) {
            int n3;
            VibrationEffect vibrationEffect = VibrationEffect.createWaveform((long[])timings, (int[])amplitudes, (int)repeat);
            Vibrator vibrator = UtilsKt.getVibrator(this.context);
            int n4 = 0;
            int n5 = audiosArray.size();
            LowLatencyAudioPlayer[] lowLatencyAudioPlayerArray = new LowLatencyAudioPlayer[n5];
            while (n4 < n5) {
                n3 = n4++;
                lowLatencyAudioPlayerArray[n3] = new LowLatencyAudioPlayer("", this.context);
            }
            LowLatencyAudioPlayer[] audioTrackPlayers = lowLatencyAudioPlayerArray;
            int[] audioDelays = new int[audiosArray.size()];
            String audioDirectoryPath = StringsKt.substringBeforeLast$default((String)path, (char)'/', null, (int)2, null);
            n3 = audiosArray.size();
            for (int i = 0; i < n3; ++i) {
                JsonObject audioObject = audiosArray.get(i).getAsJsonObject();
                int time = audioObject.get("Time").getAsInt();
                String fileName = audioDirectoryPath + "/" + audioObject.get("Filename").getAsString();
                LowLatencyAudioPlayer audioTrackPlayer = new LowLatencyAudioPlayer(fileName, this.context);
                audioTrackPlayer.preload();
                audioTrackPlayers[i] = audioTrackPlayer;
                audioDelays[i] = time;
            }
            int syncDelay = 0;
            long startTime = SystemClock.uptimeMillis() + (long)syncDelay;
            int n6 = audiosArray.size();
            for (int i = 0; i < n6; ++i) {
                this.handler.postAtTime(() -> HapticlabsPlayer.playHLA$lambda$1(audioTrackPlayers, i), startTime + (long)audioDelays[i]);
            }
            this.handler.postAtTime(() -> HapticlabsPlayer.playHLA$lambda$2(vibrator, vibrationEffect), startTime);
            this.handler.postAtTime(() -> HapticlabsPlayer.playHLA$lambda$3(completionCallback), startTime + durationMs);
        }
    }

    public final void ensureOGGIsLoaded(@NotNull String uncompressedPath, @NotNull Function2<? super Integer, ? super Integer, Unit> completionCallback) {
        Intrinsics.checkNotNullParameter((Object)uncompressedPath, (String)"uncompressedPath");
        Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
        LoadedOGG loadedOGG = this.poolMap.get(uncompressedPath);
        if (loadedOGG != null) {
            LoadedOGG it = loadedOGG;
            boolean bl = false;
            completionCallback.invoke((Object)it.getSoundId(), (Object)it.getDuration());
            System.out.println((Object)"Cached my dude");
            return;
        }
        MediaPlayer player = new MediaPlayer();
        player.setDataSource(uncompressedPath);
        player.prepare();
        int duration = player.getDuration();
        player.release();
        Ref.IntRef soundId = new Ref.IntRef();
        soundId.element = -1;
        this.poolMutex.lock();
        this.oggPool.setOnLoadCompleteListener((arg_0, arg_1, arg_2) -> HapticlabsPlayer.ensureOGGIsLoaded$lambda$5(this, soundId, uncompressedPath, duration, completionCallback, arg_0, arg_1, arg_2));
        soundId.element = this.oggPool.load(uncompressedPath, 1);
        this.poolMutex.unlock();
    }

    public final void playOGG(@NotNull String path, @NotNull Function0<Unit> completionCallback) {
        AudioDeviceInfo builtInSpeaker;
        AudioDeviceInfo audioDeviceInfo;
        boolean useSeparateAudio;
        String uncompressedPath;
        block11: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
            uncompressedPath = UtilsKt.getUncompressedPath(path, this.context);
            if (this.isBuiltInSpeakerSelected) {
                this.ensureOGGIsLoaded(uncompressedPath, (Function2<? super Integer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> HapticlabsPlayer.playOGG$lambda$7(this, completionCallback, arg_0, arg_1)));
                return;
            }
            this.mediaPlayer.release();
            this.mediaPlayer = new MediaPlayer();
            AudioAttributes.Builder mediaPlayerAudioAttributes = new AudioAttributes.Builder().setUsage(14).setContentType(4);
            if (Build.VERSION.SDK_INT >= 29) {
                mediaPlayerAudioAttributes.setHapticChannelsMuted(false);
            }
            this.mediaPlayer.setAudioAttributes(mediaPlayerAudioAttributes.build());
            this.mediaPlayer.setDataSource(uncompressedPath);
            useSeparateAudio = false;
            Object object = this.context.getSystemService("audio");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
            AudioManager audioManager = (AudioManager)object;
            AudioDeviceInfo[] outputDevices = audioManager.getDevices(2);
            Intrinsics.checkNotNull((Object)outputDevices);
            AudioDeviceInfo[] audioDeviceInfoArray = outputDevices;
            int n = audioDeviceInfoArray.length;
            for (int i = 0; i < n; ++i) {
                AudioDeviceInfo audioDeviceInfo2;
                AudioDeviceInfo it = audioDeviceInfo2 = audioDeviceInfoArray[i];
                boolean bl = false;
                if (!(it.getType() == 2)) continue;
                audioDeviceInfo = audioDeviceInfo2;
                break block11;
            }
            audioDeviceInfo = null;
        }
        AudioDeviceInfo audioDeviceInfo3 = builtInSpeaker = audioDeviceInfo;
        if (audioDeviceInfo3 != null) {
            AudioDeviceInfo it = audioDeviceInfo3;
            boolean bl = false;
            useSeparateAudio = true;
            this.audioPlayer.release();
            this.audioPlayer = new MediaPlayer();
            AudioAttributes.Builder audioPlayerAttributesBuilder = new AudioAttributes.Builder().setUsage(14).setContentType(4);
            if (Build.VERSION.SDK_INT >= 29) {
                audioPlayerAttributesBuilder.setHapticChannelsMuted(true);
            }
            this.audioPlayer.setAudioAttributes(audioPlayerAttributesBuilder.build());
            this.mediaPlayer.setVolume(0.0f, 0.0f);
            if (Build.VERSION.SDK_INT >= 28) {
                this.mediaPlayer.setPreferredDevice(builtInSpeaker);
            }
            this.audioPlayer.setDataSource(uncompressedPath);
            try {
                this.audioPlayer.prepare();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.mediaPlayer.prepare();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (useSeparateAudio) {
            this.audioPlayer.start();
        }
        this.mediaPlayer.start();
        this.mediaPlayer.setOnCompletionListener(arg_0 -> HapticlabsPlayer.playOGG$lambda$10(completionCallback, arg_0));
    }

    public final void playBuiltIn(@NotNull String name) {
        block16: {
            Integer effect;
            Integer n;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (Build.VERSION.SDK_INT < 29) break block16;
            switch (name) {
                case "Click": {
                    n = 0;
                    break;
                }
                case "Double Click": {
                    n = 1;
                    break;
                }
                case "Heavy Click": {
                    n = 5;
                    break;
                }
                case "Tick": {
                    n = 2;
                    break;
                }
                default: {
                    n = null;
                }
            }
            Integer n2 = effect = n;
            if (n2 == null) break block16;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            UtilsKt.getVibrator(this.context).vibrate(VibrationEffect.createPredefined((int)it));
        }
    }

    private static final void _init_$lambda$0(HapticlabsPlayer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MediaRouter mediaRouter = MediaRouter.getInstance((Context)this$0.context);
        Intrinsics.checkNotNullExpressionValue((Object)mediaRouter, (String)"getInstance(...)");
        MediaRouter mediaRouter2 = mediaRouter;
        MediaRouteSelector mediaRouteSelector = new MediaRouteSelector.Builder().addControlCategory("android.media.intent.category.LIVE_AUDIO").build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaRouteSelector, (String)"build(...)");
        MediaRouteSelector selector = mediaRouteSelector;
        MediaRouter.Callback mediaRouterCallback2 = new MediaRouter.Callback(this$0){
            final /* synthetic */ HapticlabsPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRouteSelected(MediaRouter router, MediaRouter.RouteInfo route) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                Intrinsics.checkNotNullParameter((Object)route, (String)"route");
                HapticlabsPlayer.access$setBuiltInSpeakerSelected$p(this.this$0, router.getSelectedRoute().isDeviceSpeaker());
            }

            public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo route) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                Intrinsics.checkNotNullParameter((Object)route, (String)"route");
                HapticlabsPlayer.access$setBuiltInSpeakerSelected$p(this.this$0, router.getSelectedRoute().isDeviceSpeaker());
            }

            public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo route) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                Intrinsics.checkNotNullParameter((Object)route, (String)"route");
                HapticlabsPlayer.access$setBuiltInSpeakerSelected$p(this.this$0, router.getSelectedRoute().isDeviceSpeaker());
            }
        };
        mediaRouter2.addCallback(selector, mediaRouterCallback2);
    }

    private static final void playHLA$lambda$1(LowLatencyAudioPlayer[] $audioTrackPlayers, int $i) {
        Intrinsics.checkNotNullParameter((Object)$audioTrackPlayers, (String)"$audioTrackPlayers");
        $audioTrackPlayers[$i].playAudio();
    }

    private static final void playHLA$lambda$2(Vibrator $vibrator, VibrationEffect $vibrationEffect) {
        Intrinsics.checkNotNullParameter((Object)$vibrator, (String)"$vibrator");
        $vibrator.vibrate($vibrationEffect);
    }

    private static final void playHLA$lambda$3(Function0 $completionCallback) {
        Intrinsics.checkNotNullParameter((Object)$completionCallback, (String)"$completionCallback");
        $completionCallback.invoke();
    }

    private static final void ensureOGGIsLoaded$lambda$5(HapticlabsPlayer this$0, Ref.IntRef $soundId, String $uncompressedPath, int $duration, Function2 $completionCallback, SoundPool soundPool, int sampleId, int status) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$soundId, (String)"$soundId");
        Intrinsics.checkNotNullParameter((Object)$uncompressedPath, (String)"$uncompressedPath");
        Intrinsics.checkNotNullParameter((Object)$completionCallback, (String)"$completionCallback");
        this$0.poolMutex.lock();
        if (status == 0 && sampleId == $soundId.element) {
            ((Map)this$0.poolMap).put($uncompressedPath, new LoadedOGG($duration, $soundId.element));
            $completionCallback.invoke((Object)$soundId.element, (Object)$duration);
        }
        this$0.poolMutex.unlock();
    }

    private static final void playOGG$lambda$7$lambda$6(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final Unit playOGG$lambda$7(HapticlabsPlayer this$0, Function0 $completionCallback, int soundId, int duration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$completionCallback, (String)"$completionCallback");
        this$0.oggPool.play(soundId, 1.0f, 1.0f, 1, 0, 1.0f);
        this$0.handler.postDelayed(() -> HapticlabsPlayer.playOGG$lambda$7$lambda$6($completionCallback), (long)duration);
        return Unit.INSTANCE;
    }

    private static final void playOGG$lambda$10(Function0 $completionCallback, MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)$completionCallback, (String)"$completionCallback");
        $completionCallback.invoke();
    }

    public static final /* synthetic */ void access$setBuiltInSpeakerSelected$p(HapticlabsPlayer $this, boolean bl) {
        $this.isBuiltInSpeakerSelected = bl;
    }
}

