/*
 * Decompiled with CFR 0.152.
 */
package io.hapticlabs.hapticlabsplayer;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.MediaMetadataRetriever;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.media.audiofx.HapticGenerator;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.os.VibrationEffect;
import android.os.Vibrator;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.hapticlabs.hapticlabsplayer.HapticCapabilities;
import io.hapticlabs.hapticlabsplayer.LoadedOGG;
import io.hapticlabs.hapticlabsplayer.LowLatencyAudioPlayer;
import io.hapticlabs.hapticlabsplayer.UtilsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0004J\b\u0010\"\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011H\u0002J\u001c\u0010%\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00112\f\u0010&\u001a\b\u0012\u0004\u0012\u00020 0'J\u001c\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00112\f\u0010&\u001a\b\u0012\u0004\u0012\u00020 0'J\u000e\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0011J\u0010\u0010,\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0011H\u0002J\u000e\u0010-\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0011J\u000e\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020\u0011J\u0010\u00100\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0011H\u0002J\u000e\u00101\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0011J\u000e\u00102\u001a\u00020 2\u0006\u0010/\u001a\u00020\u0011J\u0006\u00103\u001a\u00020 J\u0012\u00104\u001a\u0004\u0018\u00010\u00122\u0006\u0010+\u001a\u00020\u0011H\u0002J\u0010\u00105\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0011H\u0002J\u001c\u00106\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00112\f\u0010&\u001a\b\u0012\u0004\u0012\u00020 0'J\u000e\u00107\u001a\u00020 2\u0006\u00108\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0013j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R \u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0018j\b\u0012\u0004\u0012\u00020\u0017`\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lio/hapticlabs/hapticlabsplayer/HapticlabsPlayer;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "hapticsCapabilities", "Lio/hapticlabs/hapticlabsplayer/HapticCapabilities;", "getHapticsCapabilities", "()Lio/hapticlabs/hapticlabsplayer/HapticCapabilities;", "mediaPlayer", "Landroid/media/MediaPlayer;", "audioPlayer", "oggPool", "Landroid/media/SoundPool;", "poolMap", "Lkotlin/collections/HashMap;", "", "Lio/hapticlabs/hapticlabsplayer/LoadedOGG;", "Ljava/util/HashMap;", "Ljava/util/HashMap;", "loadedSoundsSet", "Lkotlin/collections/HashSet;", "", "Ljava/util/HashSet;", "Ljava/util/HashSet;", "handler", "Landroid/os/Handler;", "isBuiltInSpeakerSelected", "", "SOUNDPOOL_BITS_PER_SAMPLE", "setUpSoundPool", "", "finalize", "determineHapticCapabilities", "directoryPathToOGG", "directoryPath", "play", "completionCallback", "Lkotlin/Function0;", "playHLA", "path", "canOGGBeLoadedToSoundPool", "uncompressedPath", "preloadUncompressedPath", "preload", "preloadOGG", "oggPath", "unloadUncompressedPath", "unload", "unloadOGG", "unloadAll", "getOGGSoundId", "loadOGG", "playOGG", "playBuiltIn", "name", "hapticlabsplayer_release"})
@SourceDebugExtension(value={"SMAP\nHapticlabsPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HapticlabsPlayer.kt\nio/hapticlabs/hapticlabsplayer/HapticlabsPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,531:1\n1#2:532\n*E\n"})
public final class HapticlabsPlayer {
    @NotNull
    private final Context context;
    @NotNull
    private final HapticCapabilities hapticsCapabilities;
    @NotNull
    private MediaPlayer mediaPlayer;
    @NotNull
    private MediaPlayer audioPlayer;
    @NotNull
    private SoundPool oggPool;
    @NotNull
    private HashMap<String, LoadedOGG> poolMap;
    @NotNull
    private HashSet<Integer> loadedSoundsSet;
    @NotNull
    private Handler handler;
    private boolean isBuiltInSpeakerSelected;
    private final int SOUNDPOOL_BITS_PER_SAMPLE;

    public HapticlabsPlayer(@NotNull Context context) {
        boolean isAvailable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.hapticsCapabilities = this.determineHapticCapabilities();
        this.poolMap = new HashMap();
        this.loadedSoundsSet = new HashSet();
        this.isBuiltInSpeakerSelected = true;
        this.SOUNDPOOL_BITS_PER_SAMPLE = 16;
        this.mediaPlayer = new MediaPlayer();
        this.audioPlayer = new MediaPlayer();
        if (Build.VERSION.SDK_INT >= 29) {
            this.mediaPlayer.setAudioAttributes(new AudioAttributes.Builder().setHapticChannelsMuted(false).build());
        }
        if (Build.VERSION.SDK_INT >= 31 && (isAvailable = HapticGenerator.isAvailable())) {
            HapticGenerator hapticGenerator = HapticGenerator.create((int)this.mediaPlayer.getAudioSessionId());
            Intrinsics.checkNotNullExpressionValue((Object)hapticGenerator, (String)"create(...)");
            HapticGenerator generator = hapticGenerator;
            generator.setEnabled(false);
        }
        this.oggPool = new SoundPool.Builder().build();
        this.oggPool.release();
        this.setUpSoundPool();
        this.handler = new Handler(Looper.getMainLooper());
        this.handler.post(() -> HapticlabsPlayer._init_$lambda$0(this));
    }

    @NotNull
    public final HapticCapabilities getHapticsCapabilities() {
        return this.hapticsCapabilities;
    }

    private final void setUpSoundPool() {
        AudioAttributes.Builder oggPoolAudioAttributes = new AudioAttributes.Builder().setUsage(14).setContentType(4);
        if (Build.VERSION.SDK_INT >= 29) {
            oggPoolAudioAttributes.setHapticChannelsMuted(false);
        }
        this.oggPool = new SoundPool.Builder().setAudioAttributes(oggPoolAudioAttributes.build()).build();
        this.oggPool.setOnLoadCompleteListener((arg_0, arg_1, arg_2) -> HapticlabsPlayer.setUpSoundPool$lambda$1(this, arg_0, arg_1, arg_2));
    }

    protected final void finalize() {
        this.mediaPlayer.release();
        this.audioPlayer.release();
        this.oggPool.release();
    }

    private final HapticCapabilities determineHapticCapabilities() {
        Vibrator vibrator = UtilsKt.getVibrator(this.context);
        boolean supportsOnOff = vibrator.hasVibrator();
        boolean supportsAmplitudeControl = Build.VERSION.SDK_INT >= 26 && vibrator.hasAmplitudeControl();
        boolean supportsAudioCoupled = Build.VERSION.SDK_INT >= 29 && AudioManager.isHapticPlaybackSupported();
        return new HapticCapabilities(supportsOnOff, supportsAmplitudeControl, supportsAudioCoupled, Build.VERSION.SDK_INT >= 36 && vibrator.areEnvelopeEffectsSupported(), Build.VERSION.SDK_INT >= 34 ? vibrator.getResonantFrequency() : Float.NaN, Build.VERSION.SDK_INT >= 36 ? vibrator.getFrequencyProfile() : null, Build.VERSION.SDK_INT >= 34 ? UtilsKt.getVibrator(this.context).getQFactor() : Float.NaN, Build.VERSION.SDK_INT >= 36 ? UtilsKt.getVibrator(this.context).getEnvelopeEffectInfo() : null, supportsOnOff ? (supportsAmplitudeControl ? (supportsAudioCoupled ? 3 : 2) : 1) : 0);
    }

    private final String directoryPathToOGG(String directoryPath) {
        return directoryPath + "/lvl3/main.ogg";
    }

    public final void play(@NotNull String directoryPath, @NotNull Function0<Unit> completionCallback) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
        switch (this.hapticsCapabilities.getHapticSupportLevel()) {
            case 0: {
                return;
            }
            case 1: {
                String path = directoryPath + "/lvl1/main.hla";
                this.playHLA(path, completionCallback);
                return;
            }
            case 2: {
                String path = directoryPath + "/lvl2/main.hla";
                this.playHLA(path, completionCallback);
                return;
            }
            case 3: {
                String path = this.directoryPathToOGG(directoryPath);
                this.playOGG(path, completionCallback);
                return;
            }
        }
    }

    public final void playHLA(@NotNull String path, @NotNull Function0<Unit> completionCallback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
        String data = null;
        String uncompressedPath = UtilsKt.getUncompressedPath(path, this.context);
        File file = new File(uncompressedPath);
        FileInputStream fis = new FileInputStream(file);
        byte[] dataBytes = new byte[(int)file.length()];
        fis.read(dataBytes);
        fis.close();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        data = new String(dataBytes, charset2);
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(data, JsonObject.class);
        JsonArray amplitudesArray = jsonObject.getAsJsonArray("Amplitudes");
        int[] amplitudes = new int[amplitudesArray.size()];
        int n = amplitudesArray.size();
        for (int i = 0; i < n; ++i) {
            amplitudes[i] = Math.abs(amplitudesArray.get(i).getAsInt());
        }
        int repeat = jsonObject.get("Repeat").getAsInt();
        JsonArray timingsArray = jsonObject.getAsJsonArray("Timings");
        long[] timings = new long[timingsArray.size()];
        int n2 = timingsArray.size();
        for (int i = 0; i < n2; ++i) {
            timings[i] = timingsArray.get(i).getAsLong();
        }
        long durationMs = jsonObject.get("Duration").getAsLong();
        JsonArray audiosArray = jsonObject.getAsJsonArray("Audios");
        if (Build.VERSION.SDK_INT >= 26) {
            int n3;
            VibrationEffect vibrationEffect = VibrationEffect.createWaveform((long[])timings, (int[])amplitudes, (int)repeat);
            Vibrator vibrator = UtilsKt.getVibrator(this.context);
            int n4 = 0;
            int n5 = audiosArray.size();
            LowLatencyAudioPlayer[] lowLatencyAudioPlayerArray = new LowLatencyAudioPlayer[n5];
            while (n4 < n5) {
                n3 = n4++;
                lowLatencyAudioPlayerArray[n3] = new LowLatencyAudioPlayer("", this.context);
            }
            LowLatencyAudioPlayer[] audioTrackPlayers = lowLatencyAudioPlayerArray;
            int[] audioDelays = new int[audiosArray.size()];
            String audioDirectoryPath = StringsKt.substringBeforeLast$default((String)path, (char)'/', null, (int)2, null);
            n3 = audiosArray.size();
            for (int i = 0; i < n3; ++i) {
                JsonObject audioObject = audiosArray.get(i).getAsJsonObject();
                int time = audioObject.get("Time").getAsInt();
                String fileName = audioDirectoryPath + "/" + audioObject.get("Filename").getAsString();
                LowLatencyAudioPlayer audioTrackPlayer = new LowLatencyAudioPlayer(fileName, this.context);
                audioTrackPlayer.preload();
                audioTrackPlayers[i] = audioTrackPlayer;
                audioDelays[i] = time;
            }
            int syncDelay = 0;
            long startTime = SystemClock.uptimeMillis() + (long)syncDelay;
            int n6 = audiosArray.size();
            for (int i = 0; i < n6; ++i) {
                this.handler.postAtTime(() -> HapticlabsPlayer.playHLA$lambda$2(audioTrackPlayers, i), startTime + (long)audioDelays[i]);
            }
            this.handler.postAtTime(() -> HapticlabsPlayer.playHLA$lambda$3(vibrator, vibrationEffect), startTime);
            this.handler.postAtTime(() -> HapticlabsPlayer.playHLA$lambda$4(completionCallback), startTime + durationMs);
        }
    }

    public final boolean canOGGBeLoadedToSoundPool(@NotNull String uncompressedPath) {
        Long l;
        Integer durationMs;
        Intrinsics.checkNotNullParameter((Object)uncompressedPath, (String)"uncompressedPath");
        if (this.poolMap.containsKey(uncompressedPath)) {
            return true;
        }
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(uncompressedPath);
        String string = retriever.extractMetadata(9);
        Integer n = durationMs = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        if (Build.VERSION.SDK_INT >= 31) {
            String string2 = retriever.extractMetadata(38);
            l = string2 != null ? Long.valueOf(Long.parseLong(string2)) : null;
        } else {
            l = 48000L;
        }
        Long sampleRateHz = l;
        int channelCount = 3;
        if (durationMs == null || sampleRateHz == null) {
            return false;
        }
        long totalBitsConsumed = (long)(this.SOUNDPOOL_BITS_PER_SAMPLE * channelCount * durationMs) * sampleRateHz / (long)1000;
        return totalBitsConsumed < 8000000L;
    }

    private final void preloadUncompressedPath(String uncompressedPath) {
        if (this.hapticsCapabilities.getSupportsAudioCoupled()) {
            this.loadOGG(uncompressedPath);
        }
    }

    public final void preload(@NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        String uncompressedPath = UtilsKt.getUncompressedPath(this.directoryPathToOGG(directoryPath), this.context);
        this.preloadUncompressedPath(uncompressedPath);
    }

    public final void preloadOGG(@NotNull String oggPath) {
        Intrinsics.checkNotNullParameter((Object)oggPath, (String)"oggPath");
        String uncompressedPath = UtilsKt.getUncompressedPath(oggPath, this.context);
        this.preloadUncompressedPath(uncompressedPath);
    }

    private final void unloadUncompressedPath(String uncompressedPath) {
        block0: {
            LoadedOGG loaded;
            LoadedOGG loadedOGG = loaded = this.poolMap.get(uncompressedPath);
            if (loadedOGG == null) break block0;
            int it = loadedOGG.getSoundId();
            boolean bl = false;
            this.oggPool.unload(it);
            this.poolMap.remove(uncompressedPath);
            this.loadedSoundsSet.remove(it);
        }
    }

    public final void unload(@NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        String uncompressedPath = UtilsKt.getUncompressedPath(this.directoryPathToOGG(directoryPath), this.context);
        this.unloadUncompressedPath(uncompressedPath);
    }

    public final void unloadOGG(@NotNull String oggPath) {
        Intrinsics.checkNotNullParameter((Object)oggPath, (String)"oggPath");
        String uncompressedPath = UtilsKt.getUncompressedPath(oggPath, this.context);
        this.unloadUncompressedPath(uncompressedPath);
    }

    public final void unloadAll() {
        this.oggPool.release();
        this.setUpSoundPool();
        this.poolMap.clear();
    }

    private final LoadedOGG getOGGSoundId(String uncompressedPath) {
        LoadedOGG loadedOGG = this.poolMap.get(uncompressedPath);
        if (loadedOGG != null) {
            LoadedOGG it = loadedOGG;
            boolean bl = false;
            return this.loadedSoundsSet.contains(it.getSoundId()) ? it : null;
        }
        return null;
    }

    private final void loadOGG(String uncompressedPath) {
        LoadedOGG loadedOGG = this.poolMap.get(uncompressedPath);
        if (loadedOGG != null) {
            LoadedOGG it = loadedOGG;
            boolean bl = false;
            return;
        }
        if (this.canOGGBeLoadedToSoundPool(uncompressedPath)) {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource(uncompressedPath);
            String string = retriever.extractMetadata(9);
            int durationMs = string != null ? Integer.parseInt(string) : 0;
            ((Map)this.poolMap).put(uncompressedPath, new LoadedOGG(durationMs, this.oggPool.load(uncompressedPath, 1)));
        }
    }

    public final void playOGG(@NotNull String path, @NotNull Function0<Unit> completionCallback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
        String uncompressedPath = UtilsKt.getUncompressedPath(path, this.context);
        LoadedOGG loadedSound = this.getOGGSoundId(uncompressedPath);
        if (this.isBuiltInSpeakerSelected && loadedSound != null) {
            this.oggPool.play(loadedSound.getSoundId(), 1.0f, 1.0f, 1, 0, 1.0f);
            System.out.println((Object)("Playing OGG from SoundPool: " + uncompressedPath));
            this.handler.postDelayed(() -> HapticlabsPlayer.playOGG$lambda$8(completionCallback), (long)loadedSound.getDuration());
            return;
        }
        this.mediaPlayer.release();
        this.mediaPlayer = new MediaPlayer();
        AudioAttributes.Builder mediaPlayerAudioAttributes = new AudioAttributes.Builder().setUsage(14).setContentType(4);
        if (Build.VERSION.SDK_INT >= 29) {
            mediaPlayerAudioAttributes.setHapticChannelsMuted(false);
        }
        this.mediaPlayer.setAudioAttributes(mediaPlayerAudioAttributes.build());
        this.mediaPlayer.setDataSource(uncompressedPath);
        boolean useSeparateAudio = false;
        if (!this.isBuiltInSpeakerSelected) {
            AudioDeviceInfo builtInSpeaker;
            AudioDeviceInfo audioDeviceInfo;
            block12: {
                Object object = this.context.getSystemService("audio");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
                AudioManager audioManager = (AudioManager)object;
                AudioDeviceInfo[] outputDevices = audioManager.getDevices(2);
                Intrinsics.checkNotNull((Object)outputDevices);
                AudioDeviceInfo[] audioDeviceInfoArray = outputDevices;
                int n = audioDeviceInfoArray.length;
                for (int i = 0; i < n; ++i) {
                    AudioDeviceInfo audioDeviceInfo2;
                    AudioDeviceInfo it = audioDeviceInfo2 = audioDeviceInfoArray[i];
                    boolean bl = false;
                    if (!(it.getType() == 2)) continue;
                    audioDeviceInfo = audioDeviceInfo2;
                    break block12;
                }
                audioDeviceInfo = null;
            }
            AudioDeviceInfo audioDeviceInfo3 = builtInSpeaker = audioDeviceInfo;
            if (audioDeviceInfo3 != null) {
                AudioDeviceInfo it = audioDeviceInfo3;
                boolean bl = false;
                useSeparateAudio = true;
                this.audioPlayer.release();
                this.audioPlayer = new MediaPlayer();
                AudioAttributes.Builder audioPlayerAttributesBuilder = new AudioAttributes.Builder().setUsage(14).setContentType(4);
                if (Build.VERSION.SDK_INT >= 29) {
                    audioPlayerAttributesBuilder.setHapticChannelsMuted(true);
                }
                this.audioPlayer.setAudioAttributes(audioPlayerAttributesBuilder.build());
                this.mediaPlayer.setVolume(0.0f, 0.0f);
                if (Build.VERSION.SDK_INT >= 28) {
                    this.mediaPlayer.setPreferredDevice(builtInSpeaker);
                }
                this.audioPlayer.setDataSource(uncompressedPath);
                try {
                    this.audioPlayer.prepare();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.mediaPlayer.prepare();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (useSeparateAudio) {
            this.audioPlayer.start();
        }
        this.mediaPlayer.start();
        System.out.println((Object)("Playing OGG from MediaPlayer: " + uncompressedPath));
        this.mediaPlayer.setOnCompletionListener(arg_0 -> HapticlabsPlayer.playOGG$lambda$11(completionCallback, arg_0));
    }

    public final void playBuiltIn(@NotNull String name) {
        block16: {
            Integer effect;
            Integer n;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (Build.VERSION.SDK_INT < 29) break block16;
            switch (name) {
                case "Click": {
                    n = 0;
                    break;
                }
                case "Double Click": {
                    n = 1;
                    break;
                }
                case "Heavy Click": {
                    n = 5;
                    break;
                }
                case "Tick": {
                    n = 2;
                    break;
                }
                default: {
                    n = null;
                }
            }
            Integer n2 = effect = n;
            if (n2 == null) break block16;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            UtilsKt.getVibrator(this.context).vibrate(VibrationEffect.createPredefined((int)it));
        }
    }

    private static final void _init_$lambda$0(HapticlabsPlayer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MediaRouter mediaRouter = MediaRouter.getInstance((Context)this$0.context);
        Intrinsics.checkNotNullExpressionValue((Object)mediaRouter, (String)"getInstance(...)");
        MediaRouter mediaRouter2 = mediaRouter;
        MediaRouteSelector mediaRouteSelector = new MediaRouteSelector.Builder().addControlCategory("android.media.intent.category.LIVE_AUDIO").build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaRouteSelector, (String)"build(...)");
        MediaRouteSelector selector = mediaRouteSelector;
        MediaRouter.Callback mediaRouterCallback2 = new MediaRouter.Callback(this$0){
            final /* synthetic */ HapticlabsPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRouteSelected(MediaRouter router, MediaRouter.RouteInfo route) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                Intrinsics.checkNotNullParameter((Object)route, (String)"route");
                HapticlabsPlayer.access$setBuiltInSpeakerSelected$p(this.this$0, router.getSelectedRoute().isDeviceSpeaker());
            }

            public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo route) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                Intrinsics.checkNotNullParameter((Object)route, (String)"route");
                HapticlabsPlayer.access$setBuiltInSpeakerSelected$p(this.this$0, router.getSelectedRoute().isDeviceSpeaker());
            }

            public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo route) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                Intrinsics.checkNotNullParameter((Object)route, (String)"route");
                HapticlabsPlayer.access$setBuiltInSpeakerSelected$p(this.this$0, router.getSelectedRoute().isDeviceSpeaker());
            }
        };
        mediaRouter2.addCallback(selector, mediaRouterCallback2);
    }

    private static final void setUpSoundPool$lambda$1(HapticlabsPlayer this$0, SoundPool soundPool, int sampleId, int status) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (status == 0) {
            this$0.loadedSoundsSet.add(sampleId);
        }
    }

    private static final void playHLA$lambda$2(LowLatencyAudioPlayer[] $audioTrackPlayers, int $i) {
        Intrinsics.checkNotNullParameter((Object)$audioTrackPlayers, (String)"$audioTrackPlayers");
        $audioTrackPlayers[$i].playAudio();
    }

    private static final void playHLA$lambda$3(Vibrator $vibrator, VibrationEffect $vibrationEffect) {
        Intrinsics.checkNotNullParameter((Object)$vibrator, (String)"$vibrator");
        $vibrator.vibrate($vibrationEffect);
    }

    private static final void playHLA$lambda$4(Function0 $completionCallback) {
        Intrinsics.checkNotNullParameter((Object)$completionCallback, (String)"$completionCallback");
        $completionCallback.invoke();
    }

    private static final void playOGG$lambda$8(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void playOGG$lambda$11(Function0 $completionCallback, MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)$completionCallback, (String)"$completionCallback");
        $completionCallback.invoke();
    }

    public static final /* synthetic */ void access$setBuiltInSpeakerSelected$p(HapticlabsPlayer $this, boolean bl) {
        $this.isBuiltInSpeakerSelected = bl;
    }
}

