/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.embedded;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Options {
    private final List<Option> options = new ArrayList<Option>();
    private String warLocation;
    private String war;
    private String contextPath = "/hawtio";
    private String plugins = "plugins";
    private Integer port = 8080;
    private String extraClassPath;
    private boolean help;
    private boolean jointServerThread;
    private boolean openUrl = true;

    public void init() {
        this.addOption(new Option("h", "help", "Displays the help screen"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                Options.this.help = true;
            }
        });
        this.addOption(new ParameterOption("j", "join", "Join server thread"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Options.this.jointServerThread = Boolean.valueOf(parameter);
            }
        });
        this.addOption(new ParameterOption("w", "war", "War file or directory of the hawtio web application"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Options.this.war = parameter;
            }
        });
        this.addOption(new ParameterOption("l", "warLocation", "Directory to search for .war files"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Options.this.warLocation = parameter;
            }
        });
        this.addOption(new ParameterOption("pd", "pluginsDir", "Directory to search for .war files to install as 3rd party plugins"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Options.this.plugins = parameter;
            }
        });
        this.addOption(new ParameterOption("c", "contextPath", "Context path"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (!parameter.startsWith("/")) {
                    Options.this.contextPath = "/" + parameter;
                } else {
                    Options.this.contextPath = parameter;
                }
            }
        });
        this.addOption(new ParameterOption("p", "port", "Port number"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                try {
                    Options.this.port = Integer.parseInt(parameter);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid port number " + parameter + " due " + e.getMessage());
                }
            }
        });
        this.addOption(new ParameterOption("ecp", "extraClassPath", "Extra classpath"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Options.this.extraClassPath = parameter;
            }
        });
        this.addOption(new ParameterOption("ou", "openUrl", "Open the web console automatic in the web browser"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Options.this.openUrl = Boolean.valueOf(parameter);
            }
        });
    }

    private void addOption(Option option) {
        this.options.add(option);
    }

    public void showOptions() {
        System.out.println("hawtio takes the following options");
        System.out.println();
        for (Option option : this.options) {
            System.out.println(option.getInformation());
        }
        System.out.println();
        System.out.println();
    }

    public String usedOptionsSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Using options [");
        if (this.war != null) {
            sb.append("\n\twar=").append(this.war);
        }
        if (this.warLocation != null) {
            sb.append("\n\twarLocation=").append(this.warLocation);
        }
        if (this.contextPath != null) {
            sb.append("\n\tcontextPath=").append(this.contextPath);
        }
        if (this.port != null) {
            sb.append("\n\tport=").append(this.port);
        }
        if (this.extraClassPath != null) {
            sb.append("\n\textraClassPath=").append(this.extraClassPath);
        }
        if (this.plugins != null) {
            sb.append("\n\tplugins=").append(this.plugins);
        }
        sb.append("\n\topenUrl=").append(this.openUrl);
        sb.append("\n\tjointServerThread=").append(this.jointServerThread);
        sb.append("\n\thelp=").append(this.help);
        sb.append("]");
        return sb.toString();
    }

    public boolean parseArguments(String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        boolean valid = true;
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            boolean handled = false;
            for (Option option : this.options) {
                if (!option.processOption(arg, args)) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            System.out.println("Error: Unknown option: " + arg);
            System.out.println();
            valid = false;
            break;
        }
        return valid;
    }

    public String getWar() {
        return this.war;
    }

    public void setWar(String war) {
        this.war = war;
    }

    public String getWarLocation() {
        return this.warLocation;
    }

    public void setWarLocation(String warLocation) {
        this.warLocation = warLocation;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getPlugins() {
        return this.plugins;
    }

    public void setPlugins(String plugins) {
        this.plugins = plugins;
    }

    public String getExtraClassPath() {
        return this.extraClassPath;
    }

    public void setExtraClassPath(String extraClassPath) {
        this.extraClassPath = extraClassPath;
    }

    public boolean isJointServerThread() {
        return this.jointServerThread;
    }

    public void setJointServerThread(boolean jointServerThread) {
        this.jointServerThread = jointServerThread;
    }

    public boolean isOpenUrl() {
        return this.openUrl;
    }

    public void setOpenUrl(boolean openUrl) {
        this.openUrl = openUrl;
    }

    public boolean isHelp() {
        return this.help;
    }

    private abstract class ParameterOption
    extends Option {
        protected ParameterOption(String abbreviation, String fullName, String description) {
            super(abbreviation, fullName, description);
        }

        @Override
        protected void doProcess(String arg, LinkedList<String> remainingArgs) {
            if (remainingArgs.isEmpty()) {
                System.err.println("Expected fileName for ");
                Options.this.showOptions();
            } else {
                String parameter = remainingArgs.removeFirst();
                this.doProcess(arg, parameter, remainingArgs);
            }
        }

        @Override
        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, String var2, LinkedList<String> var3);
    }

    private abstract class Option {
        private String abbreviation;
        private String fullName;
        private String description;

        protected Option(String abbreviation, String fullName, String description) {
            this.abbreviation = "-" + abbreviation;
            this.fullName = "--" + fullName;
            this.description = description;
        }

        public boolean processOption(String arg, LinkedList<String> remainingArgs) {
            if (arg.equalsIgnoreCase(this.abbreviation) || this.fullName.startsWith(arg)) {
                this.doProcess(arg, remainingArgs);
                return true;
            }
            return false;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, LinkedList<String> var2);
    }
}

