/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.introspect;

import io.hawt.introspect.ClassLoaderProvider;
import io.hawt.introspect.Introspections;
import io.hawt.introspect.IntrospectorMXBean;
import io.hawt.introspect.PropertyDTO;
import io.hawt.introspect.support.ClassScanner;
import io.hawt.util.MBeanSupport;
import io.hawt.util.Strings;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector
extends MBeanSupport
implements IntrospectorMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(Introspector.class);
    private static Introspector singleton;
    private ClassScanner classScanner = new ClassScanner(new ClassLoader[0]);

    public static Introspector getSingleton() {
        if (singleton == null) {
            LOG.warn("No Introspector constructed yet so using default configuration for now");
            singleton = new Introspector();
        }
        return singleton;
    }

    @Override
    public void init() throws Exception {
        singleton = this;
        this.findClassNames("", null);
        super.init();
    }

    @Override
    protected String getDefaultObjectName() {
        return "io.hawt.introspect:type=Introspector";
    }

    public void setClassLoaderProvider(String id, ClassLoaderProvider classLoaderProvider) {
        this.classScanner.setClassLoaderProvider(id, classLoaderProvider);
    }

    @Override
    public SortedSet<String> findClassNames(String search, Integer limit) {
        return this.getClassScanner().findClassNames(search, limit);
    }

    @Override
    public List<PropertyDTO> getProperties(String className) throws Exception {
        Class<?> aClass = this.getClassScanner().findClass(className);
        return this.getProperties(aClass);
    }

    public List<PropertyDTO> getProperties(Class<?> aClass) throws Exception {
        ArrayList<PropertyDTO> answer = new ArrayList<PropertyDTO>();
        if (aClass != null) {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = java.beans.Introspector.getBeanInfo(aClass);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                if (propertyDescriptor.getName().equals("class")) continue;
                PropertyDTO info = new PropertyDTO(propertyDescriptor);
                answer.add(info);
            }
        }
        return answer;
    }

    @Override
    public List<PropertyDTO> findProperties(String className, String filter) throws Exception {
        List<PropertyDTO> properties = this.getProperties(className);
        if (Strings.isNotBlank(filter)) {
            String[] propertyPaths = filter.split("\\.");
            String firstPrefix = "";
            PropertyDTO lastNavigation = null;
            int idx = 0;
            StringBuilder prefixBuilder = new StringBuilder();
            for (String propertyPath : propertyPaths) {
                boolean last;
                PropertyDTO property = Introspections.findPropertyByName(properties, propertyPath);
                boolean bl = last = ++idx == propertyPaths.length;
                if (property == null) break;
                lastNavigation = property;
                List<PropertyDTO> childProperties = this.getProperties(property.getTypeClass());
                if (childProperties.size() <= 0) break;
                properties = childProperties;
                firstPrefix = prefixBuilder.toString();
                prefixBuilder.append(propertyPath);
                prefixBuilder.append(".");
            }
            if (lastNavigation != null) {
                ArrayList<PropertyDTO> answer = new ArrayList<PropertyDTO>();
                answer.add(lastNavigation);
                answer.addAll(properties);
                String nestedPrefix = prefixBuilder.toString();
                String prefix = firstPrefix;
                for (PropertyDTO dto : answer) {
                    dto.setName(prefix + dto.getName());
                    prefix = nestedPrefix;
                }
                return answer;
            }
        }
        return properties;
    }

    public ClassScanner getClassScanner() {
        return this.classScanner;
    }

    public void setClassScanner(ClassScanner classScanner) {
        this.classScanner = classScanner;
    }
}

