/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.introspect.support;

import io.hawt.introspect.support.ClassScanner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Packages {
    private static final transient Logger LOG = LoggerFactory.getLogger(Packages.class);

    public static Package[] findPackagesForClassLoader(ClassLoader loader) {
        IntrospectClassLoader introspectClassLoader = new IntrospectClassLoader(loader);
        return introspectClassLoader.getPackages();
    }

    public static Map<Package, ClassLoader[]> getPackageMap(List<ClassLoader> classLoaders) {
        HashMap<Package, ClassLoader[]> answer = new HashMap<Package, ClassLoader[]>();
        ClassLoader[] globalClassLoaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassScanner.class.getClassLoader()};
        HashSet packages = new HashSet();
        Packages.add(answer, Package.getPackages(), globalClassLoaders);
        ClassLoader[] classLoaderArray = new ClassLoader[classLoaders.size()];
        classLoaders.toArray(classLoaderArray);
        for (ClassLoader classLoader : classLoaders) {
            Package[] loaderPackages = Packages.findPackagesForClassLoader(classLoader);
            Packages.add(answer, loaderPackages, classLoaderArray);
        }
        TreeSet<String> names = new TreeSet<String>();
        for (Package aPackage : packages) {
            names.add(aPackage.getName());
        }
        for (String name : names) {
            LOG.info("Got package " + name);
        }
        return answer;
    }

    protected static void add(Map<Package, ClassLoader[]> answer, Package[] packages, ClassLoader[] classLoaders) {
        if (packages != null) {
            for (Package aPackage : packages) {
                answer.put(aPackage, classLoaders);
            }
        }
    }

    protected static class IntrospectClassLoader
    extends ClassLoader {
        public IntrospectClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Package[] getPackages() {
            return super.getPackages();
        }

        public Package getPackage(String name) {
            return super.getPackage(name);
        }
    }
}

