/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.blueprint;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;

public class HawtioBlueprintContextListener
implements ServletContextListener {
    public static final String CONTAINER_ATTRIBUTE = "org.apache.aries.blueprint.container";
    public static final String LOCATION = "blueprintLocation";
    public static final String PROPERTIES = "blueprintProperties";
    public static final String DEFAULT_LOCATION = "META-INF/blueprint.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        String location = servletContext.getInitParameter(LOCATION);
        if (location == null) {
            location = DEFAULT_LOCATION;
        }
        ArrayList<URL> resourcePaths = new ArrayList<URL>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources(location);
            while (resources.hasMoreElements()) {
                resourcePaths.add(resources.nextElement());
            }
            Collections.sort(resourcePaths, new /* Unavailable Anonymous Inner Class!! */);
            servletContext.log("Loading Blueprint contexts " + resourcePaths);
            HashMap<String, String> properties = new HashMap<String, String>();
            String propLocations = servletContext.getInitParameter(PROPERTIES);
            if (propLocations != null) {
                for (String propLoc : propLocations.split(",")) {
                    Enumeration<URL> propUrl = classLoader.getResources(propLoc);
                    while (propUrl.hasMoreElements()) {
                        URL url = propUrl.nextElement();
                        try (InputStream is = url.openStream();){
                            Properties props = new Properties();
                            props.load(is);
                            Enumeration<?> names = props.propertyNames();
                            while (names.hasMoreElements()) {
                                String key = names.nextElement().toString();
                                properties.put(key, props.getProperty(key));
                            }
                        }
                    }
                }
            }
            this.appendEnvironmentVariablesAndSystemProperties(servletContext, properties);
            BlueprintContainerImpl container = new BlueprintContainerImpl(classLoader, resourcePaths, properties, true);
            servletContext.setAttribute(CONTAINER_ATTRIBUTE, (Object)container);
        }
        catch (Exception e) {
            servletContext.log("Failed to startup blueprint container. " + e, (Throwable)e);
        }
    }

    protected void appendEnvironmentVariablesAndSystemProperties(ServletContext servletContext, Map<String, String> properties) {
        try {
            Properties sysProperties = System.getProperties();
            Set<Map.Entry<Object, Object>> sysEntries = sysProperties.entrySet();
            for (Map.Entry<Object, Object> sysEntry : sysEntries) {
                Object key = sysEntry.getKey();
                Object value = sysEntry.getValue();
                if (key == null || value == null) continue;
                String propertyName = key.toString();
                String propertyValue = value.toString();
                if (properties.containsKey(propertyName)) continue;
                properties.put(propertyName, propertyValue);
            }
            Map<String, String> env = System.getenv();
            if (env != null) {
                Set<Map.Entry<String, String>> entries = env.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    String name = entry.getKey();
                    String propertyName = this.convertEnvironmentVariableToSystemProperty(name);
                    properties.put(propertyName, entry.getValue());
                }
            }
        }
        catch (Exception e) {
            servletContext.log("Failed to load environment variables: " + e, (Throwable)e);
        }
    }

    protected String convertEnvironmentVariableToSystemProperty(String name) {
        return name.replace('_', '.');
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        Object container = servletContext.getAttribute(CONTAINER_ATTRIBUTE);
        if (container instanceof BlueprintContainerImpl) {
            BlueprintContainerImpl blueprint = (BlueprintContainerImpl)container;
            blueprint.destroy();
        }
    }
}

